/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareview;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareviewHead;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareviewItem;
import com.els.modules.supplier.enumerate.CertificatedSourceTypeEnum;
import com.els.modules.supplier.enumerate.SupplierAccessMgmtQuareviewStatusEnum;
import com.els.modules.supplier.mapper.PurchaseCertificatedInfoMapper;
import com.els.modules.supplier.mapper.SupplierAccessMgmtQuareviewHeadMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.modules.supplier.service.SaleCertificatedInfoService;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewHeadService;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewItemService;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewService;
import com.els.modules.supplier.vo.ShiftCertificationVO;
import com.els.modules.supplier.vo.SupplierAccessMgmtQuareviewHeadVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierAccessMgmtQuareviewHeadServiceImpl
extends BaseServiceImpl<SupplierAccessMgmtQuareviewHeadMapper, SupplierAccessMgmtQuareviewHead>
implements SupplierAccessMgmtQuareviewHeadService {
    @Autowired
    private SupplierAccessMgmtQuareviewItemService supplierAccessMgmtQuareviewItemService;
    @Autowired
    private SupplierAccessMgmtQuareviewService supplierAccessMgmtQuareviewService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService invokeEnterpriseRpcService;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;
    @Autowired
    private PurchaseCertificatedInfoMapper purchaseCertificatedInfoMapper;
    @Autowired
    private SaleCertificatedInfoService saleCertificatedInfoService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, List<SupplierAccessMgmtQuareviewItem> supplierAccessMgmtQuareviewItemList) {
        ElsEnterpriseInfoDTO info;
        supplierAccessMgmtQuareviewHead.setId(null);
        if (StrUtil.isBlank((CharSequence)supplierAccessMgmtQuareviewHead.getQuareviewStatus())) {
            supplierAccessMgmtQuareviewHead.setQuareviewStatus(SupplierAccessMgmtQuareviewStatusEnum.NEW.getValue());
        }
        if ((info = this.invokeEnterpriseRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            supplierAccessMgmtQuareviewHead.setPurchaseName(info.getName());
        }
        supplierAccessMgmtQuareviewHead.setQuareviewNumber(this.invokeBaseRpcService.getNextCode("accessMgmtQuareviewNumber", (Object)supplierAccessMgmtQuareviewHead));
        supplierAccessMgmtQuareviewHead.setBusAccount(TenantContext.getTenant());
        ((SupplierAccessMgmtQuareviewHeadMapper)this.baseMapper).insert((Object)supplierAccessMgmtQuareviewHead);
        super.setHeadDefaultValue((BaseEntity)supplierAccessMgmtQuareviewHead);
        this.insertData(supplierAccessMgmtQuareviewHead, supplierAccessMgmtQuareviewItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, List<SupplierAccessMgmtQuareviewItem> supplierAccessMgmtQuareviewItemList) {
        int count = ((SupplierAccessMgmtQuareviewHeadMapper)this.baseMapper).updateById((Object)supplierAccessMgmtQuareviewHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.insertData(supplierAccessMgmtQuareviewHead, supplierAccessMgmtQuareviewItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void submitMain(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, List<SupplierAccessMgmtQuareviewItem> supplierAccessMgmtQuareviewItemList) {
        if (SupplierAccessMgmtQuareviewStatusEnum.PASS.getValue().equals(supplierAccessMgmtQuareviewHead.getQuareviewStatus()) || SupplierAccessMgmtQuareviewStatusEnum.UN_CENSORED.getValue().equals(supplierAccessMgmtQuareviewHead.getQuareviewStatus())) {
            this.checkCertificationDate(supplierAccessMgmtQuareviewItemList);
        }
        if (StrUtil.isNotBlank((CharSequence)supplierAccessMgmtQuareviewHead.getId())) {
            this.updateMain(supplierAccessMgmtQuareviewHead, supplierAccessMgmtQuareviewItemList);
        } else {
            this.saveMain(supplierAccessMgmtQuareviewHead, supplierAccessMgmtQuareviewItemList);
        }
        if (StrUtil.isNotBlank((CharSequence)supplierAccessMgmtQuareviewHead.getQuareviewStatus()) && SupplierAccessMgmtQuareviewStatusEnum.WAITE_REPLY.getValue().equals(supplierAccessMgmtQuareviewHead.getQuareviewStatus())) {
            super.sendMessage(supplierAccessMgmtQuareviewHead.getElsAccount(), "accessMgmtQuareview", "purchaseSubmit", supplierAccessMgmtQuareviewHead.getId(), "accessMgmtQuareviewBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{supplierAccessMgmtQuareviewHead.getToElsAccount()}));
        }
        if (StrUtil.isNotBlank((CharSequence)supplierAccessMgmtQuareviewHead.getQuareviewStatus()) && SupplierAccessMgmtQuareviewStatusEnum.PASS.getValue().equals(supplierAccessMgmtQuareviewHead.getQuareviewStatus())) {
            super.sendMessage(supplierAccessMgmtQuareviewHead.getElsAccount(), "accessMgmtQuareview", "purchaseReviewPass", supplierAccessMgmtQuareviewHead.getId(), "accessMgmtQuareviewBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{supplierAccessMgmtQuareviewHead.getElsAccount()}));
        }
    }

    @Override
    public void updStatus(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead) {
        super.updateById((Object)supplierAccessMgmtQuareviewHead);
        supplierAccessMgmtQuareviewHead = (SupplierAccessMgmtQuareviewHead)((Object)((SupplierAccessMgmtQuareviewHeadMapper)this.baseMapper).selectById((Serializable)((Object)supplierAccessMgmtQuareviewHead)));
        if (StrUtil.isNotBlank((CharSequence)supplierAccessMgmtQuareviewHead.getQuareviewStatus()) && SupplierAccessMgmtQuareviewStatusEnum.PASS.getValue().equals(supplierAccessMgmtQuareviewHead.getQuareviewStatus())) {
            super.sendMessage(supplierAccessMgmtQuareviewHead.getElsAccount(), "accessMgmtQuareview", "purchaseReviewPass", supplierAccessMgmtQuareviewHead.getId(), "accessMgmtQuareviewBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{supplierAccessMgmtQuareviewHead.getElsAccount()}));
        }
        if (StrUtil.isNotBlank((CharSequence)supplierAccessMgmtQuareviewHead.getQuareviewStatus()) && SupplierAccessMgmtQuareviewStatusEnum.NO_PASS.getValue().equals(supplierAccessMgmtQuareviewHead.getQuareviewStatus())) {
            super.sendMessage(supplierAccessMgmtQuareviewHead.getElsAccount(), "accessMgmtQuareview", "purchaseReviewReject", supplierAccessMgmtQuareviewHead.getId(), "accessMgmtQuareviewBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{supplierAccessMgmtQuareviewHead.getToElsAccount()}));
        }
    }

    @Override
    public void invalid(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead) {
        supplierAccessMgmtQuareviewHead.setQuareviewStatus(SupplierAccessMgmtQuareviewStatusEnum.INVALID.getValue());
        super.updateById((Object)supplierAccessMgmtQuareviewHead);
    }

    private void checkCertificationDate(List<SupplierAccessMgmtQuareviewItem> supplierAccessMgmtQuareviewItemList) {
        if (!CollectionUtils.isEmpty(supplierAccessMgmtQuareviewItemList)) {
            long effectiveDate = 0L;
            long expiryDate = 0L;
            long certificationDate = 0L;
            for (SupplierAccessMgmtQuareviewItem entity : supplierAccessMgmtQuareviewItemList) {
                if (!"1".equals(entity.getLimited())) continue;
                if (entity.getEffectiveDate() == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOLVW_f027d72e", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                effectiveDate = entity.getEffectiveDate().getTime();
                if (entity.getExpiryDate() == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAxOLVW_e0d38940", (String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                expiryDate = entity.getExpiryDate().getTime();
                if (entity.getCertificationDate() != null) {
                    certificationDate = entity.getCertificationDate().getTime();
                }
                if (effectiveDate > 0L && expiryDate == 0L) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBASrWKXBAlSW_45dd225c", (String)"\u751f\u6548\u65e5\u671f\u586b\u4e86\uff0c\u5931\u6548\u65e5\u671f\u5fc5\u586b\uff01"));
                }
                if (effectiveDate == 0L && expiryDate > 0L) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBASrWbXBAlSW_5bb2dcf8", (String)"\u5931\u6548\u65e5\u671f\u586b\u4e86\uff0c\u751f\u6548\u65e5\u671f\u5fc5\u586b\uff01"));
                }
                if (effectiveDate > 0L && expiryDate > 0L && (effectiveDate > expiryDate || effectiveDate == expiryDate)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAWlTfUWbXBAW_21db452a", (String)"\u5931\u6548\u65e5\u671f \u5fc5\u987b\u5927\u4e8e \u751f\u6548\u65e5\u671f\uff01"));
                }
                if (certificationDate <= 0L || certificationDate <= effectiveDate) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LiBAWlTXUSEUWbXBAW_2012a69b", (String)"\u8ba4\u8bc1\u65e5\u671f \u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e \u751f\u6548\u65e5\u671f\uff01"));
            }
        }
    }

    public void insertData(SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead, List<SupplierAccessMgmtQuareviewItem> supplierAccessMgmtQuareviewItemList) {
        long expiryDate;
        long effectiveDate;
        long currentTimeMillis;
        String elsAccount = TenantContext.getTenant();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        Map<Boolean, List<SupplierAccessMgmtQuareviewItem>> mapList = supplierAccessMgmtQuareviewItemList.parallelStream().collect(Collectors.partitioningBy(o -> StrUtil.isBlank((CharSequence)o.getId())));
        List<SupplierAccessMgmtQuareviewItem> addList = mapList.get(true);
        List<SupplierAccessMgmtQuareviewItem> otherList = mapList.get(false);
        List<SupplierAccessMgmtQuareviewItem> oldList = this.supplierAccessMgmtQuareviewItemService.selectByMainId(supplierAccessMgmtQuareviewHead.getId());
        List deleteList = oldList.parallelStream().filter(vo -> !otherList.parallelStream().map(other -> other.getId()).collect(Collectors.toList()).contains(vo.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(addList)) {
            currentTimeMillis = System.currentTimeMillis();
            effectiveDate = 0L;
            expiryDate = 0L;
            for (SupplierAccessMgmtQuareviewItem entity : addList) {
                entity.setId(null);
                entity.setHeadId(supplierAccessMgmtQuareviewHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)supplierAccessMgmtQuareviewHead);
                entity.setElsAccount(elsAccount);
                if (entity.getEffectiveDate() != null) {
                    effectiveDate = entity.getEffectiveDate().getTime();
                }
                if (entity.getExpiryDate() != null) {
                    expiryDate = entity.getExpiryDate().getTime();
                }
                if ("1".equals(entity.getLimited())) {
                    if (currentTimeMillis < effectiveDate) {
                        entity.setCertificationStatus("0");
                    }
                    if (currentTimeMillis > effectiveDate && expiryDate > currentTimeMillis) {
                        entity.setCertificationStatus("1");
                    }
                    if (currentTimeMillis <= expiryDate) continue;
                    entity.setCertificationStatus("2");
                    continue;
                }
                entity.setCertificationStatus("1");
                if (entity.getEffectiveDate() == null) {
                    entity.setEffectiveDate(this.strToDate("yyyy-MM-dd", 0));
                }
                if (entity.getExpiryDate() != null) continue;
                entity.setExpiryDate(this.strToDate("yyyy-MM-dd", 100));
            }
            this.supplierAccessMgmtQuareviewItemService.saveBatch(addList, 2000);
        }
        if (!CollectionUtils.isEmpty(otherList)) {
            currentTimeMillis = System.currentTimeMillis();
            effectiveDate = 0L;
            expiryDate = 0L;
            for (SupplierAccessMgmtQuareviewItem entity : otherList) {
                entity.setHeadId(supplierAccessMgmtQuareviewHead.getId());
                entity.setUpdateBy(loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
                entity.setUpdateTime(new Date());
                if (entity.getEffectiveDate() != null) {
                    effectiveDate = entity.getEffectiveDate().getTime();
                }
                if (entity.getExpiryDate() != null) {
                    expiryDate = entity.getExpiryDate().getTime();
                }
                if ("1".equals(entity.getLimited())) {
                    if (currentTimeMillis < effectiveDate) {
                        entity.setCertificationStatus("0");
                    }
                    if (currentTimeMillis > effectiveDate && expiryDate > currentTimeMillis) {
                        entity.setCertificationStatus("1");
                    }
                    if (currentTimeMillis <= expiryDate) continue;
                    entity.setCertificationStatus("2");
                    continue;
                }
                entity.setCertificationStatus("1");
                if (entity.getEffectiveDate() == null) {
                    entity.setEffectiveDate(this.strToDate("yyyy-MM-dd", 0));
                }
                if (entity.getExpiryDate() != null) continue;
                entity.setExpiryDate(this.strToDate("yyyy-MM-dd", 100));
            }
            this.supplierAccessMgmtQuareviewItemService.updateBatchById(otherList, 2000);
        }
        if (!CollectionUtils.isEmpty(deleteList)) {
            List<String> ids = deleteList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
            this.supplierAccessMgmtQuareviewItemService.deleteByIds(ids);
        }
    }

    private Date strToDate(String pattern, int num) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, num);
        Date y = c.getTime();
        return y;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.supplierAccessMgmtQuareviewItemService.deleteByMainId(id);
        ((SupplierAccessMgmtQuareviewHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierAccessMgmtQuareviewItemService.deleteByMainId(serializable.toString());
            ((SupplierAccessMgmtQuareviewHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public IPage<SupplierAccessMgmtQuareviewHead> selectCustomPageList(Page<SupplierAccessMgmtQuareviewHead> page, QueryWrapper<SupplierAccessMgmtQuareviewHead> queryWrapper) {
        return ((SupplierAccessMgmtQuareviewHeadMapper)this.baseMapper).selectCustomPageList(page, queryWrapper);
    }

    @Override
    public void shiftTo(ShiftCertificationVO shiftCertificationVO) {
        List<SupplierAccessMgmtQuareviewItem> supplierAccessMgmtQuareviewItemList = shiftCertificationVO.getSupplierAccessMgmtQuareviewItemList();
        SupplierAccessMgmtQuareviewHead head = (SupplierAccessMgmtQuareviewHead)((Object)this.getById((Serializable)((Object)shiftCertificationVO.getId())));
        for (SupplierAccessMgmtQuareviewItem item : supplierAccessMgmtQuareviewItemList) {
            item.setShiftTo("1");
            PurchaseCertificatedInfo certificatedInfo = new PurchaseCertificatedInfo();
            certificatedInfo.setElsAccount(TenantContext.getTenant());
            certificatedInfo.setPurchaseName(head.getPurchaseName());
            certificatedInfo.setToElsAccount(head.getToElsAccount());
            certificatedInfo.setSupplierName(head.getSupplierName());
            certificatedInfo.setCreateAccount(TenantContext.getTenant());
            certificatedInfo.setTemplateAccount(shiftCertificationVO.getTemplateAccount());
            certificatedInfo.setTemplateName(shiftCertificationVO.getTemplateName());
            certificatedInfo.setTemplateNumber(shiftCertificationVO.getTemplateNumber());
            certificatedInfo.setTemplateVersion(shiftCertificationVO.getTemplateVersion());
            certificatedInfo.setShiftToId(item.getId());
            certificatedInfo.setCertificationOrg(item.getCertificationOrg());
            certificatedInfo.setCertificationSta(item.getCertificationSta());
            certificatedInfo.setCertificationNo(item.getCertificationNo());
            certificatedInfo.setCertificationName(item.getCertificationName());
            certificatedInfo.setCertificationDate(item.getCertificationDate());
            certificatedInfo.setCertificationContent(item.getCertificationContent());
            certificatedInfo.setEffectiveDate(item.getEffectiveDate());
            certificatedInfo.setExpiryDate(item.getExpiryDate());
            certificatedInfo.setSourceType(CertificatedSourceTypeEnum.ACCESS_MGMT_QUAREVIEW.getValue());
            if (StrUtil.isNotBlank((CharSequence)item.getCertificationStatus())) {
                if ("0".equals(item.getCertificationStatus())) {
                    certificatedInfo.setFail("1");
                }
                if ("1".equals(item.getCertificationStatus())) {
                    certificatedInfo.setFail("0");
                }
                if ("2".equals(item.getCertificationStatus())) {
                    certificatedInfo.setFail("1");
                }
            } else {
                certificatedInfo.setFail("1");
            }
            certificatedInfo.setSendStatus("0");
            certificatedInfo.setRemark(item.getRemark());
            ArrayList<PurchaseAttachmentDTO> attachments = new ArrayList<PurchaseAttachmentDTO>();
            if (StrUtil.isNotBlank((CharSequence)item.getAttachmentId())) {
                PurchaseAttachmentDTO attachmentDTO = new PurchaseAttachmentDTO();
                attachmentDTO.setId(item.getAttachmentId());
                attachmentDTO.setBusinessType("supplierCertificatedInfo");
                attachmentDTO.setFileName(item.getAttachmentName());
                attachmentDTO.setFilePath(item.getAttachmentPath());
                attachmentDTO.setSaveType(item.getAttachmentSaveType());
                attachmentDTO.setUploadTime(item.getCreateTime());
                attachmentDTO.setUploadElsAccount(item.getElsAccount());
                attachmentDTO.setUploadSubAccount(item.getCreateBy());
                attachments.add(attachmentDTO);
            }
            this.purchaseCertificatedInfoService.saveMain(certificatedInfo, attachments);
        }
        List<String> ids = supplierAccessMgmtQuareviewItemList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List<SupplierAccessMgmtQuareview> quareviewList = this.supplierAccessMgmtQuareviewService.selectByRelationIds(ids);
        for (SupplierAccessMgmtQuareview quareview : quareviewList) {
            quareview.setShiftTo("1");
        }
        if (!supplierAccessMgmtQuareviewItemList.isEmpty() && supplierAccessMgmtQuareviewItemList.size() > 0) {
            this.supplierAccessMgmtQuareviewItemService.updateBatchById(supplierAccessMgmtQuareviewItemList);
        }
        if (!quareviewList.isEmpty() && quareviewList.size() > 0) {
            this.supplierAccessMgmtQuareviewService.updateBatchById(quareviewList);
        }
    }

    @Override
    public void updateCertificatedInfoStatusInJob() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String format = sdf.format(date) + " 00:00:00";
        QueryWrapper certificatedInfoQueryWrapper = new QueryWrapper();
        certificatedInfoQueryWrapper.lt((Object)"expiry_date", (Object)format);
        List purchaseCertificatedInfoList = this.purchaseCertificatedInfoMapper.selectList((Wrapper)certificatedInfoQueryWrapper);
        QueryWrapper saleCertificatedInfoQueryWrapper = new QueryWrapper();
        saleCertificatedInfoQueryWrapper.lt((Object)"expiry_date", (Object)format);
        List saleCertificatedInfoList = this.saleCertificatedInfoService.list((Wrapper)saleCertificatedInfoQueryWrapper);
        QueryWrapper itemQueryWrapper = new QueryWrapper();
        itemQueryWrapper.lt((Object)"expiry_date", (Object)format);
        List itemList = this.supplierAccessMgmtQuareviewItemService.list((Wrapper)itemQueryWrapper);
        for (BaseEntity info : purchaseCertificatedInfoList) {
            info.setFail("1");
        }
        for (BaseEntity info : saleCertificatedInfoList) {
            info.setFail("1");
        }
        for (SupplierAccessMgmtQuareviewItem item : itemList) {
            item.setCertificationStatus("2");
        }
        if (!purchaseCertificatedInfoList.isEmpty() && purchaseCertificatedInfoList.size() > 0) {
            this.purchaseCertificatedInfoService.updateBatchById(purchaseCertificatedInfoList, 2000);
        }
        if (!saleCertificatedInfoList.isEmpty() && saleCertificatedInfoList.size() > 0) {
            this.saleCertificatedInfoService.updateBatchById(saleCertificatedInfoList, 2000);
        }
        if (!itemList.isEmpty() && itemList.size() > 0) {
            this.supplierAccessMgmtQuareviewItemService.updateBatchById(itemList, 2000);
        }
    }

    @Override
    public JSONObject getAccessMgmtQuareviewById(String id) {
        SupplierAccessMgmtQuareviewHead supplierAccessMgmtQuareviewHead = (SupplierAccessMgmtQuareviewHead)((Object)this.getById((Serializable)((Object)id)));
        SupplierAccessMgmtQuareviewHeadVO supplierAccessMgmtQuareviewHeadVO = (SupplierAccessMgmtQuareviewHeadVO)((Object)BeanUtil.copyProperties((Object)((Object)supplierAccessMgmtQuareviewHead), SupplierAccessMgmtQuareviewHeadVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)supplierAccessMgmtQuareviewHeadVO));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)supplierAccessMgmtQuareviewHeadVO, new DictTranslateAspectParam());
        return jsonObject;
    }
}

