/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierContactsInfoRelation;
import com.els.modules.supplier.mapper.SupplierContactsInfoMapper;
import com.els.modules.supplier.mapper.SupplierContactsInfoRelationMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierContactsInfoServiceImpl
extends ServiceImpl<SupplierContactsInfoMapper, SupplierContactsInfo>
implements SupplierContactsInfoService {
    @Autowired
    private SupplierContactsInfoMapper supplierContactsInfoMapper;
    @Autowired
    private SupplierContactsInfoRelationMapper supplierContactsInfoRelationMapper;
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;

    @Override
    public List<SupplierContactsInfo> selectByMainId(String mainId) {
        return this.supplierContactsInfoMapper.selectByMainId(mainId);
    }

    @Override
    public List<SupplierContactsInfo> selectByMainIds(List<String> supplierMasterDataIdList) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(SupplierContactsInfo::getHeadId, supplierMasterDataIdList);
        lambdaQueryWrapper.orderByAsc(BaseEntity::getCreateTime);
        return this.supplierContactsInfoMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<SupplierContactsInfo> getByAccount(String elsAccount, String toElsAccount) {
        if (StrUtil.isBlank((CharSequence)toElsAccount)) {
            return this.supplierContactsInfoMapper.getByElsAccount(elsAccount);
        }
        List<SupplierContactsInfo> contactsInfos = this.supplierContactsInfoMapper.getByAccount(elsAccount, toElsAccount);
        List<SupplierContactsInfoRelation> contactsInfoRelationList = this.supplierContactsInfoRelationMapper.getByAccount(elsAccount, toElsAccount);
        ArrayList relationList = SysUtil.copyProperties(contactsInfoRelationList, SupplierContactsInfo.class);
        if (CollUtil.isNotEmpty((Collection)relationList) && relationList.size() > 0) {
            relationList.forEach(o -> o.setToElsAccount(null));
        }
        contactsInfos.addAll(relationList);
        return contactsInfos;
    }

    @Override
    public List<SupplierContactsInfo> getByAccountAndRecordId(String elsAccount, String toElsAccount, String recordId, List<SupplierContactsInfo> oldContactsInfoList) {
        if (StrUtil.isBlank((CharSequence)toElsAccount)) {
            return this.supplierContactsInfoMapper.getByElsAccount(elsAccount);
        }
        List<SupplierContactsInfo> contactsInfos = this.supplierContactsInfoMapper.getByAccount(elsAccount, toElsAccount);
        if (StrUtil.isNotBlank((CharSequence)recordId)) {
            contactsInfos.addAll(oldContactsInfoList);
        } else {
            List<SupplierContactsInfoRelation> contactsInfoRelationList = this.supplierContactsInfoRelationMapper.getByAccount(elsAccount, toElsAccount);
            ArrayList relationList = SysUtil.copyProperties(contactsInfoRelationList, SupplierContactsInfo.class);
            if (CollUtil.isNotEmpty((Collection)relationList) && relationList.size() > 0) {
                relationList.forEach(o -> o.setToElsAccount(null));
            }
            contactsInfos.addAll(relationList);
        }
        return contactsInfos;
    }

    @Override
    public Map<String, List<ElsSubAccountDTO>> getSupplierContacts(List<String> toElsAccountList, String businessType, String operateType) {
        return null;
    }

    private List<ElsSubAccountDTO> getSubAccountListByJob(String toElsAccount, String jobFunction) {
        List<SupplierContactsInfo> infoList = ((SupplierContactsInfoMapper)this.baseMapper).getByAccount(toElsAccount, TenantContext.getTenant());
        List<SupplierContactsInfoRelation> contactsInfoRelationList = this.supplierContactsInfoRelationMapper.getByAccount(toElsAccount, TenantContext.getTenant());
        ArrayList relationList = SysUtil.copyProperties(contactsInfoRelationList, SupplierContactsInfo.class);
        if (CollUtil.isNotEmpty((Collection)relationList) && relationList.size() > 0) {
            relationList.forEach(o -> o.setToElsAccount(null));
        }
        infoList.addAll(relationList);
        ArrayList<ElsSubAccountDTO> accountDTOs = null;
        if (infoList.isEmpty()) {
            accountDTOs = new ArrayList<ElsSubAccountDTO>();
            accountDTOs.add(this.supplierInvokeAccountRpcService.getAccount(toElsAccount, "1001"));
            return accountDTOs;
        }
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        for (SupplierContactsInfo contactsInfo : infoList) {
            String subAccount = contactsInfo.getSubAccount();
            if (StrUtil.isNotBlank((CharSequence)subAccount)) {
                accountList.add(this.supplierInvokeAccountRpcService.getAccount(toElsAccount, "1001"));
                continue;
            }
            ElsSubAccountDTO account = new ElsSubAccountDTO();
            account.setEmail(contactsInfo.getEmail());
            account.setPhone(contactsInfo.getTelphone());
            accountList.add(account);
        }
        return accountList;
    }

    @Override
    public List<SupplierContactsInfo> getDataOnlyAccount(String elsAccount) {
        List<SupplierContactsInfo> infoList = this.supplierContactsInfoMapper.getByAccount(elsAccount, null);
        if (CollUtil.isNotEmpty(infoList) && infoList.size() > 0) {
            infoList.forEach(o -> {
                if (StrUtil.isNotBlank((CharSequence)o.getTagId())) {
                    o.setId(o.getTagId());
                }
            });
        }
        return infoList;
    }

    @Override
    public void deleteByElsAccount(String elsAccount) {
        this.supplierContactsInfoMapper.deleteByElsAccount(elsAccount);
    }

    @Override
    public IPage<SupplierContactsInfo> selectListPage(Page<SupplierContactsInfo> page, QueryWrapper<SupplierContactsInfo> queryWrapper) {
        return this.supplierContactsInfoMapper.selectListPage(page, queryWrapper);
    }
}

