/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.ConvertUtils;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.entity.SupplierInvitationCode;
import com.els.modules.supplier.enumerate.SupplierInvitationCodeStatusEnum;
import com.els.modules.supplier.mapper.SupplierInvitationCodeMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.SupplierInvitationCodeService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierInvitationCodeServiceImpl
extends BaseServiceImpl<SupplierInvitationCodeMapper, SupplierInvitationCode>
implements SupplierInvitationCodeService {
    private static final Logger log = LoggerFactory.getLogger(SupplierInvitationCodeServiceImpl.class);
    @Autowired
    private SupplierInvitationCodeMapper supplierInvitationCodeMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final String URL = "user/register?type=1&invitationCode=";
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private static final String SUPPLIER_INVITATION_CODE_SMS_SEND_KEY = "supplier_invitation_code_sms_send_key:";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveSupplierInvitationCode(SupplierInvitationCode supplierInvitationCode) {
        String invitationCode = this.getCode(ConvertUtils.randomGen((int)10));
        if (supplierInvitationCode.getEffectiveDate().getTime() < new Date().getTime()) {
            throw new ELSBootException("\u5931\u6548\u65e5\u671f\u4e0d\u5f97\u5c0f\u4e8e\u5f53\u524d\u670d\u52a1\u5668\u65e5\u671f,\u5f53\u524d\u670d\u52a1\u65e5\u671f\u4e3a:" + DateUtils.getDate((String)"yyyy-MM-dd"));
        }
        supplierInvitationCode.setInvitationCode(invitationCode);
        supplierInvitationCode.setStatus(SupplierInvitationCodeStatusEnum.UNCLAIMED.getValue());
        supplierInvitationCode.setDeleted(0);
        ((SupplierInvitationCodeMapper)this.baseMapper).insert((Object)supplierInvitationCode);
    }

    public String getCode(String code) {
        SupplierInvitationCode invitationCode = this.supplierInvitationCodeMapper.getByCode(code);
        if (invitationCode == null) {
            return code;
        }
        return this.getCode(ConvertUtils.randomGen((int)10));
    }

    @Override
    public void updateSupplierInvitationCode(SupplierInvitationCode supplierInvitationCode) {
        ((SupplierInvitationCodeMapper)this.baseMapper).updateById((Object)supplierInvitationCode);
    }

    @Override
    public void delSupplierInvitationCode(String id) {
        ((SupplierInvitationCodeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSupplierInvitationCode(List<String> idList) {
        ((SupplierInvitationCodeMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> handleLock(SupplierInvitationCode supplierInvitationCode) {
        SupplierInvitationCode code;
        block10: {
            code = (SupplierInvitationCode)((Object)this.getById((Serializable)((Object)supplierInvitationCode.getId())));
            if (code != null) {
                if (!SupplierInvitationCodeStatusEnum.UNCLAIMED.getValue().equals(code.getStatus())) {
                    return Result.error((String)String.format("\u8be5\u9080\u8bf7\u7801\"%s\"\uff0c\u4e0d\u80fd\u88ab\u9886\u53d6", SupplierInvitationCodeStatusEnum.getDesc(code.getStatus())));
                }
                SimpleDateFormat dateStr = new SimpleDateFormat("yyyy-MM-dd");
                String currentTime = dateStr.format(new Date());
                try {
                    Date date = dateStr.parse(currentTime);
                    if (date.getTime() > code.getEffectiveDate().getTime()) {
                        supplierInvitationCode.setStatus(SupplierInvitationCodeStatusEnum.LOSE_EFFICACY.getValue());
                        this.updateSupplierInvitationCode(supplierInvitationCode);
                        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rPVoIRjXAW_f2e069b", (String)"\u8be5\u9080\u8bf7\u7801\u5df2\u8fc7\u6709\u6548\u671f\uff01"));
                    }
                    break block10;
                }
                catch (ParseException e) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_field_hdKm_2841bc64", (String)("\u53d1\u9001\u5931\u8d25\uff01" + e.getMessage())));
                }
            }
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rTPVoIqQG_523cbdcb", (String)"\u8be5\u6761\u9080\u8bf7\u7801\u5df2\u88ab\u5220\u9664\uff01"));
        }
        supplierInvitationCode.setStatus(SupplierInvitationCodeStatusEnum.RECEIVED.getValue());
        if (this.redisUtil.get(SUPPLIER_INVITATION_CODE_SMS_SEND_KEY + supplierInvitationCode.getId()) != null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rVHiKhdWVxPVBDJW_9712a866", (String)"\u8be5\u4fe1\u606f\u6b63\u5728\u53d1\u9001\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\uff01"));
        }
        this.redisUtil.set(SUPPLIER_INVITATION_CODE_SMS_SEND_KEY + supplierInvitationCode.getId(), (Object)supplierInvitationCode, 60L);
        try {
            String content = this.address.endsWith("/") ? "\u9080\u8bf7\u6ce8\u518c\u94fe\u63a5\u4e3a\uff1a" + this.address + URL + code.getInvitationCode() : "\u9080\u8bf7\u6ce8\u518c\u94fe\u63a5\u4e3a\uff1a" + this.address + "/user/register?type=1&invitationCode=" + code.getInvitationCode();
            SupplierInvokeBaseRpcService baseRpcService = (SupplierInvokeBaseRpcService)SpringContextUtils.getBean(SupplierInvokeBaseRpcService.class);
            List<ElsEmailConfigDTO> emailConfigs = baseRpcService.getEmailConfigs(TenantContext.getTenant());
            if (CollectionUtils.isEmpty(emailConfigs)) {
                this.redisUtil.del(new String[]{SUPPLIER_INVITATION_CODE_SMS_SEND_KEY + supplierInvitationCode.getId()});
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jdERILHchdjdERWVPTER_8e022827", (String)"\u90ae\u7bb1\u914d\u7f6e\u4e0b\u672a\u8fdb\u884c\u53d1\u9001\u90ae\u7bb1\u914d\u7f6e\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e"));
            }
            for (ElsEmailConfigDTO config : emailConfigs) {
                boolean result = ElsEmailBuilder.sendEmail((ElsEmailConfigDTO)config, (String)code.getEmail(), (String)I18nUtil.translate((String)"i18n_alert_PVoQMLR_ad3c5109", (String)"\u9080\u8bf7\u7801\u9886\u53d6\u6210\u529f"), (String)content, null, (boolean)false);
                if (!result) continue;
                log.info(":::end to send email...");
                break;
            }
        }
        catch (Exception e) {
            this.redisUtil.del(new String[]{SUPPLIER_INVITATION_CODE_SMS_SEND_KEY + supplierInvitationCode.getId()});
            log.error("handleLock send email fail:{}", (Object)e.getMessage());
            throw new ELSBootException(e.getMessage());
        }
        this.updateSupplierInvitationCode(supplierInvitationCode);
        this.redisUtil.del(new String[]{SUPPLIER_INVITATION_CODE_SMS_SEND_KEY + supplierInvitationCode.getId()});
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(supplierInvitationCode.getToElsAccount());
        super.sendMessage(supplierInvitationCode.getElsAccount(), "inviteCode", "confirm", supplierInvitationCode.getId(), "supplierInvitationCodeBusDataServiceImpl", toElsAccountList);
        return Result.ok((String)String.format("\u9080\u8bf7\u7801\u9886\u53d6\u5e76\u53d1\u9001\"%s\"\u90ae\u7bb1\u6210\u529f\uff01", code.getEmail()));
    }

    @Override
    public SupplierInvitationCode getByCode(String code) {
        return this.supplierInvitationCodeMapper.getByCode(code);
    }

    @Override
    public JSONObject getSupplierInvitationCodeDataById(String id) {
        SupplierInvitationCode supplierInvitationCode = (SupplierInvitationCode)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)supplierInvitationCode));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)supplierInvitationCode, new DictTranslateAspectParam());
        return jsonObject;
    }
}

