/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.util;

import com.alibaba.fastjson.JSONObject;
import com.els.common.util.DateUtils;
import com.els.common.util.PwVerifyUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.api.dto.ElsPwComplexityAndMinLenDTO;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SupplierPasswordUtils {
    private static SupplierInvokeAccountRpcService supplierInvokeAccountRpcService = (SupplierInvokeAccountRpcService)SpringContextUtils.getBean(SupplierInvokeAccountRpcService.class);
    private static final String PREFIX = "Srm";
    private static final String SYMBOL = "_";

    public static String getDefaultPassword(String middle) {
        StringBuilder pwdStr = new StringBuilder();
        pwdStr.append(PREFIX).append(SYMBOL).append(middle).append(SYMBOL).append(DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd"));
        return pwdStr.toString();
    }

    public static String generatePwd(String elsAccount) {
        ElsPwComplexityAndMinLenDTO complexityAndMinLen = supplierInvokeAccountRpcService.getComplexityAndMinLen(elsAccount);
        Integer numCount = 0;
        Integer lowerCount = 0;
        Integer upperCount = 0;
        Integer specialCount = 0;
        if (complexityAndMinLen != null) {
            Map map = (Map)JSONObject.parseObject((String)complexityAndMinLen.getComplexity(), HashMap.class);
            int minLength = complexityAndMinLen.getMinLength();
            if (!map.isEmpty()) {
                if (map.containsKey("includeNum") && (Integer)map.get("includeNum") != 0) {
                    numCount = (Integer)map.get("includeNum");
                }
                if (map.containsKey("includeLowerCase") && (Integer)map.get("includeLowerCase") != 0) {
                    lowerCount = (Integer)map.get("includeLowerCase");
                }
                if (map.containsKey("includeUpperCase") && (Integer)map.get("includeUpperCase") != 0) {
                    upperCount = (Integer)map.get("includeUpperCase");
                }
                if (map.containsKey("includeSymbol") && (Integer)map.get("includeSymbol") != 0) {
                    specialCount = (Integer)map.get("includeSymbol");
                }
            }
            if (numCount == 0 && lowerCount == 0 && upperCount == 0 && specialCount == 0) {
                lowerCount = 1;
                upperCount = 2;
                specialCount = 1;
                numCount = lowerCount + upperCount + specialCount < minLength ? Integer.valueOf(minLength < 8 ? 4 : minLength - (lowerCount + upperCount + specialCount)) : Integer.valueOf(4);
            } else {
                numCount = lowerCount + upperCount + specialCount < minLength && minLength > 8 ? Integer.valueOf(minLength - (lowerCount + upperCount + specialCount)) : Integer.valueOf(8 - (lowerCount + upperCount + specialCount));
            }
        } else {
            lowerCount = 1;
            upperCount = 2;
            specialCount = 1;
            numCount = 4;
        }
        return PwVerifyUtil.generatePwd((int)upperCount, (int)lowerCount, (int)numCount, (int)specialCount);
    }
}

