/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.vmi.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.vmi.entity.VmiWaterLine;
import com.els.modules.vmi.entity.VmiWaterLineHistory;
import com.els.modules.vmi.mapper.VmiWaterLineHistoryMapper;
import com.els.modules.vmi.mapper.VmiWaterLineMapper;
import com.els.modules.vmi.service.VmiWaterLineService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VmiWaterLineServiceImpl
extends ServiceImpl<VmiWaterLineMapper, VmiWaterLine>
implements VmiWaterLineService {
    @Autowired
    private VmiWaterLineHistoryMapper vmiWaterLineHistoryMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private static String orgTable = "purchase_organization_info";
    private static String text = "org_desc";
    private static String value = "org_code";

    @Override
    public void saveVmiWaterLine(VmiWaterLine vmiWaterLine) {
        ((VmiWaterLineMapper)this.baseMapper).insert((Object)vmiWaterLine);
    }

    private void setFactoryNameAndStorageLocationName(VmiWaterLine vmiWaterLine) {
        String factoryName = this.invokeBaseRpcService.queryTableDictTextByFilterSql(TenantContext.getTenant(), vmiWaterLine.getFactory(), orgTable, text, value, null);
        String storageLocationName = this.invokeBaseRpcService.queryTableDictTextByFilterSql(TenantContext.getTenant(), vmiWaterLine.getStorageLocation(), orgTable, text, value, null);
        vmiWaterLine.setFactoryName(factoryName);
        vmiWaterLine.setStorageLocation(storageLocationName);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateVmiWaterLine(VmiWaterLine vmiWaterLine) {
        VmiWaterLine waterLine = (VmiWaterLine)((Object)this.getById((Serializable)((Object)vmiWaterLine.getId())));
        if (waterLine != null && waterLine.getStorageUpper() != null && waterLine.getStorageDownline() != null && waterLine.getReplenishmentPoints() != null) {
            int storageUpper = waterLine.getStorageUpper().compareTo(vmiWaterLine.getStorageUpper());
            int storageDownline = waterLine.getStorageDownline().compareTo(vmiWaterLine.getStorageDownline());
            int replenishmentPoints = waterLine.getReplenishmentPoints().compareTo(vmiWaterLine.getReplenishmentPoints());
            if (storageDownline != 0 || storageUpper != 0 || replenishmentPoints != 0) {
                VmiWaterLine vmiWaterLineHis = (VmiWaterLine)((Object)((VmiWaterLineMapper)this.baseMapper).selectById((Serializable)((Object)vmiWaterLine.getId())));
                VmiWaterLineHistory entity = new VmiWaterLineHistory();
                BeanUtils.copyProperties((Object)((Object)vmiWaterLineHis), (Object)((Object)entity));
                entity.setId(null);
                entity.setVersion(this.vmiWaterLineHistoryMapper.getMaxVersion(entity.getElsAccount(), entity.getToElsAccount(), entity.getFactory()));
                entity.setRelationId(vmiWaterLine.getId());
                this.vmiWaterLineHistoryMapper.insert((Object)entity);
            }
        }
        ((VmiWaterLineMapper)this.baseMapper).updateById((Object)vmiWaterLine);
    }

    @Override
    public void delVmiWaterLine(String id) {
        ((VmiWaterLineMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchVmiWaterLine(List<String> idList) {
        ((VmiWaterLineMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

