/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.event.AsyncEventNotifier;
import com.els.common.event.AsyncEventType;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeInteract;
import com.els.modules.knowledge.entity.KnowledgeVisitor;
import com.els.modules.knowledge.event.SupplierAsyncEventType;
import com.els.modules.knowledge.mapper.KnowledgeVisitorMapper;
import com.els.modules.knowledge.service.KnowledgeVisitorService;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeVisitorServiceImpl
extends ServiceImpl<KnowledgeVisitorMapper, KnowledgeVisitor>
implements KnowledgeVisitorService {
    @Override
    public boolean checkIfExists(String knowledgeId, String accountId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(KnowledgeInteract::getAccountId, (Object)accountId)).eq(KnowledgeInteract::getKnowledgeId, (Object)knowledgeId);
        return ((KnowledgeVisitorMapper)this.baseMapper).selectCount((Wrapper)wrapper) > 0;
    }

    @Override
    public boolean logVisitor(KnowledgeBase base, String accountId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(KnowledgeInteract::getAccountId, (Object)accountId)).eq(KnowledgeInteract::getKnowledgeId, (Object)base.getId());
        ((KnowledgeVisitorMapper)this.baseMapper).delete((Wrapper)wrapper);
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        KnowledgeVisitor visitor = new KnowledgeVisitor();
        visitor.setKnowledgeId(base.getId());
        visitor.setCreateTime(new Date());
        visitor.setKnowledgeTitle(base.getKnowledgeTitle());
        visitor.setAccountId(loginUser.getId());
        visitor.setCreateBy(loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
        visitor.setKnowledgeThumbnail(base.getKnowledgeThumbnail());
        ((KnowledgeVisitorMapper)this.baseMapper).insert(visitor);
        AsyncEventNotifier.notify((String)base.getId(), (AsyncEventType)SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
        return false;
    }

    @Override
    public Integer countKnowledge(String dataId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(KnowledgeInteract::getKnowledgeId, (Object)dataId);
        return ((KnowledgeVisitorMapper)this.baseMapper).selectCount((Wrapper)wrapper);
    }
}

