/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.performance.dto.PurchasePerformanceReportItemDto;
import com.els.modules.performance.entity.PurchasePerformanceReportGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.entity.PurchasePerformanceReportNormWeight;
import com.els.modules.performance.entity.PurchasePerformanceReportSupplier;
import com.els.modules.performance.service.PurchasePerformanceReportGradService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import com.els.modules.performance.service.PurchasePerformanceReportNormWeightService;
import com.els.modules.performance.service.PurchasePerformanceReportSupplierService;
import com.els.modules.performance.service.SalePerformanceReportHeadService;
import com.els.modules.performance.vo.PurchasePerformanceReportHeadVO;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchasePerformanceResultDubboAdapter")
public class PurchasePerformanceResultAdapter
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceResultAdapter.class);
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Autowired
    private PurchasePerformanceReportItemService purchasePerformanceReportItemService;
    @Autowired
    private PurchasePerformanceReportGradService purchasePerformanceReportGradService;
    @Autowired
    private PurchasePerformanceReportNormWeightService purchasePerformanceReportNormWeightService;
    @Autowired
    private PurchasePerformanceReportSupplierService purchasePerformanceReportSupplierService;
    @Autowired
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SalePerformanceReportHeadService salePerformanceReportHeadService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        Object operataion = "resultSubmitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_resultSubmitAudit";
        }
        this.sendMsg(this.getReportHeadVo(head, inputParamVO.getBusinessId()), inputParamVO, outputParamVO, (String)operataion, SysUtil.getLoginUser());
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        PurchasePerformanceReportHeadVO headVO = this.purchasePerformanceReportHeadService.queryById(inputParamVO.getBusinessId());
        PurchasePerformanceReportHead head = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        List<PurchasePerformanceReportSupplier> supplierList = headVO.getPurchasePerformanceReportSupplierList();
        List itemList = Convert.toList(PurchasePerformanceReportItem.class, headVO.getPurchasePerformanceReportItemList());
        for (PurchasePerformanceReportSupplier supplier : supplierList) {
            supplier.setItemList(itemList.stream().filter(o -> supplier.getToElsAccount().equals(o.getToElsAccount())).collect(Collectors.toList()));
            this.purchasePerformanceReportHeadService.reportPerformanceResultToSupplierNew(head, supplier);
        }
        head.setDataVersion(((PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)head.getId())))).getDataVersion());
        this.purchasePerformanceReportHeadService.updateById((Object)head);
        this.sendMsg(this.getReportHeadVo(head, inputParamVO.getBusinessId()), inputParamVO, outputParamVO, "resultAuditPass", loginUser);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        MsgParamsVO msgParamsVO = this.parameterAssemble(this.getReportHeadVo(head, inputParamVO.getBusinessId()), inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"performanceReport", (String)"resultAuditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchasePerformanceReportHeadVO headVO = this.getReportHeadVo(head, id);
            JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
            return jsonObject;
        }
        return null;
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchasePerformanceReportHead head = new PurchasePerformanceReportHead();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        head.setWorkFlowType(outputParamVO.getBpmnType());
        boolean count = this.purchasePerformanceReportHeadService.updateById((Object)head);
        if (!count) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    private PurchasePerformanceReportHeadVO getReportHeadVo(PurchasePerformanceReportHead head, String id) {
        PurchasePerformanceReportHeadVO purchasePerformanceReportHeadVO = new PurchasePerformanceReportHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)purchasePerformanceReportHeadVO));
        List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.selectItemByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportItemList(purchasePerformanceReportItemList);
        if (CharSequenceUtil.isNotBlank((CharSequence)head.getPerformanceTemplateId())) {
            List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradService.selectByMainId(id);
            purchasePerformanceReportHeadVO.setPurchasePerformanceNormGradList(gradList);
        }
        List<PurchasePerformanceReportNormWeight> normWeightList = this.purchasePerformanceReportNormWeightService.selectByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportNormWeightList(normWeightList);
        List<PurchasePerformanceReportSupplier> supplierList = this.purchasePerformanceReportSupplierService.selectByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportSupplierList(supplierList);
        return purchasePerformanceReportHeadVO;
    }

    private MsgParamsVO parameterAssemble(PurchasePerformanceReportHeadVO head, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.supplierInvokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        msgParamsVO.setReceiverMap(receiverMap);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)((Object)head)));
        jsonObject.put("auditOpinion", (Object)inputParamVO.getAuditOpinion());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        String[] arrays = account.split("_");
        if (arrays.length > 2) {
            paramObj.put("taskId", (Object)arrays[2]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    private void sendMsg(PurchasePerformanceReportHeadVO head, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType, LoginUserDTO loginUser) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(head, inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"performanceReport", (String)optType, (MsgParamsVO)msgParamsVO, (LoginUserDTO)loginUser);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(head, inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"performanceReport", (String)optType, (MsgParamsVO)msgParamsVO, (LoginUserDTO)loginUser);
            }
        }
    }
}

