/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierMasterDataService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;

@RpcService(value="supplierCodeToElsAccountConverter")
public class SupplierCodeToElsAccountConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(SupplierCodeToElsAccountConverter.class);
    private static final String REDIS_PREFIX = "srm:supplierCodeToElsAccountConvertor_";
    @Resource
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private SupplierMasterDataService supplierMasterDataService;

    public Object convertData(Object data, Object obj, String ... args) {
        String supplierCode = (String)data;
        if (StrUtil.isNotBlank((CharSequence)supplierCode)) {
            SupplierMasterData supplierMasterData = (SupplierMasterData)((Object)this.redisUtil.get(REDIS_PREFIX + supplierCode));
            if (supplierMasterData == null && (supplierMasterData = (SupplierMasterData)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.supplierMasterDataService.lambdaQuery().select(new SFunction[]{SupplierMasterData::getSupplierCode, SupplierMasterData::getToElsAccount, SupplierMasterData::getSupplierName}).eq(SupplierMasterData::getSupplierCode, (Object)supplierCode)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).one())) != null) {
                this.redisUtil.set(REDIS_PREFIX + supplierCode, (Object)supplierMasterData, 300L);
            }
            if (supplierMasterData == null) {
                throw new ELSBootException("\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a\u3010" + supplierCode + "\u3011\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\uff01");
            }
            return supplierMasterData.getToElsAccount();
        }
        throw new ELSBootException("\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a\u3010" + supplierCode + "\u3011\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\uff01");
    }
}

