/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.context.TokenContext;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.service.MqConsumerRpcService;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataImportVo;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;

@RpcService(value="supplierMasterDataImportMessage")
public class SupplierMasterDataImportMessageConcumerBeanServiceImpl
implements MqConsumerRpcService {
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataImportMessageConcumerBeanServiceImpl.class);
    private static final String MASTER_DATA_MAPPER = "SupplierMasterDataMapper";
    @Lazy
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private SupplierMasterDataService supplierMasterDataService;
    @Resource
    private SupplierMasterDataMapper supplierMasterDataMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(String msgBody) {
        SupplierMasterDataImportVo importVo = (SupplierMasterDataImportVo)JSON.parseObject((String)msgBody, SupplierMasterDataImportVo.class);
        SupplierMasterData supplierMasterData = importVo.getSupplierMasterData();
        try {
            SupplierMasterData masterData = (SupplierMasterData)((Object)this.supplierMasterDataMapper.selectById((Serializable)((Object)supplierMasterData)));
            if (masterData == null) {
                supplierMasterData.setId(null);
                this.supplierMasterDataMapper.insert((Object)supplierMasterData);
                importVo.setSupplierMasterData(supplierMasterData);
            }
            LoginUserDTO loginUser = importVo.getLoginUser();
            String tenant = importVo.getTenant();
            String token = importVo.getToken();
            LoginUserContext.setUser((LoginUserDTO)loginUser);
            TenantContext.setTenant((String)tenant);
            TokenContext.setToken((String)token);
            this.supplierMasterDataService.importSupplierMasterDataAsynsDo(importVo);
        }
        catch (Exception e) {
            log.error("MQ\u6d88\u606f\u8bb0\u5f55\u9875\u9762\u91cd\u8bd5\u5f02\u5e38\uff1a:" + msgBody, (Throwable)e);
            this.supplierMasterDataMapper.delById(supplierMasterData.getId());
        }
        finally {
            this.redisUtil.deleteBykeyword(MASTER_DATA_MAPPER);
            LoginUserContext.clear();
            TenantContext.clear();
            TokenContext.clear();
        }
    }
}

