/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.modules.supplier.vo.PurchaseCertificatedInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/purchaseCertificatedInfo"})
@Api(tags={"\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599"})
public class PurchaseCertificatedInfoController
extends BaseController<PurchaseCertificatedInfo, PurchaseCertificatedInfoService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseCertificatedInfoController.class);
    @Autowired
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:list"})
    @PermissionDataView(businessType="supplierCertificatedInfo")
    public Result<?> queryPageList(PurchaseCertificatedInfo purchaseCertificatedInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseCertificatedInfo), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseCertificatedInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:add"})
    @PermissionDataOpt(businessType="supplierCertificatedInfo", beanClass=PurchaseCertificatedInfoService.class)
    public Result<?> add(@RequestBody PurchaseCertificatedInfoVO purchaseCertificatedInfoPage) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = new PurchaseCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfoPage), (Object)((Object)purchaseCertificatedInfo));
        this.purchaseCertificatedInfoService.saveMain(purchaseCertificatedInfo, purchaseCertificatedInfoPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseCertificatedInfo));
    }

    @SrmValidated
    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u83b7\u53d6\u8d44\u8d28\u8ba4\u8bc1\u8d44\u6599")
    @ApiOperation(value="\u83b7\u53d6\u8d44\u8d28\u8ba4\u8bc1\u8d44\u6599", notes="\u83b7\u53d6\u8d44\u8d28\u8ba4\u8bc1\u8d44\u6599")
    @PostMapping(value={"/getCertificated"})
    public Result<?> getCertificated(@RequestBody PurchaseCertificatedInfoVO purchaseCertificatedInfoPage) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = new PurchaseCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfoPage), (Object)((Object)purchaseCertificatedInfo));
        if (StrUtil.isBlank((CharSequence)purchaseCertificatedInfo.getPurchaseName())) {
            throw new ELSBootException("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.purchaseCertificatedInfoService.getCertificated(purchaseCertificatedInfo);
        return Result.ok((Object)((Object)purchaseCertificatedInfo));
    }

    @SrmValidated
    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:edit"})
    @PermissionDataOpt(businessType="supplierCertificatedInfo", beanClass=PurchaseCertificatedInfoService.class)
    public Result<?> edit(@RequestBody PurchaseCertificatedInfoVO purchaseCertificatedInfoPage) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = new PurchaseCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfoPage), (Object)((Object)purchaseCertificatedInfo));
        this.purchaseCertificatedInfoService.updateMain(purchaseCertificatedInfo, purchaseCertificatedInfoPage.getPurchaseAttachmentList());
        String id = purchaseCertificatedInfo.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:delete"})
    @PermissionDataOpt(businessType="supplierCertificatedInfo", beanClass=PurchaseCertificatedInfoService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseCertificatedInfoService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseCertificatedInfoService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = (PurchaseCertificatedInfo)((Object)this.purchaseCertificatedInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseCertificatedInfoVO purchaseCertificatedInfoVO = new PurchaseCertificatedInfoVO();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfo), (Object)((Object)purchaseCertificatedInfoVO));
        List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(id);
        purchaseCertificatedInfoVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseCertificatedInfoVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u9644\u4ef6\u5217\u8868", notes="\u901a\u8fc7id\u67e5\u8be2\u9644\u4ef6\u5217\u8868")
    @GetMapping(value={"/queryFileListById"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:list"})
    public Result<?> queryFileListById(@RequestParam(name="id", required=true) String id, @RequestParam(name="elsAccount", required=false) String elsAccount) {
        String elsAccountStr = StrUtil.isBlank((CharSequence)elsAccount) ? TenantContext.getTenant() : elsAccount;
        PurchaseCertificatedInfo purchaseCertificatedInfo = (PurchaseCertificatedInfo)((Object)this.purchaseCertificatedInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)elsAccountStr)));
        if (Objects.isNull((Object)purchaseCertificatedInfo)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        PurchaseCertificatedInfoVO purchaseCertificatedInfoVO = new PurchaseCertificatedInfoVO();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfo), (Object)((Object)purchaseCertificatedInfoVO));
        List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(id);
        purchaseCertificatedInfoVO.setPurchaseAttachmentList(purchaseAttachmentList);
        Result resultDict = Result.ok((Object)((Object)purchaseCertificatedInfoVO));
        ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)resultDict, new DictTranslateAspectParam());
        if (resultDict.getResult() != null && resultDict.getResult() instanceof JSONObject) {
            return Result.ok((Object)((JSONObject)resultDict.getResult()).getJSONArray("purchaseAttachmentList"));
        }
        return Result.ok((Object)CollUtil.newArrayList((Object[])new Object[0]));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u9644\u4ef6\u5217\u8868", notes="\u901a\u8fc7id\u67e5\u8be2\u9644\u4ef6\u5217\u8868")
    @GetMapping(value={"/queryFileListByIds"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:list"})
    public Result<?> queryFileListByIds(@RequestParam(name="ids", required=true) String ids) {
        List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainIds(Arrays.asList(ids.split(",")));
        return Result.ok(purchaseAttachmentList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599id\u67e5\u8be2\u9644\u4ef6", notes="\u901a\u8fc7\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599id\u67e5\u8be2\u9644\u4ef6")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:list"})
    public Result<?> queryPurchaseAttachmentListByMainId(@RequestParam(name="id", required=true) String id) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = (PurchaseCertificatedInfo)((Object)this.purchaseCertificatedInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseCertificatedInfoVO purchaseCertificatedInfoVO = new PurchaseCertificatedInfoVO();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfo), (Object)((Object)purchaseCertificatedInfoVO));
        List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(id);
        purchaseCertificatedInfoVO.setPurchaseAttachmentList(purchaseAttachmentList);
        Result resultDict = Result.ok((Object)((Object)purchaseCertificatedInfoVO));
        ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)resultDict, new DictTranslateAspectParam());
        if (resultDict.getResult() != null && resultDict.getResult() instanceof JSONObject) {
            return Result.ok((Object)((JSONObject)resultDict.getResult()).getJSONArray("purchaseAttachmentList"));
        }
        return Result.ok((Object)CollUtil.newArrayList((Object[])new Object[0]));
    }

    @ApiOperation(value="\u8ba4\u8bc1\u8d44\u6599\u83b7\u53d6", notes="\u8ba4\u8bc1\u8d44\u6599\u83b7\u53d6")
    @GetMapping(value={"/certificatedInfo"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:list", "supplier_master_data#supplierMasterData:picImage", "supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:supplierPicImage"}, logical=Logical.OR)
    public Result<?> certificatedInfo(@RequestParam(name="toElsAccount", required=true) String toElsAccount) {
        return this.purchaseCertificatedInfoService.certificatedInfo(toElsAccount);
    }

    @SrmValidated
    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u53d1\u9001")
    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @PostMapping(value={"/send"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:send"})
    @PermissionDataOpt(businessType="supplierCertificatedInfo", beanClass=PurchaseCertificatedInfoService.class)
    public Result<?> send(@RequestBody PurchaseCertificatedInfoVO purchaseCertificatedInfoVO) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = new PurchaseCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfoVO), (Object)((Object)purchaseCertificatedInfo));
        this.purchaseCertificatedInfoService.send(purchaseCertificatedInfo, purchaseCertificatedInfoVO.getPurchaseAttachmentList());
        return Result.ok();
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u5931\u6548")
    @ApiOperation(value="\u5931\u6548", notes="\u5931\u6548")
    @GetMapping(value={"/loseEfficacy"})
    @RequiresPermissions(value={"purchase_certificated_info#purchaseCertificatedInfo:invalid"})
    @PermissionDataOpt(businessType="supplierCertificatedInfo", beanClass=PurchaseCertificatedInfoService.class)
    public Result<?> loseEfficacy(@RequestParam(name="id", required=true) String id) {
        this.purchaseCertificatedInfoService.loseEfficacy(id);
        return Result.ok();
    }
}

