/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.supplier.entity.SaleVisitHead;
import com.els.modules.supplier.entity.SaleVisitItem;
import com.els.modules.supplier.service.SaleVisitHeadService;
import com.els.modules.supplier.service.SaleVisitItemService;
import com.els.modules.supplier.vo.SaleVisitHeadTransferVO;
import com.els.modules.supplier.vo.SaleVisitHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/saleVisitHead"})
@Api(tags={"\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f"})
@BusinessModule(module="saleBookVisit")
public class SaleVisitHeadController
extends BaseController<SaleVisitHead, SaleVisitHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleVisitHeadController.class);
    @Autowired
    private SaleVisitHeadService saleVisitHeadService;
    @Autowired
    private SaleVisitItemService saleVisitItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"visit#saleVisitHead:list"})
    @PermissionDataView(businessType="saleBookVisit")
    public Result<?> queryPageList(SaleVisitHead saleVisitHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleVisitHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleVisitHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"visit#saleVisitHead:add"})
    public Result<?> add(@RequestBody SaleVisitHeadVO saleVisitHeadPage) {
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        BeanUtils.copyProperties((Object)((Object)saleVisitHeadPage), (Object)((Object)saleVisitHead));
        this.saleVisitHeadService.saveMain(saleVisitHead, saleVisitHeadPage.getPurchaseVisitItemList(), saleVisitHeadPage.getSaleAttachmentList());
        return Result.ok((Object)((Object)saleVisitHead));
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"visit#saleVisitHead:edit"})
    public Result<?> edit(@RequestBody SaleVisitHeadVO saleVisitHeadPage) {
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        BeanUtils.copyProperties((Object)((Object)saleVisitHeadPage), (Object)((Object)saleVisitHead));
        this.saleVisitHeadService.updateMain(saleVisitHead, saleVisitHeadPage.getPurchaseVisitItemList(), saleVisitHeadPage.getSaleAttachmentList());
        String id = saleVisitHead.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"visit#saleVisitHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleVisitHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"visit#saleVisitHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleVisitHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"visit#saleVisitHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleVisitHead saleVisitHead = (SaleVisitHead)((Object)this.saleVisitHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleVisitHeadVO saleVisitHeadVO = new SaleVisitHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleVisitHead), (Object)((Object)saleVisitHeadVO));
        List<SaleVisitItem> saleVisitItemList = this.saleVisitItemService.selectByMainId(id);
        saleVisitHeadVO.setPurchaseVisitItemList(saleVisitItemList);
        List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleVisitHeadVO.setSaleAttachmentList(saleAttachmentDTOList);
        return Result.ok((Object)((Object)saleVisitHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606fid\u67e5\u8be2\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606fid\u67e5\u8be2\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u884c\u4fe1\u606f")
    @GetMapping(value={"/querySaleVisitItemByMainId"})
    @RequiresPermissions(value={"visit#saleVisitHead:view"})
    public Result<?> querySaleVisitItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleVisitItem> saleVisitItemList = this.saleVisitItemService.selectByMainId(id);
        return Result.ok(saleVisitItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"visit#saleVisitHead:list"})
    @PermissionDataView(businessType="saleBookVisit")
    public Result<?> queryTabsCount(SaleVisitHead saleVisitHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"visit_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"visit_status");
        List list = ((SaleVisitHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleVisitHead::getVisitStatus, SaleVisitHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "visitStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmVisitStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "visitStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", value="\u901a\u8fc7id\u53d1\u5e03")
    @ApiOperation(value="\u901a\u8fc7id\u53d1\u5e03\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", notes="\u901a\u8fc7id\u53d1\u5e03\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"visit#saleVisitHead:publish"})
    public Result<?> publishVisit(@RequestBody SaleVisitHeadVO saleVisitHeadVO) {
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        BeanUtils.copyProperties((Object)((Object)saleVisitHeadVO), (Object)((Object)saleVisitHead));
        this.saleVisitHeadService.publish(saleVisitHead, saleVisitHeadVO.getPurchaseVisitItemList(), saleVisitHeadVO.getSaleAttachmentList());
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", value="\u786e\u5b9a")
    @ApiOperation(value="\u901a\u8fc7id\u786e\u5b9a", notes="\u901a\u8fc7id\u786e\u5b9a")
    @GetMapping(value={"/confirmed"})
    @RequiresPermissions(value={"visit#saleVisitHead:confirmed"})
    public Result<?> confirmed(@RequestParam(name="id", required=true) String id) {
        this.saleVisitHeadService.confirmedMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", value="\u62d2\u7edd")
    @ApiOperation(value="\u901a\u8fc7id\u62d2\u7edd", notes="\u901a\u8fc7id\u62d2\u7edd")
    @GetMapping(value={"/rejected"})
    @RequiresPermissions(value={"visit#saleVisitHead:rejected"})
    public Result<?> rejected(@RequestParam(name="id", required=true) String id, @RequestParam(name="rejectReason") String rejectReason) {
        this.saleVisitHeadService.rejectedMain(id, rejectReason);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", value="\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", notes="\u901a\u8fc7id\u4f5c\u5e9f\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f")
    @PostMapping(value={"/invalid"})
    @RequiresPermissions(value={"visit#saleVisitHead:invalid"})
    @SrmValidated
    public Result<?> invalidVisit(@RequestBody SaleVisitHeadVO saleVisitHeadVO) {
        this.saleVisitHeadService.invalid(saleVisitHeadVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", value="\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"visit#saleVisitHead:copy"})
    public Result<?> copyVisit(@RequestParam(name="id") String id) {
        this.saleVisitHeadService.copyMain(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", value="\u8f6c\u529e")
    @ApiOperation(value="\u8f6c\u529e", notes="\u8f6c\u529e")
    @PostMapping(value={"/transfer"})
    @RequiresPermissions(value={"visit#saleVisitHead:transfer"})
    @SrmValidated
    public Result<?> transferIntervieweePrincipal(@RequestBody SaleVisitHeadTransferVO saleVisitHeadTransferVO) {
        this.saleVisitHeadService.transfer(saleVisitHeadTransferVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", value="\u603b\u7ed3")
    @ApiOperation(value="\u603b\u7ed3", notes="\u603b\u7ed3")
    @PostMapping(value={"/summary"})
    @RequiresPermissions(value={"visit#saleVisitHead:summary"})
    @SrmValidated
    public Result<?> summary(@RequestBody SaleVisitHeadVO saleVisitHeadVO) {
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        BeanUtils.copyProperties((Object)((Object)saleVisitHeadVO), (Object)((Object)saleVisitHead));
        this.saleVisitHeadService.summary(saleVisitHead, saleVisitHeadVO.getSaleAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u9884\u7ea6\u62dc\u8bbf\u4fe1\u606f", value="\u8bc4\u4ef7")
    @ApiOperation(value="\u8bc4\u4ef7", notes="\u8bc4\u4ef7")
    @PostMapping(value={"/evaluation"})
    @RequiresPermissions(value={"visit#saleVisitHead:evaluation"})
    @SrmValidated
    public Result<?> evaluation(@RequestBody SaleVisitHeadVO saleVisitHeadVO) {
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        BeanUtils.copyProperties((Object)((Object)saleVisitHeadVO), (Object)((Object)saleVisitHead));
        this.saleVisitHeadService.evaluation(saleVisitHead, saleVisitHeadVO.getSaleAttachmentList());
        return this.commonSuccessResult(3);
    }
}

