/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.PurchaseStandardItem;
import com.els.modules.supplier.entity.SaleStandardHead;
import com.els.modules.supplier.entity.SaleStandardItem;
import com.els.modules.supplier.entity.SupplierStandardRegulationSelection;
import com.els.modules.supplier.enumerate.ItemizedCheckStatusEnum;
import com.els.modules.supplier.enumerate.QuestionTypesEnum;
import com.els.modules.supplier.mapper.PurchaseStandardHeadMapper;
import com.els.modules.supplier.mapper.PurchaseStandardItemMapper;
import com.els.modules.supplier.mapper.SaleStandardHeadMapper;
import com.els.modules.supplier.mapper.SaleStandardItemMapper;
import com.els.modules.supplier.mapper.SupplierStandardRegulationSelectionMapper;
import com.els.modules.supplier.service.PurchaseStandardItemService;
import com.els.modules.supplier.service.SaleStandardHeadService;
import com.els.modules.supplier.service.SaleStandardItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleStandardHeadServiceImpl
extends ServiceImpl<SaleStandardHeadMapper, SaleStandardHead>
implements SaleStandardHeadService {
    @Autowired
    private SaleStandardHeadMapper supplierStandardHeadMapper;
    @Autowired
    private SaleStandardItemMapper supplierStandardItemMapper;
    @Autowired
    private PurchaseStandardHeadMapper purchaseStandardHeadMapper;
    @Autowired
    private PurchaseStandardItemMapper purchaseStandardItemMapper;
    @Autowired
    private SupplierStandardRegulationSelectionMapper supplierStandardRegulationSelectionMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleStandardHead supplierStandardHead, List<SaleStandardItem> supplierStandardItemList) {
        this.supplierStandardHeadMapper.insert((Object)supplierStandardHead);
        this.insertData(supplierStandardHead, supplierStandardItemList, null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleStandardHead supplierStandardHead, List<SaleStandardItem> supplierStandardItemList, List<SaleAttachmentDTO> attachments) {
        this.supplierStandardHeadMapper.updateById((Object)supplierStandardHead);
        this.supplierStandardItemMapper.deleteByMainId(supplierStandardHead.getId());
        this.insertData(supplierStandardHead, supplierStandardItemList, attachments);
    }

    private void insertData(SaleStandardHead supplierStandardHead, List<SaleStandardItem> supplierStandardItemList, List<SaleAttachmentDTO> attachments) {
        for (SaleStandardItem entity : supplierStandardItemList) {
            entity.setHeadId(supplierStandardHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)supplierStandardHead);
            if (!StrUtil.isBlank((CharSequence)entity.getToElsAccount())) continue;
            entity.setToElsAccount(supplierStandardHead.getToElsAccount());
        }
        if (!supplierStandardItemList.isEmpty()) {
            this.rebuildHead(supplierStandardHead, supplierStandardItemList);
            ((SaleStandardItemService)SpringContextUtils.getBean(SaleStandardItemService.class)).saveBatch(supplierStandardItemList);
        }
        if (attachments != null && CollectionUtil.isNotEmpty(attachments)) {
            for (SaleAttachmentDTO attachment : attachments) {
                attachment.setHeadId(supplierStandardHead.getId());
                attachment.setUploadElsAccount(supplierStandardHead.getElsAccount());
                attachment.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)supplierStandardHead);
            }
            this.invokeBaseRpcService.updateSaleAttachmentBatchById(attachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.supplierStandardItemMapper.deleteByMainId(id);
        this.supplierStandardHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierStandardItemMapper.deleteByMainId(serializable.toString());
            this.supplierStandardHeadMapper.deleteById(serializable);
        }
    }

    private void rebuildHead(SaleStandardHead saleStandardHead) {
        List<SaleStandardItem> saleStandardItemList = this.supplierStandardItemMapper.selectByMainId(saleStandardHead.getId());
        if (CollectionUtil.isNotEmpty(saleStandardItemList)) {
            ArrayList<CallSite> respondentsListStr = new ArrayList<CallSite>();
            ArrayList<CallSite> scoerListStr = new ArrayList<CallSite>();
            String respondentsList = "";
            String scoerList = "";
            BigDecimal fullMark = BigDecimal.ZERO;
            for (SaleStandardItem item : saleStandardItemList) {
                respondentsListStr.add((CallSite)((Object)(item.getParticipants() + "_" + item.getRespondents() + "_" + item.getItemStatus())));
                scoerListStr.add((CallSite)((Object)(item.getScorer() + "_" + item.getItemStatus())));
            }
            if (CollUtil.isNotEmpty(respondentsListStr)) {
                respondentsList = StrUtil.join((CharSequence)",", respondentsListStr);
            }
            if (CollUtil.isNotEmpty(scoerListStr)) {
                scoerList = StrUtil.join((CharSequence)",", scoerListStr);
            }
            saleStandardHead.setRespondentsList(respondentsList);
            saleStandardHead.setScorerList(scoerList);
            ((SaleStandardItemService)SpringContextUtils.getBean(SaleStandardItemService.class)).updateBatchById(saleStandardItemList);
        }
    }

    private void rebuildHead(SaleStandardHead saleStandardHead, List<SaleStandardItem> saleStandardItemList) {
        ArrayList<CallSite> respondentsListStr = new ArrayList<CallSite>();
        ArrayList<CallSite> scoerListStr = new ArrayList<CallSite>();
        String respondentsList = "";
        String scoerList = "";
        BigDecimal fullMark = BigDecimal.ZERO;
        for (SaleStandardItem item : saleStandardItemList) {
            respondentsListStr.add((CallSite)((Object)(item.getParticipants() + "_" + item.getRespondents() + "_" + item.getItemStatus())));
            scoerListStr.add((CallSite)((Object)(item.getScorer() + "_" + item.getItemStatus())));
        }
        if (CollUtil.isNotEmpty(respondentsListStr)) {
            respondentsList = StrUtil.join((CharSequence)",", respondentsListStr);
        }
        if (CollUtil.isNotEmpty(scoerListStr)) {
            scoerList = StrUtil.join((CharSequence)",", scoerListStr);
        }
        saleStandardHead.setRespondentsList(respondentsList);
        saleStandardHead.setScorerList(scoerList);
        this.supplierStandardHeadMapper.updateById((Object)saleStandardHead);
    }

    private void rebuildPurchaseHead(PurchaseStandardHead purchaseStandardHead) {
        List<PurchaseStandardItem> purchaseStandardItems = this.purchaseStandardItemMapper.selectByMainId(purchaseStandardHead.getId());
        if (CollectionUtil.isNotEmpty(purchaseStandardItems)) {
            ArrayList<CallSite> respondentsListStr = new ArrayList<CallSite>();
            ArrayList<CallSite> scoerListStr = new ArrayList<CallSite>();
            String respondentsList = "";
            String scoerList = "";
            BigDecimal fullMark = BigDecimal.ZERO;
            for (PurchaseStandardItem item : purchaseStandardItems) {
                respondentsListStr.add((CallSite)((Object)(item.getParticipants() + "_" + item.getRespondents() + "_" + item.getItemStatus())));
                scoerListStr.add((CallSite)((Object)(item.getScorer() + "_" + item.getItemStatus())));
            }
            if (CollUtil.isNotEmpty(respondentsListStr)) {
                respondentsList = StrUtil.join((CharSequence)",", respondentsListStr);
            }
            if (CollUtil.isNotEmpty(scoerListStr)) {
                scoerList = StrUtil.join((CharSequence)",", scoerListStr);
            }
            purchaseStandardHead.setRespondentsList(respondentsList);
            purchaseStandardHead.setScorerList(scoerList);
            this.purchaseStandardHeadMapper.updateById((Object)purchaseStandardHead);
            ((PurchaseStandardItemService)SpringContextUtils.getBean(PurchaseStandardItemService.class)).updateBatchById(purchaseStandardItems);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(SaleStandardHead supplierStandardHead, List<SaleStandardItem> supplierStandardItemList, List<SaleAttachmentDTO> attachmentList) {
        supplierStandardHead.setStandardStatus(ItemizedCheckStatusEnum.BE_EVALUATING.getValue());
        BigDecimal scoreTotal = BigDecimal.ZERO;
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        HashMap<String, CallSite> itemAttachment = new HashMap<String, CallSite>();
        if (supplierStandardItemList != null) {
            boolean existFlag = false;
            boolean checkInFlag = false;
            ArrayList<PurchaseStandardItem> purchaseStandardItems = new ArrayList<PurchaseStandardItem>();
            for (SaleStandardItem entity : supplierStandardItemList) {
                if ("sale".equals(entity.getParticipants()) && loginUser.getSubAccount().equals(entity.getRespondents().split("_")[0])) {
                    if (!QuestionTypesEnum.SHORT_ANSWER.getValue().equals(entity.getInputType()) && StrUtil.isNotBlank((CharSequence)entity.getSelectAnswer())) {
                        entity.setItemStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                        List<SupplierStandardRegulationSelection> regulations = this.supplierStandardRegulationSelectionMapper.selectByMainId(entity.getStandardId());
                        HashMap scoreMap = new HashMap();
                        for (SupplierStandardRegulationSelection selection : regulations) {
                            scoreMap.put(selection.getSelectName(), selection.getScore());
                        }
                        String[] answers = StrUtil.isNotBlank((CharSequence)entity.getAnswer()) ? entity.getAnswer().split(",") : entity.getSelectAnswer().split(",");
                        BigDecimal score = new BigDecimal(0);
                        for (String answer : answers) {
                            if (scoreMap.get(answer) == null) continue;
                            score = score.add((BigDecimal)scoreMap.get(answer));
                        }
                        entity.setScore(score);
                        scoreTotal = scoreTotal.add(entity.getScore());
                    } else if (StrUtil.isNotBlank((CharSequence)entity.getAnswer())) {
                        entity.setItemStatus(ItemizedCheckStatusEnum.BE_EVALUATING.getValue());
                        existFlag = true;
                    } else if (!"1".equals(entity.getMust())) {
                        entity.setItemStatus(ItemizedCheckStatusEnum.BE_EVALUATING.getValue());
                    }
                    PurchaseStandardItem item = (PurchaseStandardItem)((Object)this.purchaseStandardItemMapper.selectById((Serializable)((Object)entity.getRelationId())));
                    if (item != null) {
                        item.setItemStatus(entity.getItemStatus());
                        item.setRelationId(entity.getId());
                        item.setAnswer(entity.getAnswer());
                        item.setSelectAnswer(entity.getSelectAnswer());
                        item.setScore(entity.getScore());
                        purchaseStandardItems.add(item);
                    }
                    itemAttachment.put(entity.getItemNumber(), (CallSite)((Object)(item.getHeadId() + "_" + item.getItemNumber())));
                    continue;
                }
                if (!ItemizedCheckStatusEnum.ANSWER_IN.getValue().equals(entity.getItemStatus())) continue;
                existFlag = true;
                supplierStandardHead.setStandardStatus(ItemizedCheckStatusEnum.ANSWER_IN.getValue());
            }
            if (!existFlag && !checkInFlag) {
                supplierStandardHead.setStandardStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                if (!"1".equals(supplierStandardHead.getAccessAuditBefore())) {
                    supplierStandardHead.setFinish("1");
                }
                for (PurchaseStandardItem purchaseStandardItem : purchaseStandardItems) {
                    purchaseStandardItem.setItemStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                }
            }
            if (supplierStandardHead.getFullMark() != null) {
                scoreTotal = scoreTotal.multiply(BigDecimal.valueOf(100.0)).divide(supplierStandardHead.getFullMark(), 2, 1);
            }
            supplierStandardHead.setTotalScore(scoreTotal);
            if (!supplierStandardItemList.isEmpty()) {
                ((SaleStandardItemService)SpringContextUtils.getBean(SaleStandardItemService.class)).updateBatchById(supplierStandardItemList);
                this.rebuildHead(supplierStandardHead);
            }
            this.supplierStandardHeadMapper.updateById((Object)supplierStandardHead);
            HashSet<String> purchaseIds = new HashSet<String>();
            BigDecimal totalScore = BigDecimal.ZERO;
            PurchaseStandardHead purchaseStandardHead = (PurchaseStandardHead)((Object)this.purchaseStandardHeadMapper.selectById((Serializable)((Object)supplierStandardHead.getRelationId())));
            if (!purchaseStandardItems.isEmpty()) {
                for (PurchaseStandardItem purchaseStandardItem : purchaseStandardItems) {
                    this.purchaseStandardItemMapper.updateById((Object)purchaseStandardItem);
                    purchaseIds.add(purchaseStandardItem.getId());
                    if (purchaseStandardItem.getScore() == null) continue;
                    totalScore = totalScore.add(purchaseStandardItem.getScore());
                }
                this.rebuildPurchaseHead(purchaseStandardHead);
            }
            if (purchaseStandardHead != null) {
                purchaseStandardHead.setRelationId(supplierStandardHead.getId());
                List<PurchaseStandardItem> items = this.purchaseStandardItemMapper.selectByMainId(purchaseStandardHead.getId());
                boolean flag = false;
                boolean finishFlag = false;
                for (PurchaseStandardItem purchaseStandardItem : items) {
                    if (purchaseIds.contains(purchaseStandardItem.getId())) continue;
                    if (ItemizedCheckStatusEnum.ANSWER_IN.getValue().equals(purchaseStandardItem.getItemStatus()) && "1".equals(purchaseStandardItem.getMust())) {
                        flag = true;
                    } else if (ItemizedCheckStatusEnum.BE_EVALUATING.getValue().equals(purchaseStandardItem.getItemStatus())) {
                        finishFlag = true;
                    }
                    if (purchaseStandardItem.getScore() == null || !"purchase".equals(purchaseStandardItem.getParticipants())) continue;
                    totalScore = totalScore.add(purchaseStandardItem.getScore());
                }
                if (purchaseStandardHead.getFullMark() != null) {
                    totalScore = totalScore.multiply(BigDecimal.valueOf(100.0)).divide(purchaseStandardHead.getFullMark(), 2, 1);
                }
                purchaseStandardHead.setTotalScore(totalScore);
                if (flag) {
                    purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.ANSWER_IN.getValue());
                } else if (finishFlag) {
                    purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.BE_EVALUATING.getValue());
                } else if (existFlag) {
                    purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.BE_EVALUATING.getValue());
                } else {
                    purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                    if (!"1".equals(purchaseStandardHead.getAccessAuditBefore())) {
                        purchaseStandardHead.setFinish("1");
                    }
                }
                this.purchaseStandardHeadMapper.updateById((Object)purchaseStandardHead);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
            for (SaleAttachmentDTO attachment : attachmentList) {
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)supplierStandardHead);
                attachment.setHeadId(supplierStandardHead.getId());
                attachment.setId(null);
                attachment.setSendStatus("1");
                if (!itemAttachment.containsKey(attachment.getItemNumber()) || !TenantContext.getTenant().equals(attachment.getUploadElsAccount()) || !loginUser.getSubAccount().equals(attachment.getUploadSubAccount())) continue;
                PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
                BeanUtils.copyProperties((Object)attachment, (Object)purchaseAttachment);
                purchaseAttachment.setId(null);
                purchaseAttachment.setRelationId(attachment.getId());
                purchaseAttachment.setElsAccount(supplierStandardHead.getToElsAccount());
                purchaseAttachment.setHeadId(((String)itemAttachment.get(attachment.getItemNumber())).split("_")[0]);
                purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseAttachment.setItemNumber(((String)itemAttachment.get(attachment.getItemNumber())).split("_")[1]);
                purchaseAttachments.add(purchaseAttachment);
            }
            this.invokeBaseRpcService.updateSaleAttachmentBatchById(attachmentList);
            if (purchaseAttachments.size() > 0) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
            }
        }
    }
}

