/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeBaseCatalogue;
import com.els.modules.knowledge.entity.KnowledgeCatalogue;
import com.els.modules.knowledge.enumerate.KnowledgeClassificationStatus;
import com.els.modules.knowledge.mapper.KnowledgeBaseCatalogueMapper;
import com.els.modules.knowledge.mapper.KnowledgeBaseMapper;
import com.els.modules.knowledge.mapper.KnowledgeCatalogueMapper;
import com.els.modules.knowledge.service.KnowledgeCatalogueService;
import com.els.modules.knowledge.vo.KnowledgeCatalogueNode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KnowledgeCatalogueServiceImpl
extends BaseServiceImpl<KnowledgeCatalogueMapper, KnowledgeCatalogue>
implements KnowledgeCatalogueService {
    @Autowired
    private KnowledgeBaseMapper knowledgeBaseMapper;
    @Autowired
    private KnowledgeBaseCatalogueMapper knowledgeBaseCatalogueMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePurchaseKnowledgeCatalogue(KnowledgeCatalogue catalogue) {
        catalogue.setLeaf(true);
        catalogue.setStatus("1");
        ((KnowledgeCatalogueMapper)this.baseMapper).insert((Object)catalogue);
        this.resetParent(catalogue.getParentId());
    }

    private void resetParent(String parentId) {
        KnowledgeCatalogue catalogue = new KnowledgeCatalogue();
        catalogue.setId(parentId);
        catalogue.setLeaf(false);
        int count = ((KnowledgeCatalogueMapper)this.baseMapper).updateById((Object)catalogue);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    private void resetOldParent(String parentId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(KnowledgeCatalogue::getParentId, (Object)parentId);
        long count = ((KnowledgeCatalogueMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        KnowledgeCatalogue catalogue = new KnowledgeCatalogue();
        catalogue.setId(parentId);
        catalogue.setLeaf(count <= 0L);
        count = ((KnowledgeCatalogueMapper)this.baseMapper).updateById((Object)catalogue);
        if (count == 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePurchaseKnowledgeCatalogue(KnowledgeCatalogue catalogue) {
        int count;
        KnowledgeCatalogue old = (KnowledgeCatalogue)((Object)((KnowledgeCatalogueMapper)this.baseMapper).selectById((Serializable)((Object)catalogue.getId())));
        if (!CharSequenceUtil.equals((CharSequence)old.getParentId(), (CharSequence)catalogue.getParentId())) {
            this.resetParent(catalogue.getParentId());
        } else {
            this.resetOldParent(old.getParentId());
        }
        if (CharSequenceUtil.isEmpty((CharSequence)catalogue.getAllParentId())) {
            catalogue.setAllParentId(old.getAllParentId());
        }
        if ((count = ((KnowledgeCatalogueMapper)this.baseMapper).updateById((Object)catalogue)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void delPurchaseKnowledgeCatalogue(String id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(KnowledgeCatalogue::getParentId, (Object)id);
        long count = ((KnowledgeCatalogueMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIHMKJIHWxiTQG_738e14e2", (String)"\u5f53\u524d\u76ee\u5f55\u5b58\u5728\u5b50\u76ee\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(KnowledgeBase::getKnowledgeCatalogue, (Object)id);
        count = this.knowledgeBaseMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIHMKJLQIWxiTQG_9a704651", (String)"\u5f53\u524d\u76ee\u5f55\u5b58\u5728\u8d44\u6599\u6587\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        LambdaQueryWrapper saleQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)saleQueryWrapper.eq(KnowledgeBaseCatalogue::getSaleKnowledgeCatalogue, (Object)id)).eq(KnowledgeBaseCatalogue::getSaleKnowledgeStatus, (Object)KnowledgeClassificationStatus.BEEN_CLASSIFIED.getValue())).eq(KnowledgeBaseCatalogue::getElsAccount, (Object)TenantContext.getTenant());
        count = this.knowledgeBaseCatalogueMapper.selectCount((Wrapper)saleQueryWrapper);
        if (count > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIHMKJLQIWxiTQG_9a704651", (String)"\u5f53\u524d\u76ee\u5f55\u5b58\u5728\u8d44\u6599\u6587\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        ((KnowledgeCatalogueMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseKnowledgeCatalogue(List<String> idList) {
        ((KnowledgeCatalogueMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<KnowledgeCatalogue> queryChildList(String id, String deptCode) {
        if ("1".equals(AdminFlagUtil.getAdminFlag())) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(KnowledgeCatalogue::getStatus, (Object)"1")).eq(KnowledgeCatalogue::getParentId, (Object)id);
            wrapper.orderByAsc(KnowledgeCatalogue::getSortOrder);
            return ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)wrapper);
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(KnowledgeCatalogue::getStatus, (Object)"1")).eq(KnowledgeCatalogue::getParentId, (Object)id);
        wrapper.orderByAsc(KnowledgeCatalogue::getSortOrder);
        List list = ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)wrapper);
        ArrayList codeList = Lists.newArrayList((Object[])deptCode.split(","));
        return list.stream().filter(x -> {
            String visitorPerm = x.getVisitorPerm();
            if (CharSequenceUtil.isEmpty((CharSequence)visitorPerm)) {
                return true;
            }
            if (codeList.isEmpty()) {
                return false;
            }
            ArrayList temList = Lists.newArrayList((Object[])visitorPerm.split(","));
            int size = temList.size();
            temList.removeAll(codeList);
            return size != temList.size();
        }).collect(Collectors.toList());
    }

    @Override
    public KnowledgeCatalogue catalogueInit() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(KnowledgeCatalogue::getParentId, (Object)"0");
        KnowledgeCatalogue catalogue = (KnowledgeCatalogue)((Object)((KnowledgeCatalogueMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == catalogue) {
            catalogue = new KnowledgeCatalogue();
            catalogue.setSortOrder(0);
            catalogue.setCatalogueName("/");
            catalogue.setParentId("0");
            catalogue.setAllParentId("0");
            catalogue.setVisitorPerm("");
            catalogue.setAdminUser(SysUtil.getLoginUser().getId());
            catalogue.setLeaf(true);
            catalogue.setElsAccount(TenantContext.getTenant());
            catalogue.setDeleted(0);
            catalogue.setDataVersion(0);
            catalogue.setStatus("1");
            catalogue.setId(IdWorker.getIdStr());
            ((KnowledgeCatalogueMapper)this.baseMapper).insert((Object)catalogue);
        }
        return catalogue;
    }

    @Override
    public List<KnowledgeCatalogue> querySaleChildList(String parentId) {
        return ((KnowledgeCatalogueMapper)this.baseMapper).querySaleChildList(SysUtil.getLoginUser().getElsAccount(), parentId);
    }

    @Override
    public List<KnowledgeCatalogue> queryChildListWithPerms(String parentId, String deptCode) {
        String adminFlag = AdminFlagUtil.getAdminFlag();
        if ("1".equals(adminFlag)) {
            return ((KnowledgeCatalogueMapper)this.baseMapper).queryChildListWithAdmin(parentId, SysUtil.getLoginUser().getElsAccount());
        }
        return ((KnowledgeCatalogueMapper)this.baseMapper).queryChildListWithPerms(parentId, deptCode, SysUtil.getLoginUser().getElsAccount());
    }

    @Override
    public List<String> loadAllChild(String elsAccount, String pid, String visitorPermIds) {
        String adminFlag = AdminFlagUtil.getAdminFlag();
        boolean isAdmin = false;
        if ("1".equals(adminFlag)) {
            isAdmin = true;
        }
        List<KnowledgeCatalogue> allCatalogues = ((KnowledgeCatalogueMapper)this.baseMapper).loadAllChildForJavaLogic(elsAccount);
        List<KnowledgeCatalogue> catalogueList = this.filterCatalogues(allCatalogues, pid, visitorPermIds, isAdmin);
        List<String> ids = catalogueList.stream().map(x -> Lists.newArrayList((Object[])new String[]{x.getId(), x.getParentId()})).flatMap(Collection::stream).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
        ids.add(pid);
        return ids;
    }

    public List<KnowledgeCatalogue> filterCatalogues(List<KnowledgeCatalogue> allCatalogues, String rootParentId, String visitorPermIds, boolean isAdmin) {
        ArrayList<KnowledgeCatalogue> result = new ArrayList<KnowledgeCatalogue>();
        HashSet<String> processingParentIds = new HashSet<String>();
        processingParentIds.add(rootParentId);
        Map<String, List<KnowledgeCatalogue>> parentIdMap = allCatalogues.stream().collect(Collectors.groupingBy(KnowledgeCatalogue::getParentId));
        while (!processingParentIds.isEmpty()) {
            HashSet<String> nextParentIds = new HashSet<String>();
            for (String parentId : processingParentIds) {
                List children = parentIdMap.getOrDefault(parentId, Collections.emptyList());
                for (KnowledgeCatalogue child : children) {
                    if (!this.checkVisitorPerm(child.getVisitorPerm(), visitorPermIds) && !isAdmin) continue;
                    result.add(child);
                    nextParentIds.add(child.getId());
                }
            }
            processingParentIds = nextParentIds;
        }
        return result;
    }

    private boolean checkVisitorPerm(String perm1, String perm2) {
        if (CharSequenceUtil.isEmpty((CharSequence)perm1) && CharSequenceUtil.isEmpty((CharSequence)perm2)) {
            return false;
        }
        if (CharSequenceUtil.isEmpty((CharSequence)perm1) || CharSequenceUtil.isEmpty((CharSequence)perm2)) {
            return true;
        }
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(perm1.split(",")));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(perm2.split(",")));
        for (String s : set1) {
            if (!set2.contains(s)) continue;
            return true;
        }
        return false;
    }

    private List<KnowledgeCatalogueNode> buildTree(List<KnowledgeCatalogueNode> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        for (KnowledgeCatalogueNode catalogue : all) {
            catalogue.setChildren(this.getChildren(catalogue, all));
            if (!rootId.equals(catalogue.getParentId()) || catalogue.getId().equals(catalogue.getParentId())) continue;
            parent.add(catalogue);
        }
        return parent;
    }

    private List<KnowledgeCatalogueNode> getChildren(KnowledgeCatalogueNode catalogueNode, List<KnowledgeCatalogueNode> all) {
        ArrayList<KnowledgeCatalogueNode> childList = new ArrayList<KnowledgeCatalogueNode>(8);
        for (KnowledgeCatalogueNode child : all) {
            if (!catalogueNode.getId().equals(child.getParentId()) || catalogueNode.getId().equals(catalogueNode.getParentId())) continue;
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    @Override
    public List<KnowledgeCatalogueNode> loadKnowledgeCatalogueTree(QueryWrapper<KnowledgeCatalogue> queryWrapper) {
        String deptCode = CharSequenceUtil.emptyToDefault((CharSequence)SysUtil.getLoginUser().getOrgCode(), (String)"");
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).in(KnowledgeCatalogue::getStatus, new Object[]{"1"})).orderByAsc(KnowledgeCatalogue::getSortOrder)).orderByAsc(BaseEntity::getCreateTime);
        List list = ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        List<KnowledgeCatalogueNode> nodes = list.stream().map(x -> {
            KnowledgeCatalogueNode node = new KnowledgeCatalogueNode();
            node.setId(x.getId());
            node.setKey(x.getId());
            node.setName(x.getCatalogueName());
            node.setVisitorPerm(x.getVisitorPerm());
            node.setOrder(x.getSortOrder());
            node.setParentId(x.getParentId());
            node.setHasCreatePerm(CharSequenceUtil.isNotEmpty((CharSequence)x.getAdminUser()) && x.getAdminUser().contains(SysUtil.getLoginUser().getId()) || "1".equals(AdminFlagUtil.getAdminFlag()));
            node.setAdminUser(x.getAdminUser());
            node.setTitle(x.getCatalogueName());
            node.setDisabled(!node.isHasCreatePerm());
            return node;
        }).collect(Collectors.toList());
        return this.buildTree(nodes, "0");
    }

    @Override
    public List<KnowledgeCatalogueNode> loadKnowledgeCatalogueList(QueryWrapper<KnowledgeCatalogue> queryWrapper) {
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).in(KnowledgeCatalogue::getStatus, new Object[]{"1"});
        List list = ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list.stream().map(x -> {
            KnowledgeCatalogueNode node = new KnowledgeCatalogueNode();
            node.setId(x.getId());
            node.setKey(x.getId());
            node.setName(x.getCatalogueName());
            node.setOrder(x.getSortOrder());
            node.setParentId(x.getParentId());
            node.setTitle(x.getCatalogueName());
            return node;
        }).collect(Collectors.toList());
    }

    public List<KnowledgeCatalogue> querySaleChildList(String parentId, List<String> purchaseList) {
        if (CollectionUtil.isEmpty(purchaseList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ParentEntity::getId, KnowledgeCatalogue::getParentId, KnowledgeCatalogue::getCatalogueName, KnowledgeCatalogue::getSortOrder, KnowledgeCatalogue::getVisitorPerm});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(KnowledgeCatalogue::getStatus, (Object)"1")).eq(KnowledgeCatalogue::getParentId, (Object)parentId)).in(ParentEntity::getElsAccount, purchaseList);
        wrapper.orderByAsc(KnowledgeCatalogue::getSortOrder);
        return ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }
}

