/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.excel;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.performance.dto.EvaScoreDto;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.enumerate.ScoreMethodEnum;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchasePerformanceReportItemEvaImportService {
    private static final LinkedHashMap<String, Object> COLUMN_NAME = new LinkedHashMap(15);
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Autowired
    private PurchasePerformanceReportItemService purchasePerformanceReportItemService;

    public Result<?> importExcel(String id, InputStream inputStream) {
        EvaScoreDto scoreDto;
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)id)));
        List importDataList = EasyExcel.read((InputStream)inputStream).sheet().headRowNumber(Integer.valueOf(0)).doReadSync();
        if (importDataList == null || importDataList.isEmpty() || importDataList.size() == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uNjWFLVW_520c608", (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a!"));
        }
        if (importDataList.size() < 3) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uNjQIIrjSW_95290893", (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u6a21\u677f\u6709\u8bef!"));
        }
        LinkedHashMap columnKeys = (LinkedHashMap)importDataList.get(2);
        for (String key : COLUMN_NAME.keySet()) {
            if (!COLUMN_NAME.get(key).equals(columnKeys.get(key))) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n__uNjQIIrjSWVjuGWFjIruNW_220cd861", (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u6a21\u677f\u6709\u8bef\uff0c\u8bf7\u7528\u5bfc\u51fa\u6570\u636e\u7684\u6a21\u677f\u5bfc\u5165!"));
        }
        if (importDataList.size() == 3) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uNjWFxOLVW_41b709b8", (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        ArrayList<String> idList = new ArrayList<String>();
        LinkedHashMap<String, EvaScoreDto> dataMap = new LinkedHashMap<String, EvaScoreDto>();
        List subList = importDataList.subList(3, importDataList.size());
        for (LinkedHashMap map : subList) {
            Object mId = map.get(0);
            Object scoringMethod = map.get(5);
            Object normValue = map.get(10);
            Object score = map.get(11);
            if (mId == null) continue;
            idList.add(mId.toString());
            scoreDto = new EvaScoreDto();
            scoreDto.setId(mId != null ? mId.toString() : "");
            scoreDto.setScoringMethod(scoringMethod != null ? scoringMethod.toString() : "");
            scoreDto.setNormValue(normValue != null ? new BigDecimal(normValue.toString()) : null);
            scoreDto.setScore(score != null ? new BigDecimal(score.toString()) : null);
            dataMap.put(mId.toString(), scoreDto);
        }
        List collectIds = idList.stream().distinct().collect(Collectors.toList());
        if (collectIds.size() != subList.size()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__uNjQIIrjSWVjuGWFjIruNW_220cd861", (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u6a21\u677f\u6709\u8bef\uff0c\u8bf7\u7528\u5bfc\u51fa\u6570\u636e\u7684\u6a21\u677f\u5bfc\u5165!"));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", collectIds);
        List itemList = this.purchasePerformanceReportItemService.list((Wrapper)queryWrapper);
        if (collectIds.size() != itemList.size()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__uNjQIIrjSWVjuGWFjIruNW_220cd861", (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u6a21\u677f\u6709\u8bef\uff0c\u8bf7\u7528\u5bfc\u51fa\u6570\u636e\u7684\u6a21\u677f\u5bfc\u5165!"));
        }
        for (PurchasePerformanceReportItem item : itemList) {
            scoreDto = (EvaScoreDto)dataMap.get(item.getId());
            if (ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(item.getScoringMethod())) {
                item.setNormValue(scoreDto.getNormValue() != null ? scoreDto.getNormValue() : item.getNormValue());
            }
            if (!ScoreMethodEnum.MANUAL_SCORE.getValue().equals(item.getScoringMethod())) continue;
            item.setScore(scoreDto.getScore() != null ? scoreDto.getScore() : item.getScore());
        }
        this.purchasePerformanceReportHeadService.evaOptSave(head, itemList);
        return Result.ok();
    }

    static {
        COLUMN_NAME.put("0", "\u5355\u636eID");
        COLUMN_NAME.put("1", "\u6307\u6807\u7f16\u7801");
        COLUMN_NAME.put("2", "\u6307\u6807\u540d\u79f0");
        COLUMN_NAME.put("3", "\u6307\u6807\u7c7b\u578b");
        COLUMN_NAME.put("4", "\u6307\u6807\u7c7b\u578b\u6743\u91cd(%)'");
        COLUMN_NAME.put("5", "\u6253\u5206\u65b9\u5f0f");
        COLUMN_NAME.put("6", "\u4f9b\u5e94\u5546ELS\u8d26\u53f7");
        COLUMN_NAME.put("7", "\u4f9b\u5e94\u5546\u540d\u79f0");
        COLUMN_NAME.put("8", "\u6ee1\u5206");
        COLUMN_NAME.put("9", "\u6307\u6807\u6743\u91cd(%)");
        COLUMN_NAME.put("10", "\u6307\u6807\u503c");
        COLUMN_NAME.put("11", "\u5f97\u5206");
        COLUMN_NAME.put("12", "\u6743\u91cd\u5206\u6570");
        COLUMN_NAME.put("13", "\u8bc4\u5206\u4eba");
        COLUMN_NAME.put("14", "\u8bc4\u5206\u65f6\u95f4");
    }
}

