/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.myschedule.entity.MySchedule;
import com.els.modules.myschedule.mapper.MyScheduleMapper;
import com.els.modules.myschedule.service.MyScheduleService;
import com.els.modules.supplier.entity.PurchaseVisitHead;
import com.els.modules.supplier.enumerate.VisitStatusEnum;
import com.els.modules.supplier.service.PurchaseVisitHeadService;
import com.els.modules.supplier.vo.PurchaseVisitHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="purchaseVisitRpcAdapter")
public class PurchaseVisitAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseVisitHeadService purchaseVisitHeadService;
    @Resource
    private MyScheduleMapper myScheduleMapper;
    @Autowired
    private MyScheduleService myScheduleService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseVisitHead head = (PurchaseVisitHead)((Object)this.purchaseVisitHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseVisitHead purchaseVisitHead = (PurchaseVisitHead)((Object)this.purchaseVisitHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        if (VisitStatusEnum.NEW.getValue().equals(purchaseVisitHead.getVisitStatus()) && AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            int count = this.myScheduleMapper.selectWithoutElsAccountConflict(purchaseVisitHead.getToElsAccount(), purchaseVisitHead.getIntervieweePrincipal(), purchaseVisitHead.getVisitStartTime(), purchaseVisitHead.getVisitEndTime());
            Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APUZmCKIIjBLpAVVVHVUZmCKI_dad8d2b2", (String)"\u5f53\u524d\u9884\u7ea6\u62dc\u8bbf\u65f6\u95f4\u5df2\u6709\u65e5\u7a0b\u5b89\u6392\uff0c\u8bf7\u91cd\u65b0\u66f4\u65b0\u9884\u7ea6\u62dc\u8bbf\u65f6\u95f4\u3002"));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
            queryWrapper.eq(MySchedule::getSubAccount, (Object)purchaseVisitHead.getVisitPrincipal());
            queryWrapper.lt(MySchedule::getBeginTime, (Object)purchaseVisitHead.getVisitEndTime());
            queryWrapper.gt(MySchedule::getEndTime, (Object)purchaseVisitHead.getVisitStartTime());
            Assert.isTrue((this.myScheduleService.count((Wrapper)queryWrapper) == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APIIjBLjVPsMKm_5dbd60fd", (String)"\u5f53\u524d\u5b9a\u4e49\u7684\u65e5\u7a0b\u6709\u51b2\u7a81\uff0c\u4fdd\u5b58\u5931\u8d25\uff01"));
        }
        purchaseVisitHead.setAuditStatus(auditStatus);
        purchaseVisitHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus) && "1".equals(purchaseVisitHead.getSend())) {
            PurchaseVisitHeadVO purchaseVisitHeadVO = this.purchaseVisitHeadService.queryById(flowCallbackDTO.getBusinessId());
            purchaseVisitHeadVO.setAuditStatus(auditStatus);
            purchaseVisitHeadVO.setFlowId(flowCallbackDTO.getProcessInstanceId());
            this.purchaseVisitHeadService.publishAudit(purchaseVisitHeadVO);
        }
    }
}

