/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;

@RpcService(value="supplierAddressDataExcelRpcHandler")
public class SupplierAddressDataExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Lazy
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierAddressInfoService supplierAddressInfoService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService elsEnterpriseInfoService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<SupplierAddressInfo> addressInfos = new ArrayList<SupplierAddressInfo>();
        for (Map data : dataList) {
            SupplierAddressInfo entity = (SupplierAddressInfo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), SupplierAddressInfo.class));
            if (StrUtil.isBlank((CharSequence)entity.getElsAccount())) {
                String msg = I18nUtil.translate((String)"i18n_alert_RRRdXAo_dc815cc1", (String)"\u7f3a\u5c11\u4f9b\u5e94\u5546\u7f16\u7801");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            entity.setDeleted(CommonConstant.DEL_FLAG_0);
            addressInfos.add(entity);
        }
        List<String> elsAccountList = addressInfos.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getElsAccount())).map(ParentEntity::getElsAccount).distinct().collect(Collectors.toList());
        List<ElsEnterpriseInfoDTO> accountList = this.elsEnterpriseInfoService.queryByElsAccountList(elsAccountList);
        Map accountMap = accountList.stream().collect(Collectors.toMap(ParentEntityDTO::getElsAccount, Function.identity(), (v1, v2) -> v1));
        int size = addressInfos.size();
        for (int i = size - 1; i >= 0; --i) {
            ((SupplierAddressInfo)((Object)addressInfos.get(i))).setToElsAccount(SysUtil.getLoginUser().getElsAccount());
            String elsAccount = ((SupplierAddressInfo)((Object)addressInfos.get(i))).getElsAccount();
            if (!StrUtil.isEmpty((CharSequence)elsAccount) && null != accountMap.get(elsAccount)) continue;
            addressInfos.remove(i);
        }
        if (CollUtil.isNotEmpty(addressInfos)) {
            List<SupplierMasterData> supplierMasterData = this.supplierMasterDataService.listByToElsAccount(elsAccountList);
            Map dataMap = supplierMasterData.stream().collect(Collectors.toMap(SupplierMasterData::getToElsAccount, Function.identity(), (v1, v2) -> v2));
            addressInfos.forEach(ct -> {
                SupplierMasterData masterData = (SupplierMasterData)((Object)((Object)dataMap.get(ct.getElsAccount())));
                if (masterData != null) {
                    ct.setHeadId(masterData.getId());
                }
            });
        }
        this.supplierAddressInfoService.saveBatch(addressInfos);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

