/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.message.listener;

import com.alibaba.fastjson.JSON;
import com.els.common.context.TokenContext;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.mq.api.service.MqMessageRecordRpcService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.RegisterMqDataVo;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class RegisterMessageConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegisterMessageConsumer.class);
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;

    @Bean(value={"inputReg"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
            String msgBody = (String)message.getPayload();
            log.info("\u6ce8\u518c\u4fe1\u606f log:  " + msgBody);
            String msgStatus = ((MqMessageRecordRpcService)SrmRpcUtil.getExecuteServiceImpl(MqMessageRecordRpcService.class)).getMsgStatusById(key);
            if ("consumed".equals(msgStatus)) {
                log.error("\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
                return;
            }
            String errorInfo = "";
            try {
                RegisterMqDataVo registerMqDataVo = (RegisterMqDataVo)JSON.parseObject((String)msgBody, RegisterMqDataVo.class);
                TenantContext.setTenant((String)registerMqDataVo.getTenant());
                LoginUserContext.setUser((LoginUserDTO)registerMqDataVo.getLoginUser());
                TokenContext.setToken((String)registerMqDataVo.getToken());
                this.supplierMasterDataService.registerMqdataDeal(registerMqDataVo);
                log.info(msgBody);
                msgStatus = "consumed";
            }
            catch (Exception e) {
                log.error("\u6ce8\u518c\u4fe1\u606f log failed:" + msgBody, (Throwable)e);
                msgStatus = "error";
                errorInfo = e.getMessage();
            }
            finally {
                TenantContext.clear();
                LoginUserContext.clear();
                TokenContext.clear();
                ((MqMessageRecordRpcService)SrmRpcUtil.getExecuteServiceImpl(MqMessageRecordRpcService.class)).updateRecord(key, msgStatus, errorInfo);
            }
        };
    }
}

