/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.global.api.service.impl;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.api.service.GroupChatRecordUserRpcService;
import com.els.modules.im.enums.ImBusinessTypeEnum;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.SalePerformanceReportHead;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.SalePerformanceReportHeadService;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.SaleStandardHead;
import com.els.modules.supplier.service.PurchaseStandardHeadService;
import com.els.modules.supplier.service.SaleStandardHeadService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

@RpcService(value="supplierImUserRecordRpcService")
public class SupplierDubboImUserRecordRpcService
implements GroupChatRecordUserRpcService {
    @Resource
    private SaleStandardHeadService saleStandardHeadService;
    @Resource
    private PurchaseStandardHeadService purchaseStandardHeadService;
    @Resource
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Resource
    private SalePerformanceReportHeadService salePerformanceReportHeadService;

    public List<RecordUserDto> loadGroupChatUserByRecord(GroupChatRecordDto imRecordDto) {
        AccountInfoRpcService accountInfoRpcService = (AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class);
        ArrayList<RecordUserDto> resultList = new ArrayList<RecordUserDto>();
        if (ImBusinessTypeEnum.SUPPLIER_ACCESS_SALE_HEAD.getValue().equals(imRecordDto.getBusinessType())) {
            SaleStandardHead dbHead = (SaleStandardHead)((Object)this.saleStandardHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_zdImtWWWWxMK_a4152cc", (String)"\u5206\u9879\u68c0\u67e5\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = dbHead.getElsSubAccount();
            RecordUserDto e = new RecordUserDto();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        } else {
            if (ImBusinessTypeEnum.PURCHASE_STANDARD_HEAD.getValue().equals(imRecordDto.getBusinessType())) {
                PurchaseStandardHead dbHead = (PurchaseStandardHead)((Object)this.purchaseStandardHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_zdImtWWWWxMK_a4152cc", (String)"\u5206\u9879\u68c0\u67e5\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
                return this.queryAllUserWithGroupChat(accountInfoRpcService, Lists.newArrayList((Object[])new String[]{dbHead.getToElsAccount()}));
            }
            if (ImBusinessTypeEnum.PURCHASE_PERFORMANCE_REPORT.getValue().equals(imRecordDto.getBusinessType())) {
                PurchasePerformanceReportHead dbHead = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
                return this.queryAllUserWithGroupChat(accountInfoRpcService, Lists.newArrayList((Object[])new String[]{dbHead.getToElsAccount()}));
            }
            if (ImBusinessTypeEnum.SALE_PERFORMANCE_REPORT.getValue().equals(imRecordDto.getBusinessType())) {
                SalePerformanceReportHead dbHead = (SalePerformanceReportHead)((Object)this.salePerformanceReportHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
                Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
                String toElsAccount = dbHead.getToElsAccount();
                String subAccount = dbHead.getCreateBy();
                RecordUserDto e = new RecordUserDto();
                e.setElsAccount(toElsAccount + "_" + subAccount);
                resultList.add(e);
            }
        }
        return resultList;
    }
}

