/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.handle;

import com.els.common.event.AsyncEventHandler;
import com.els.common.event.AsyncEventMessage;
import com.els.common.event.AsyncEventType;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeCollect;
import com.els.modules.knowledge.entity.KnowledgeLike;
import com.els.modules.knowledge.event.SupplierAsyncEventType;
import com.els.modules.knowledge.service.KnowledgeBaseService;
import com.els.modules.knowledge.service.KnowledgeCollectService;
import com.els.modules.knowledge.service.KnowledgeCommentService;
import com.els.modules.knowledge.service.KnowledgeLikeService;
import com.els.modules.knowledge.service.KnowledgeVisitorService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KnowledgeHandler
implements AsyncEventHandler {
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;
    @Autowired
    private KnowledgeCommentService knowledgeCommentService;
    @Autowired
    private KnowledgeCollectService knowledgeCollectService;
    @Autowired
    private KnowledgeVisitorService knowledgeVisitorService;
    @Autowired
    private KnowledgeLikeService knowledgeLikeService;

    public void doHandle(AsyncEventMessage message) {
        String dataId = message.getDataId();
        if ("collectData".equals(message.getBusinessType())) {
            dataId = ((KnowledgeCollect)this.knowledgeCollectService.getById((Serializable)((Object)dataId))).getKnowledgeId();
        } else if ("likeData".equals(message.getBusinessType())) {
            dataId = ((KnowledgeLike)this.knowledgeLikeService.getById((Serializable)((Object)dataId))).getKnowledgeId();
        }
        long commentCount = this.knowledgeCommentService.countKnowledge(dataId);
        long collectCount = this.knowledgeCollectService.countKnowledge(dataId);
        long visitorCount = this.knowledgeVisitorService.countKnowledge(dataId);
        long likeCount = this.knowledgeLikeService.countKnowledge(dataId);
        KnowledgeBase base = new KnowledgeBase();
        base.setId(dataId);
        base.setVisitorVolume(visitorCount);
        base.setCollectVolume(collectCount);
        base.setCommentVolume(commentCount);
        base.setLikeVolume(likeCount);
        this.knowledgeBaseService.updateById((Object)base);
    }

    public List<AsyncEventType> getSupportEventTypes() {
        return Collections.singletonList(SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
    }
}

