/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.modules.knowledge.entity.KnowledgeComment;
import com.els.modules.knowledge.mapper.KnowledgeCommentMapper;
import com.els.modules.knowledge.service.KnowledgeCommentService;
import com.els.modules.knowledge.vo.KnowledgeCommentVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeCommentServiceImpl
extends ServiceImpl<KnowledgeCommentMapper, KnowledgeComment>
implements KnowledgeCommentService {
    @Override
    public void saveKnowledgeComment(KnowledgeComment comment) {
        this.save((Object)comment);
    }

    @Override
    public void delKnowledgeComment(String id) {
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public void delBatchKnowledgeComment(List<String> idList) {
        this.removeByIds(idList);
    }

    @Override
    public List<KnowledgeCommentVo> listCommentByKnowledgeId(String knowledgeId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(KnowledgeComment::getKnowledgeId, (Object)knowledgeId);
        wrapper.orderByAsc(BaseEntity::getCreateTime);
        List commentList = ((KnowledgeCommentMapper)this.baseMapper).selectList((Wrapper)wrapper);
        List nodes = Convert.toList(KnowledgeCommentVo.class, (Object)commentList);
        return this.buildTree(nodes, "0");
    }

    public IPage<KnowledgeCommentVo> pageRootCommentByKnowledgeId(String knowledgeId, Page<KnowledgeComment> page) {
        return ((KnowledgeCommentMapper)this.baseMapper).pageRootComment(knowledgeId, page);
    }

    @Override
    public IPage<KnowledgeCommentVo> pageRootTreeCommentByKnowledgeId(String knowledgeId, Page<KnowledgeComment> page) {
        IPage<KnowledgeCommentVo> rootComment = ((KnowledgeCommentMapper)this.baseMapper).pageRootComment(knowledgeId, page);
        if (CollectionUtil.isEmpty((Collection)rootComment.getRecords())) {
            return rootComment;
        }
        List rootIds = rootComment.getRecords().stream().map(ParentEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(KnowledgeComment::getKnowledgeId, (Object)knowledgeId)).in(KnowledgeComment::getRootId, rootIds);
        List allList = ((KnowledgeCommentMapper)this.baseMapper).selectList((Wrapper)wrapper);
        List commentVoList = Convert.toList(KnowledgeCommentVo.class, (Object)allList);
        rootComment.setRecords(this.buildTree(commentVoList, "0"));
        return rootComment;
    }

    private List<KnowledgeCommentVo> buildTree(List<KnowledgeCommentVo> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        for (KnowledgeCommentVo commentNode : all) {
            commentNode.setChildren(this.getChildren(commentNode, all));
            if (!rootId.equals(commentNode.getParentId()) || commentNode.getId().equals(commentNode.getParentId())) continue;
            parent.add(commentNode);
        }
        return parent;
    }

    private List<KnowledgeCommentVo> getChildren(KnowledgeCommentVo commentNode, List<KnowledgeCommentVo> all) {
        ArrayList<KnowledgeCommentVo> childList = new ArrayList<KnowledgeCommentVo>(8);
        for (KnowledgeCommentVo child : all) {
            if (!commentNode.getId().equals(child.getParentId()) || commentNode.getId().equals(commentNode.getParentId())) continue;
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    @Override
    public long countKnowledge(String dataId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(KnowledgeComment::getKnowledgeId, (Object)dataId);
        return ((KnowledgeCommentMapper)this.baseMapper).selectCount((Wrapper)wrapper);
    }
}

