/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.api.service.impl;

import cn.hutool.core.convert.Convert;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.entity.PurchasePerformanceReportSupplier;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.vo.PurchasePerformanceReportHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchasePerformanceResultDubboAdapter")
public class PurchasePerformanceResultAdapter
implements WorkflowAuditOptCallBackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceResultAdapter.class);
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchasePerformanceReportHeadVO headVO = this.purchasePerformanceReportHeadService.queryById(flowCallbackDTO.getBusinessId());
        PurchasePerformanceReportHead head = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        List<PurchasePerformanceReportSupplier> supplierList = headVO.getPurchasePerformanceReportSupplierList();
        List itemList = Convert.toList(PurchasePerformanceReportItem.class, headVO.getPurchasePerformanceReportItemList());
        for (PurchasePerformanceReportSupplier supplier : supplierList) {
            supplier.setItemList(itemList.stream().filter(o -> supplier.getToElsAccount().equals(o.getToElsAccount())).collect(Collectors.toList()));
            this.purchasePerformanceReportHeadService.reportPerformanceResultToSupplierNew(head, supplier);
        }
        head.setDataVersion(((PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)head.getId())))).getDataVersion());
        this.purchasePerformanceReportHeadService.updateById((Object)head);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String businessId) {
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)businessId)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchasePerformanceReportHead head = new PurchasePerformanceReportHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchasePerformanceReportHeadService.updateById((Object)head);
    }
}

