/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.performance.entity.PurchasePerformanceNormFormula;
import com.els.modules.performance.entity.PurchasePerformanceNormGrad;
import com.els.modules.performance.entity.PurchasePerformanceNormHead;
import com.els.modules.performance.enumerate.PerformanceNormStatusEnum;
import com.els.modules.performance.service.PurchasePerformanceNormFormulaService;
import com.els.modules.performance.service.PurchasePerformanceNormGradService;
import com.els.modules.performance.service.PurchasePerformanceNormHeadService;
import com.els.modules.performance.vo.PurchasePerformanceNormHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/performance/purchasePerformanceNormHead"})
@Tag(name="\u91c7\u8d2d\u7ee9\u6548\u6307\u6807")
@BusinessModule(module="performanceNorm")
public class PurchasePerformanceNormHeadController
extends BaseController<PurchasePerformanceNormHead, PurchasePerformanceNormHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceNormHeadController.class);
    @Autowired
    private PurchasePerformanceNormHeadService purchasePerformanceNormHeadService;
    @Autowired
    private PurchasePerformanceNormGradService purchasePerformanceNormGradService;
    @Autowired
    private PurchasePerformanceNormFormulaService purchasePerformanceNormFormulaService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:list"})
    @PermissionDataView(businessType="performanceNorm")
    public Result<?> queryPageList(PurchasePerformanceNormHead purchasePerformanceNormHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePerformanceNormHead), (Map)req.getParameterMap());
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePerformanceNormHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548\u6307\u6807-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:add"})
    @PermissionDataOpt(businessType="performanceNorm", beanClass=PurchasePerformanceNormHeadService.class)
    public Result<?> add(@RequestBody PurchasePerformanceNormHeadVO headVO) {
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchasePerformanceNormHead normHead = new PurchasePerformanceNormHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)normHead));
        String normNumber = this.invokeBaseRpcService.getNextCode("srmNormNumber", (Object)normHead);
        String elsAccount = this.getTenantId();
        normHead.setNormNumber(normNumber);
        normHead.setElsAccount(elsAccount);
        normHead.setBusAccount(elsAccount);
        this.purchasePerformanceNormHeadService.saveMain(normHead, headVO.getPurchasePerformanceNormGradList(), headVO.getPurchasePerformanceNormFormulaList());
        return Result.ok((Object)((Object)normHead));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548\u6307\u6807-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:edit"})
    @PermissionDataOpt(businessType="performanceNorm", beanClass=PurchasePerformanceNormHeadService.class)
    public Result<?> edit(@RequestBody PurchasePerformanceNormHeadVO headVO) {
        PurchasePerformanceNormHead normHead = new PurchasePerformanceNormHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)normHead));
        this.purchasePerformanceNormHeadService.updateMain(normHead, headVO.getPurchasePerformanceNormGradList(), headVO.getPurchasePerformanceNormFormulaList());
        String id = normHead.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548\u6307\u6807-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:delete"})
    @PermissionDataOpt(businessType="performanceNorm", beanClass=PurchasePerformanceNormHeadService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchasePerformanceNormHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548\u6307\u6807-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchasePerformanceNormHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548\u6307\u6807-\u901a\u8fc7id\u67e5\u8be2")
    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:view"})
    @PermissionDataOpt(businessType="performanceNorm", beanClass=PurchasePerformanceNormHeadService.class)
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchasePerformanceNormHead normHead = (PurchasePerformanceNormHead)((Object)this.purchasePerformanceNormHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchasePerformanceNormHeadVO headVO = new PurchasePerformanceNormHeadVO();
        BeanUtils.copyProperties((Object)((Object)normHead), (Object)((Object)headVO));
        List<PurchasePerformanceNormGrad> normGradList = this.purchasePerformanceNormGradService.selectByMainId(id);
        headVO.setPurchasePerformanceNormGradList(normGradList);
        List<PurchasePerformanceNormFormula> normFormulaList = this.purchasePerformanceNormFormulaService.selectByMainId(id);
        headVO.setPurchasePerformanceNormFormulaList(normFormulaList);
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        headVO.setPurchaseAttachmentList(attachmentList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548\u6307\u6807-\u67e5\u8be2\u6307\u6807\u8bc4\u5206\u7ec6\u5219")
    @Operation(summary="\u67e5\u8be2\u6307\u6807\u8bc4\u5206\u7ec6\u5219", description="\u67e5\u8be2\u6307\u6807\u8bc4\u5206\u7ec6\u5219")
    @GetMapping(value={"/listNormGrad"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:list"})
    @PermissionDataView(businessType="performanceNorm")
    public Result<?> listNormGrad(PurchasePerformanceNormGrad normGrad, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)normGrad), (Map)req.getParameterMap());
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePerformanceNormGradService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548\u6307\u6807-\u4f5c\u5e9f")
    @Operation(summary="\u4f5c\u5e9f", description="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:cancel"})
    @PermissionDataOpt(businessType="performanceNorm", beanClass=PurchasePerformanceNormHeadService.class)
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.purchasePerformanceNormHeadService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)id)).set(PurchasePerformanceNormHead::getNormStatus, (Object)PerformanceNormStatusEnum.CANCEL.getValue()));
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="performanceNorm")
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:list"})
    public Result<?> queryTabsCount(PurchasePerformanceNormHead purchasePerformanceNormGrad, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"norm_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"norm_status");
        List list = ((PurchasePerformanceNormHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchasePerformanceNormHead::getNormStatus, PurchasePerformanceNormHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "normStatus", null, (long)all.intValue()));
        List srmReviewStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmNormStatus", TenantContext.getTenant());
        for (DictDTO status : srmReviewStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "normStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u7ee9\u6548\u6307\u6807-\u590d\u5236", operateType=2)
    @Operation(summary="\u590d\u5236", description="\u590d\u5236")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"performanceNorm#PurchasePerformanceNormHead:copy"})
    @PermissionDataOpt(businessType="performanceNorm", beanClass=PurchasePerformanceNormHeadService.class)
    public Result<?> copy(@RequestParam String id) {
        PurchasePerformanceNormHead grad = this.purchasePerformanceNormHeadService.copy(id);
        return Result.ok((Object)((Object)grad));
    }
}

