/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.performance.entity.PurchasePerformanceTemplateHead;
import com.els.modules.performance.enumerate.PerformanceCreateTypeEnum;
import com.els.modules.performance.enumerate.PerformanceTemplateEffectiveStatusEnum;
import com.els.modules.performance.rpc.service.InvokeMainRpcService;
import com.els.modules.performance.service.PurchasePerformanceTemplateHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="purchasePerformanceTemplateRpcImportImpl")
public class PurchasePerformanceTemplateImportServiceImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchasePerformanceTemplateHeadService purchasePerformanceTemplateHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeMainRpcService invokeMainRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("performanceTemplate");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERtXIrESIr_e116aff4", (String)"\u8bf7\u5148\u914d\u7f6e\u7ee9\u6548\u6a21\u677f\u4e1a\u52a1\u6a21\u677f"));
        ArrayList<PurchasePerformanceTemplateHead> entityList = new ArrayList<PurchasePerformanceTemplateHead>();
        for (Map data : dataList) {
            PurchasePerformanceTemplateHead head = (PurchasePerformanceTemplateHead)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchasePerformanceTemplateHead.class));
            head.setElsAccount(TenantContext.getTenant());
            head.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            head.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            head.setTemplateVersion(Integer.toString(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion()));
            head.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            head.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
            head.setResultRequiredSend("1".equals(head.getResultRequiredSend()) ? "1" : "0");
            head.setResultRequiredAudit("1".equals(head.getResultRequiredSend()) ? "1" : "0");
            head.setId(null);
            if ("0".equals(head.getTemplateRequiredAudit())) {
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                if (null != head.getEffectiveDate() && head.getEffectiveDate().before((Date)DateUtil.date()) && !PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                    head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.EFFECTIVE.getValue());
                } else {
                    head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
                }
            } else {
                head.setTemplateRequiredAudit("1");
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                if (!PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                    head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
                }
            }
            entityList.add(head);
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        PurchasePerformanceTemplateHead head = (PurchasePerformanceTemplateHead)((Object)entityList.get(0));
        long size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("assessTemplateNumber", (Object)head, (int)size);
        int codeIndex = 0;
        for (PurchasePerformanceTemplateHead e : entityList) {
            e.setPerformanceTemplateNumber((String)nextCodes.get(codeIndex++));
        }
        List<String> orgList = entityList.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getOrgType()) && StrUtil.isNotBlank((CharSequence)x.getOrgCode())).map(x -> x.getOrgType() + "_" + x.getOrgCode()).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(orgList)) {
            List<PurchaseOrganizationInfoDTO> dtoList = this.invokeMainRpcService.listOrganizationInfoByTypeAndCode(orgList);
            Map orgMap = dtoList.stream().collect(Collectors.toMap(x -> x.getOrgCategoryCode() + "_" + x.getOrgCode(), Function.identity(), (v1, v2) -> v1));
            for (PurchasePerformanceTemplateHead head1 : entityList) {
                if (StrUtil.isBlank((CharSequence)head1.getOrgType())) {
                    head1.setOrgCode(null);
                    head1.setOrgName(null);
                }
                if (!StrUtil.isNotBlank((CharSequence)head1.getOrgType()) || !StrUtil.isNotBlank((CharSequence)head1.getOrgCode())) continue;
                PurchaseOrganizationInfoDTO dto = (PurchaseOrganizationInfoDTO)orgMap.get(head1.getOrgType() + "_" + head1.getOrgCode());
                if (null != dto) {
                    head1.setOrgName(dto.getOrgName());
                    continue;
                }
                head1.setOrgCode(null);
                head1.setOrgName(null);
            }
        }
        this.purchasePerformanceTemplateHeadService.saveBatch(entityList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

