/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.performance.dto.PurchasePerformanceReportItemDto;
import com.els.modules.performance.entity.PurchasePerformanceReportGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.entity.PurchasePerformanceReportNormWeight;
import com.els.modules.performance.entity.PurchasePerformanceReportSupplier;
import com.els.modules.performance.service.PurchasePerformanceReportGradService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import com.els.modules.performance.service.PurchasePerformanceReportNormWeightService;
import com.els.modules.performance.service.PurchasePerformanceReportSupplierService;
import com.els.modules.performance.utils.PurchasePerformanceReportJobUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="generatePurchasePerformanceJob")
public class GeneratePurchasePerformanceJob
implements JobRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneratePurchasePerformanceJob.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Autowired
    private PurchasePerformanceReportItemService purchasePerformanceReportItemService;
    @Autowired
    private PurchasePerformanceReportNormWeightService purchasePerformanceReportNormWeightService;
    @Autowired
    private PurchasePerformanceReportSupplierService purchasePerformanceReportSupplierService;
    @Autowired
    private PurchasePerformanceReportGradService purchasePerformanceReportGradService;

    public void execute(String parameter) {
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        String jobKey = paramObj.getString("jobKey");
        String requestId = "generatePurchasePerformanceJob";
        String LOCK_PREFIX = "PurchasePerformanceTemplate_schedule_generatePurchasePerformanceJob";
        try {
            long EXPIRE_TIME = 50000L;
            if (!this.redisUtil.tryGetDistributedLock(LOCK_PREFIX, requestId, EXPIRE_TIME)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LSiKRcWVxPVBRc_38df5694", (String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
            }
            log.info("generatePurchasePerformanceJob start");
            PurchasePerformanceReportHead reportHead = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)id)));
            if (reportHead == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_BjYutyjsBtHW_343b5071", (String)"\u6ca1\u6709\u627e\u5230\u5355\u53f7\u7684\u62a5\u8868\u8bb0\u5f55\uff01"));
            }
            List<PurchasePerformanceReportItem> reportItems = this.purchasePerformanceReportItemService.selectByMainId(id);
            if (!reportItems.isEmpty()) {
                ArrayList reportItemDtos = SysUtil.copyProperties(reportItems, PurchasePerformanceReportItemDto.class);
                List<PurchasePerformanceReportNormWeight> normWeightList = this.purchasePerformanceReportNormWeightService.selectByMainId(id);
                List<PurchasePerformanceReportSupplier> supplierList = this.purchasePerformanceReportSupplierService.selectByMainId(id);
                List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradService.selectByMainId(id);
                this.purchasePerformanceReportHeadService.publishReportNew(reportHead, reportItemDtos, gradList, normWeightList, supplierList);
            }
            log.info("generatePurchasePerformanceJob end");
            PurchasePerformanceReportJobUtil.deleteJob(jobKey);
            TenantContext.clear();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_PREFIX, requestId);
        }
    }
}

