/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.performance.entity.PurchasePerformanceNormFormula;
import com.els.modules.performance.entity.PurchasePerformanceNormGrad;
import com.els.modules.performance.entity.PurchasePerformanceNormHead;
import com.els.modules.performance.enumerate.PerformanceNormStatusEnum;
import com.els.modules.performance.mapper.PurchasePerformanceNormFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormHeadMapper;
import com.els.modules.performance.service.PurchasePerformanceNormFormulaService;
import com.els.modules.performance.service.PurchasePerformanceNormGradService;
import com.els.modules.performance.service.PurchasePerformanceNormHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchasePerformanceNormHeadServiceImpl
extends ServiceImpl<PurchasePerformanceNormHeadMapper, PurchasePerformanceNormHead>
implements PurchasePerformanceNormHeadService {
    @Resource
    private PurchasePerformanceNormGradMapper purchasePerformanceNormGradMapper;
    @Resource
    private PurchasePerformanceNormFormulaMapper purchasePerformanceNormFormulaMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        normHead.setNormStatus(PerformanceNormStatusEnum.VALID.getValue());
        normHead.setUseStatus("0");
        ((PurchasePerformanceNormHeadMapper)this.baseMapper).insert((Object)normHead);
        this.insertData(normHead, normGradList, normFormulaList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        normHead.setNormStatus(PerformanceNormStatusEnum.VALID.getValue());
        normHead.setUseStatus("0");
        PurchasePerformanceNormHead normHeadOld = (PurchasePerformanceNormHead)((Object)((PurchasePerformanceNormHeadMapper)this.baseMapper).selectById((Serializable)((Object)normHead.getId())));
        normHead.setDataVersion(normHeadOld != null ? normHeadOld.getDataVersion() : null);
        int count = ((PurchasePerformanceNormHeadMapper)this.baseMapper).updateById((Object)normHead);
        this.purchasePerformanceNormGradMapper.deleteByMainId(normHead.getId());
        this.purchasePerformanceNormFormulaMapper.deleteByMainId(normHead.getId());
        this.insertData(normHead, normGradList, normFormulaList);
    }

    private void insertData(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        if (CollectionUtil.isNotEmpty(normGradList)) {
            for (PurchasePerformanceNormGrad normGrad : normGradList) {
                normGrad.setId(null);
                normGrad.setHeadId(normHead.getId());
                SysUtil.setSysParam((BaseEntity)normGrad, (BaseEntity)normHead);
            }
            ((PurchasePerformanceNormGradService)SpringContextUtils.getBean(PurchasePerformanceNormGradService.class)).saveBatch(normGradList);
        }
        if (CollectionUtil.isNotEmpty(normFormulaList)) {
            int itemNumber = 1;
            for (PurchasePerformanceNormFormula normFormula : normFormulaList) {
                normFormula.setId(null);
                normFormula.setItemNumber(String.valueOf(itemNumber++));
                normFormula.setHeadId(normHead.getId());
                normFormula.setNormNumber(normHead.getNormNumber());
                SysUtil.setSysParam((BaseEntity)normFormula, (BaseEntity)normHead);
            }
            ((PurchasePerformanceNormFormulaService)SpringContextUtils.getBean(PurchasePerformanceNormFormulaService.class)).saveBatch(normFormulaList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchasePerformanceNormGradMapper.deleteByMainId(id);
        this.purchasePerformanceNormFormulaMapper.deleteByMainId(id);
        ((PurchasePerformanceNormHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePerformanceNormGradMapper.deleteByMainId(serializable.toString());
            this.purchasePerformanceNormFormulaMapper.deleteByMainId(serializable.toString());
            ((PurchasePerformanceNormHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public PurchasePerformanceNormHead copy(String id) {
        PurchasePerformanceNormHead head = (PurchasePerformanceNormHead)((Object)((PurchasePerformanceNormHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        head.setId(IdWorker.getIdStr());
        SysUtil.setNullCreate((BaseEntity)head);
        String normNumber = this.invokeBaseRpcService.getNextCode("srmNormNumber", (Object)head);
        head.setNormNumber(normNumber);
        head.setCreateBy(null);
        head.setCreateById(null);
        head.setCreateTime(null);
        head.setUpdateBy(null);
        head.setUpdateById(null);
        head.setUpdateTime(null);
        List<PurchasePerformanceNormGrad> normGradList = this.purchasePerformanceNormGradMapper.selectByMainId(id);
        for (PurchasePerformanceNormGrad grad : normGradList) {
            SysUtil.setNullCreate((BaseEntity)grad);
            grad.setId(null);
            grad.setHeadId(null);
            grad.setCreateBy(null);
            grad.setCreateById(null);
            grad.setCreateTime(null);
            grad.setUpdateBy(null);
            grad.setUpdateById(null);
            grad.setUpdateTime(null);
        }
        List<PurchasePerformanceNormFormula> normFormulaList = this.purchasePerformanceNormFormulaMapper.selectByMainId(id);
        for (PurchasePerformanceNormFormula grad : normFormulaList) {
            SysUtil.setNullCreate((BaseEntity)grad);
            grad.setId(null);
            grad.setHeadId(null);
            grad.setCreateBy(null);
            grad.setCreateById(null);
            grad.setCreateTime(null);
            grad.setUpdateBy(null);
            grad.setUpdateById(null);
            grad.setUpdateTime(null);
        }
        this.saveMain(head, normGradList, normFormulaList);
        return head;
    }
}

