/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.performance.entity.SaleNewPerformanceReportHead;
import com.els.modules.performance.entity.SaleNewPerformanceReportItem;
import com.els.modules.performance.entity.SaleNewPerformanceReportItemGrad;
import com.els.modules.performance.mapper.SaleNewPerformanceReportHeadMapper;
import com.els.modules.performance.service.SaleNewPerformanceReportHeadService;
import com.els.modules.performance.service.SaleNewPerformanceReportItemGradService;
import com.els.modules.performance.service.SaleNewPerformanceReportItemService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleNewPerformanceReportHeadServiceImpl
extends BaseServiceImpl<SaleNewPerformanceReportHeadMapper, SaleNewPerformanceReportHead>
implements SaleNewPerformanceReportHeadService {
    @Resource
    private SaleNewPerformanceReportItemService saleNewPerformanceReportItemService;
    @Resource
    private SaleNewPerformanceReportItemGradService saleNewPerformanceReportItemGradService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleNewPerformanceReportHead saleNewPerformanceReportHead, List<SaleNewPerformanceReportItem> saleNewPerformanceReportItemList, List<SaleNewPerformanceReportItemGrad> saleNewPerformanceReportItemGradList) {
        ((SaleNewPerformanceReportHeadMapper)this.baseMapper).insert((Object)saleNewPerformanceReportHead);
        super.setHeadDefaultValue((ParentEntity)saleNewPerformanceReportHead);
        this.insertData(saleNewPerformanceReportHead, saleNewPerformanceReportItemList, saleNewPerformanceReportItemGradList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleNewPerformanceReportHead saleNewPerformanceReportHead, List<SaleNewPerformanceReportItem> saleNewPerformanceReportItemList, List<SaleNewPerformanceReportItemGrad> saleNewPerformanceReportItemGradList) {
        int count = ((SaleNewPerformanceReportHeadMapper)this.baseMapper).updateById((Object)saleNewPerformanceReportHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saleNewPerformanceReportItemService.deleteByMainId(saleNewPerformanceReportHead.getId());
        this.saleNewPerformanceReportItemGradService.deleteByMainId(saleNewPerformanceReportHead.getId());
        this.insertData(saleNewPerformanceReportHead, saleNewPerformanceReportItemList, saleNewPerformanceReportItemGradList);
    }

    private void insertData(SaleNewPerformanceReportHead saleNewPerformanceReportHead, List<SaleNewPerformanceReportItem> saleNewPerformanceReportItemList, List<SaleNewPerformanceReportItemGrad> saleNewPerformanceReportItemGradList) {
        if (!CollectionUtils.isEmpty(saleNewPerformanceReportItemList)) {
            for (SaleNewPerformanceReportItem saleNewPerformanceReportItem : saleNewPerformanceReportItemList) {
                saleNewPerformanceReportItem.setHeadId(saleNewPerformanceReportHead.getId());
                SysUtil.setSysParam((BaseEntity)saleNewPerformanceReportItem, (BaseEntity)saleNewPerformanceReportHead);
            }
            this.saleNewPerformanceReportItemService.saveBatch(saleNewPerformanceReportItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(saleNewPerformanceReportItemGradList)) {
            for (SaleNewPerformanceReportItemGrad saleNewPerformanceReportItemGrad : saleNewPerformanceReportItemGradList) {
                saleNewPerformanceReportItemGrad.setHeadId(saleNewPerformanceReportHead.getId());
                SysUtil.setSysParam((BaseEntity)saleNewPerformanceReportItemGrad, (BaseEntity)saleNewPerformanceReportHead);
            }
            this.saleNewPerformanceReportItemGradService.saveBatch(saleNewPerformanceReportItemGradList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.saleNewPerformanceReportItemService.deleteByMainId(id);
        this.saleNewPerformanceReportItemGradService.deleteByMainId(id);
        ((SaleNewPerformanceReportHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleNewPerformanceReportItemService.deleteByMainId(serializable.toString());
            this.saleNewPerformanceReportItemGradService.deleteByMainId(serializable.toString());
            ((SaleNewPerformanceReportHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

