/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.supplier.entity.SupplierAccessHead;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterDataAuditInfo;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SupplierAccessStatusEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.mapper.SupplierAccessHeadMapper;
import com.els.modules.supplier.mapper.SupplierMasterDataAuditInfoMapper;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.mapper.SupplierOrgInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeOrgRpcService;
import com.els.modules.supplier.service.SupplierDevDemandHeadService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="supplierAccessRpcAdapter")
public class SupplierAccessAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Resource
    private SupplierAccessHeadMapper supplierAccessHeadMapper;
    @Resource
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private SupplierOrgInfoMapper supplierOrgInfoMapper;
    @Resource
    private SupplierMasterDataAuditInfoMapper supplierMasterDataAuditInfoMapper;
    @Resource
    private SupplierInvokeOrgRpcService supplierInvokeOrgRpcService;
    @Autowired
    private SupplierDevDemandHeadService supplierDevDemandHeadService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        SupplierAccessHead accessHead;
        SupplierMasterData masterData;
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(AuditStatusEnum.AUDIT_FINISH.getValue()) && (masterData = this.supplierMasterDataMapper.getByAccount((accessHead = (SupplierAccessHead)((Object)this.supplierAccessHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())))).getElsAccount(), accessHead.getToElsAccount())) != null) {
            masterData.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
            masterData.setAccessCategory((StrUtil.isBlank((CharSequence)masterData.getAccessCategory()) ? "" : masterData.getAccessCategory()) + ";" + accessHead.getCateCode() + "_" + accessHead.getCateName());
            this.supplierMasterDataMapper.updateById((Object)masterData);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"relation_id", (Object)masterData.getId());
            wrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_NEW.getValue());
            SupplierMasterDataAuditInfo oldInfo = (SupplierMasterDataAuditInfo)((Object)this.supplierMasterDataAuditInfoMapper.selectOne((Wrapper)wrapper));
            if (oldInfo != null) {
                oldInfo.setAccessCategory(masterData.getAccessCategory());
                this.supplierMasterDataAuditInfoMapper.updateById((Object)oldInfo);
            }
            SupplierOrgInfo info = new SupplierOrgInfo();
            info.setHeadId(masterData.getId());
            info.setElsAccount(masterData.getToElsAccount());
            info.setToElsAccount(masterData.getElsAccount());
            info.setOrgCode(accessHead.getPurchaseOrg());
            PurchaseOrganizationInfoDTO organizationInfo = this.supplierInvokeOrgRpcService.selectByElsAccountAndCode(masterData.getElsAccount(), "purchaseOrganization", accessHead.getPurchaseOrg());
            if (organizationInfo != null) {
                info.setOrgDesc(organizationInfo.getOrgDesc());
                info.setOrgId(organizationInfo.getId());
                info.setOrgCategoryId(organizationInfo.getOrgCategoryCode());
                info.setOrgCategoryDesc(organizationInfo.getOrgCategoryDesc());
                info.setOrgFullDesc(organizationInfo.getOrgDesc());
            }
            info.setFrozenFlag("0");
            info.setPrincipal(accessHead.getPrincipal());
            info.setDataSource(accessHead.getAccessNumber());
            info.setRegulationType(accessHead.getRegulationType());
            info.setDeleted(CommonConstant.DEL_FLAG_0);
            info.setAccessed("1");
            info.setAccessCategory(accessHead.getCateCode() + "_" + accessHead.getCateName());
            this.supplierOrgInfoMapper.insert((Object)info);
        }
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
        SupplierAccessHead accessHead = (SupplierAccessHead)((Object)this.supplierAccessHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        SupplierMasterData masterData = this.supplierMasterDataMapper.getByAccount(accessHead.getElsAccount(), accessHead.getToElsAccount());
        if (masterData != null && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(masterData.getAuditStatus())) {
            masterData.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
            this.supplierMasterDataMapper.updateById((Object)masterData);
        }
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        SupplierAccessHead head = (SupplierAccessHead)((Object)this.supplierAccessHeadMapper.selectById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        SupplierAccessHead accessHead = new SupplierAccessHead();
        accessHead.setId(flowCallbackDTO.getBusinessId());
        accessHead.setAuditStatus(auditStatus);
        accessHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            accessHead.setAccessStatus(SupplierAccessStatusEnum.PUBLISH.getValue());
        }
        this.supplierAccessHeadMapper.updateById((Object)accessHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            SupplierAccessHead supplierAccessHead = (SupplierAccessHead)((Object)this.supplierAccessHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
            supplierAccessHead.setAccessStatus(SupplierAccessStatusEnum.PUBLISH.getValue());
            this.supplierDevDemandHeadService.updDevDemandItemAccess(supplierAccessHead, null);
        }
    }
}

