/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmUtil;
import com.els.modules.supplier.entity.SupplierInfoChangeHead;
import com.els.modules.supplier.entity.SupplierInfoChangeItem;
import com.els.modules.supplier.entity.SupplierInfoChangeRejection;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.enumerate.SupplierInfoChangStatusEnum;
import com.els.modules.supplier.mapper.SupplierInfoChangeHeadMapper;
import com.els.modules.supplier.mapper.SupplierInfoChangeItemMapper;
import com.els.modules.supplier.mapper.SupplierInfoChangeRejectionMapper;
import com.els.modules.supplier.service.SupplierInfoChangeHeadService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="supplierInfoChangRpcAdapter")
public class SupplierInfoChangAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupplierInfoChangAuditOptCallBackServiceImpl.class);
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierInfoChangeHeadService supplierInfoChangeHeadService;
    @Autowired
    private SupplierInfoChangeHeadMapper supplierInfoChangeHeadMapper;
    @Autowired
    private SupplierInfoChangeItemMapper supplierInfoChangeItemMapper;
    @Autowired
    private SupplierInfoChangeRejectionMapper supplierInfoChangeRejectionMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        log.info("come in supplierInfoChangAuditOptCallBackServiceImpl to startCallBack\uff1a" + flowCallbackDTO.getBusinessId());
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        SupplierInfoChangeHead head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        if (head != null && SupplierInfoChangStatusEnum.INVALID.getValue().equals(head.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mtFIkuSTKUz_d471b090", (String)"\u6b64\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u65e0\u9700\u518d\u5ba1\u6279\uff01"));
        }
        SupplierInfoChangeHead changeHead = new SupplierInfoChangeHead();
        changeHead.setId(flowCallbackDTO.getBusinessId());
        changeHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        changeHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        changeHead.setStatus(SupplierInfoChangStatusEnum.EFFECTIVE.getValue());
        if (head != null && !head.getElsAccount().equals(head.getInitiatorElsAccount()) && SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue().equals(head.getStatus())) {
            changeHead.setStatus(SupplierInfoChangStatusEnum.CONFIRM.getValue());
        }
        changeHead.setDataVersion(head.getDataVersion());
        this.supplierInfoChangeHeadMapper.updateById((Object)changeHead);
        List<SupplierInfoChangeItem> changeItemList = this.supplierInfoChangeItemMapper.selectByMainId(changeHead.getId());
        SupplierInfoChangeItem infoChangeItem = changeItemList.get(0);
        String updateAfterData = infoChangeItem.getUpdateAfterData();
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(masterDataVO.getElsAccount(), masterDataVO.getToElsAccount());
        masterDataVO.setDataVersion(masterData != null ? masterData.getDataVersion() : masterDataVO.getDataVersion());
        this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        SupplierInfoChangeHead head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        SupplierMasterDataVO dataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), SupplierMasterDataVO.class));
        SupplierInfoChangeHead head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        if (dataVO != null && StrUtil.isNotBlank((CharSequence)dataVO.getAuditChangeTypeCode())) {
            head.setAuditChangeTypeCode(dataVO.getAuditChangeTypeCode());
        }
        if (head != null && SupplierInfoChangStatusEnum.INVALID.getValue().equals(head.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mtFIkuSTKUz_d471b090", (String)"\u6b64\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u65e0\u9700\u518d\u5ba1\u6279\uff01"));
        }
        SupplierInfoChangeHead changeHead = new SupplierInfoChangeHead();
        changeHead.setId(flowCallbackDTO.getBusinessId());
        changeHead.setNeedAudit("1");
        changeHead.setAuditStatus(auditStatus);
        changeHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (head != null && AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus) && SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue().equals(head.getStatus())) {
            changeHead.setStatus(SupplierInfoChangStatusEnum.BLACKLIST.getValue());
            changeHead.setRejectReason(flowCallbackDTO.getOpinion());
            SupplierInfoChangeRejection rejection = new SupplierInfoChangeRejection();
            rejection.setHeadId(head.getId());
            rejection.setChangeNumber(head.getChangeNumber());
            rejection.setElsAccount(head.getElsAccount());
            rejection.setToElsAccount(head.getToElsAccount());
            rejection.setOpinion(flowCallbackDTO.getOpinion());
            this.supplierInfoChangeRejectionMapper.insert((Object)rejection);
        }
        List<SupplierInfoChangeItem> changeItemList = this.supplierInfoChangeItemMapper.selectByMainId(changeHead.getId());
        SupplierInfoChangeItem infoChangeItem = changeItemList.get(0);
        String updateAfterData = infoChangeItem.getUpdateAfterData();
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
        masterDataVO.setNeedAudit("1");
        masterDataVO.setAuditStatus(auditStatus);
        masterDataVO.setSupplierInfoChangeId(changeHead.getId());
        masterDataVO.setSupplierInfoChangeDataVersion(changeHead.getDataVersion());
        if (dataVO != null && StrUtil.isNotBlank((CharSequence)dataVO.getAuditChangeTypeCode())) {
            masterDataVO.setAuditChangeTypeCode(dataVO.getAuditChangeTypeCode());
        }
        ((SupplierInfoChangeHeadService)SpringContextUtils.getBean(SupplierInfoChangeHeadService.class)).saveMain(masterDataVO);
        head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        changeHead.setDataVersion(head.getDataVersion());
        this.supplierInfoChangeHeadMapper.updateById((Object)changeHead);
    }
}

