/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.ConfigUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.excel.SupplierMasterDataExcelHandler;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SupplierMasterDataCreateOpenServiceImpl
implements OpenApiRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataCreateOpenServiceImpl.class);
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Lazy
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    private static final Pattern CHINA_PHONE = Pattern.compile("^((13[0-9])|(14[0,1,4-9])|(15[0-3,5-9])|(16[2,5,6,7])|(17[0-8])|(18[0-9])|(19[0-3,5-9]))\\d{8}$");

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<SupplierMasterData> headList = new ArrayList<SupplierMasterData>();
        ElsEnterpriseInfoDTO pEnterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(TenantContext.getTenant());
        List<String> supplierNameList = this.supplierMasterDataService.geSupplierNameListByElsAccount(TenantContext.getTenant());
        ArrayList supplierName = new ArrayList();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            SupplierMasterData head = (SupplierMasterData)((Object)ConvertUtils.convertDefault(SupplierMasterData.class, (JSONObject)object, defaultHeadMap));
            if (supplierName.contains(head.getSupplierName())) {
                throw new ELSBootException("\u6dfb\u52a0\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u4f9b\u5e94\u5546\u540d\u79f0");
            }
            if (CollUtil.isNotEmpty(supplierNameList) && supplierNameList.contains(head.getSupplierName())) {
                throw new ELSBootException("\u8be5\u4f9b\u5e94\u5546\u5df2\u7ecf\u5b58\u5728\u4f9b\u5e94\u5546\u4e3b\u6570\u636e");
            }
            if (!StrUtil.isBlank((CharSequence)head.getPersonPhone()) && !CHINA_PHONE.matcher(head.getPersonPhone()).matches()) {
                throw new ELSBootException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
            }
            if (!StrUtil.isBlank((CharSequence)head.getPersonEmail()) && !SupplierMasterDataExcelHandler.checkEmaile(head.getPersonEmail())) {
                throw new ELSBootException("\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef");
            }
            if (StrUtil.isBlank((CharSequence)head.getPersonPassword())) {
                throw new ELSBootException("\u7ba1\u7406\u5458\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String complexityVerifyStr = PasswordUtil.checkPassword((String)ConfigUtil.getPurchaseAccount(), (String)head.getPersonPassword());
            if (StrUtil.isNotBlank((CharSequence)complexityVerifyStr)) {
                throw new ELSBootException("\u590d\u6742\u5ea6\u8f83\u4f4e");
            }
            head.setElsAccount(account);
            if (pEnterpriseInfo != null) {
                head.setPurchaseName(pEnterpriseInfo.getName());
            }
            head.setCreateTime(currentTime);
            head.setUpdateBy(head.getCreateBy());
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            head.setTemplateAccount(templateHead.getElsAccount());
            head.setId(SysUtil.getAssignId((Object)((Object)head)));
            if (CharSequenceUtil.isEmpty((CharSequence)head.getNeedAudit())) {
                head.setNeedAudit("0");
            }
            if (!"1".equals(head.getNeedAudit())) {
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            } else if (CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            head.setElsAccount(TenantContext.getTenant());
            head.setTemplateAccount(TenantContext.getTenant());
            headList.add(head);
        }
        this.supplierMasterDataService.saveImportData(headList);
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", headList);
        return resultObj;
    }

    public void doParamCheck(JSONArray jsonArray, TemplateHeadDTO templateHeadDTO, Map<String, String> map, Map<String, String> map1, List<TemplateConfigHeadDTO> list, List<TemplateConfigItemDTO> list1) {
    }

    public String getBusinessType() {
        return "supplierMasterData";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(SupplierMasterData.class, null, null);
    }

    public List<String> supportItemList() {
        return new ArrayList<String>();
    }
}

