/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.AlertRpcService;
import com.els.common.aspect.annotation.RpcService;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.annotation.Resource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RpcService(value="supplierCertificatedAlertServiceImpl")
public class SupplierCertificatedAlertDubboServiceImpl
implements AlertRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupplierCertificatedAlertDubboServiceImpl.class);
    @Resource
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public List<?> getAlertList(JSONObject config) {
        int alertDays = config.getInteger("alertDays");
        Date currentDate = new Date();
        DateTime checkDate = DateUtil.offsetDay((Date)currentDate, (int)alertDays);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_fail", (Object)"0");
        queryWrapper.lt((Object)"expiry_date", (Object)checkDate);
        List contractHeads = this.purchaseCertificatedInfoService.list((Wrapper)queryWrapper);
        JSONArray jsonArray = new JSONArray();
        if (CollUtil.isNotEmpty((Collection)contractHeads) && contractHeads.size() > 0) {
            String json = SupplierCertificatedAlertDubboServiceImpl.getJson(contractHeads, "yyyy-MM-dd hh:mm:ss");
            jsonArray = JSONArray.parseArray((String)json);
        }
        return jsonArray;
    }

    public List<ElsSubAccountDTO> getPrincipalList(Object obj, JSONObject config) {
        ArrayList<ElsSubAccountDTO> list = new ArrayList<ElsSubAccountDTO>();
        String json = JSON.toJSONString((Object)obj);
        log.info("getPrincipalList:" + json);
        JSON.parseObject((String)json, PurchaseCertificatedInfo.class);
        PurchaseCertificatedInfo certificatedInfo = (PurchaseCertificatedInfo)((Object)JSON.parseObject((String)json, PurchaseCertificatedInfo.class));
        return list;
    }

    private static String getJson(Object object, String format) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        objectMapper.setDateFormat((DateFormat)sdf);
        try {
            String jsonValue = objectMapper.writeValueAsString(object);
            return jsonValue;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

