/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SrmRpcUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.message.api.dto.ElsMsgConfigHeadDTO;
import com.els.modules.message.api.service.MsgConfigRpcService;
import com.els.modules.supplier.api.dto.SupplierContactsInfoDTO;
import com.els.modules.supplier.api.service.SupplierContactsInfoRpcService;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RpcService
public class SupplierContactsInfoDubboServiceImpl
implements SupplierContactsInfoRpcService {
    @Resource
    private SupplierContactsInfoService supplierContactsInfoService;

    public List<SupplierContactsInfoDTO> getDataOnlyAccount(String elsAccount) {
        List<SupplierContactsInfo> contactsInfos = this.supplierContactsInfoService.getDataOnlyAccount(elsAccount);
        if (contactsInfos != null) {
            return SysUtil.copyProperties(contactsInfos, SupplierContactsInfoDTO.class);
        }
        return null;
    }

    public List<SupplierContactsInfoDTO> selectByMainId(String mainId) {
        List<SupplierContactsInfo> infoList = this.supplierContactsInfoService.selectByMainId(mainId);
        return SysUtil.copyProperties(infoList, SupplierContactsInfoDTO.class);
    }

    public void deleteByElsAccount(String elsAccount) {
        this.supplierContactsInfoService.deleteByElsAccount(elsAccount);
    }

    public void insertBatchSomeColumn(List<SupplierContactsInfoDTO> addressInfoDTOs) {
        ArrayList contactsInfos = SysUtil.copyProperties(addressInfoDTOs, SupplierContactsInfo.class);
        this.supplierContactsInfoService.saveBatch(contactsInfos);
    }

    public Map<String, Object> getMsgContacts(String purchaseElsAccount, List<String> toElsAccounts, String businessType, String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List configHeadDTOs = ((MsgConfigRpcService)SrmRpcUtil.getExecuteServiceImpl(MsgConfigRpcService.class)).getByOperation(purchaseElsAccount, businessType, operation);
        for (String elsAccount : toElsAccounts) {
            ArrayList<ElsSubAccountDTO> accountDTOs = new ArrayList<ElsSubAccountDTO>();
            if (configHeadDTOs != null && configHeadDTOs.size() > 0 && StrUtil.isNotBlank((CharSequence)((ElsMsgConfigHeadDTO)configHeadDTOs.get(0)).getJobFunction())) {
                String jobFunction = ((ElsMsgConfigHeadDTO)configHeadDTOs.get(0)).getJobFunction();
                List jobFunctionList = CharSequenceUtil.split((CharSequence)jobFunction, (CharSequence)",");
                List<SupplierContactsInfo> infoList = this.supplierContactsInfoService.getByAccount(elsAccount, purchaseElsAccount);
                if (CollectionUtil.isNotEmpty(infoList)) {
                    for (SupplierContactsInfo contactsInfo : infoList) {
                        if (!jobFunctionList.contains(contactsInfo.getFunctionName())) continue;
                        ElsSubAccountDTO accountDTO = ((AccountRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountRpcService.class)).getAccount(elsAccount, contactsInfo.getSubAccount());
                        accountDTOs.add(accountDTO);
                    }
                    if (accountDTOs.isEmpty()) {
                        accountDTO = ((AccountRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountRpcService.class)).getAccount(elsAccount, "1001");
                        accountDTOs.add(accountDTO);
                    }
                } else {
                    accountDTO = ((AccountRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountRpcService.class)).getAccount(elsAccount, "1001");
                    accountDTOs.add(accountDTO);
                }
            } else {
                ElsSubAccountDTO accountDTO = ((AccountRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountRpcService.class)).getAccount(elsAccount, "1001");
                accountDTOs.add(accountDTO);
            }
            map.put(elsAccount, accountDTOs);
        }
        return map;
    }

    public Map<String, Object> getSupplierContactsAccount(Map<String, List<String>> receiveElsAccountMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String elsAccount : receiveElsAccountMap.keySet()) {
            List accountList;
            List<String> subAccount = receiveElsAccountMap.get(elsAccount);
            if (!CollUtil.isNotEmpty(subAccount) || !CollUtil.isNotEmpty((Collection)(accountList = ((AccountRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountRpcService.class)).getAccountList(elsAccount, subAccount)))) continue;
            map.putIfAbsent(elsAccount, accountList);
        }
        return map;
    }

    public List<String> getUserIdByJobFunction(String jobFunction, String pruchaseAccount, String supllierAccount) {
        List jobFunctionList = CharSequenceUtil.split((CharSequence)jobFunction, (CharSequence)",");
        List<SupplierContactsInfo> infoList = this.supplierContactsInfoService.getByAccount(supllierAccount, pruchaseAccount);
        ArrayList<String> userIdList = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(infoList)) {
            block0: for (SupplierContactsInfo contactsInfo : infoList) {
                String functionName = contactsInfo.getFunctionName();
                if (!StrUtil.isNotBlank((CharSequence)functionName)) continue;
                List<String> strList = Arrays.asList(functionName.split(","));
                for (String str : strList) {
                    if (!jobFunctionList.contains(str)) continue;
                    ElsSubAccountDTO accountDTO = ((AccountRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountRpcService.class)).getAccount(supllierAccount, contactsInfo.getSubAccount());
                    if (accountDTO == null) continue block0;
                    userIdList.add(accountDTO.getId());
                    continue block0;
                }
            }
        }
        return userIdList;
    }
}

