/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.SaleCertificatedInfo;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareview;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareviewItem;
import com.els.modules.supplier.enumerate.CertificatedSourceTypeEnum;
import com.els.modules.supplier.mapper.PurchaseCertificatedInfoMapper;
import com.els.modules.supplier.mapper.PurchaseStandardHeadMapper;
import com.els.modules.supplier.mapper.SaleCertificatedInfoMapper;
import com.els.modules.supplier.mapper.SupplierAccessMgmtQuareviewItemMapper;
import com.els.modules.supplier.mapper.SupplierAccessMgmtQuareviewMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseCertificatedInfoServiceImpl
extends BaseServiceImpl<PurchaseCertificatedInfoMapper, PurchaseCertificatedInfo>
implements PurchaseCertificatedInfoService {
    @Autowired
    private PurchaseCertificatedInfoMapper purchaseCertificatedInfoMapper;
    @Autowired
    private SupplierInvokeEnterpriseRpcService invokeEnterpriseRpcService;
    @Autowired
    private SaleCertificatedInfoMapper saleCertificatedInfoMapper;
    @Autowired
    private PurchaseStandardHeadMapper purchaseStandardHeadMapper;
    @Autowired
    private SupplierAccessMgmtQuareviewItemMapper supplierAccessMgmtQuareviewItemMapper;
    @Autowired
    private SupplierAccessMgmtQuareviewMapper supplierAccessMgmtQuareviewMapper;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InvokeBaseRpcService coreInvokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        purchaseCertificatedInfo.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseCertificatedInfo.setSendStatus("0");
        purchaseCertificatedInfo.setFail("0");
        if (StrUtil.isBlank((CharSequence)purchaseCertificatedInfo.getSourceType())) {
            purchaseCertificatedInfo.setSourceType(CertificatedSourceTypeEnum.SRM.getValue());
        }
        this.checkCertificationDate(purchaseCertificatedInfo);
        purchaseCertificatedInfo.setCreateAccount(TenantContext.getTenant());
        if (StrUtil.isBlank((CharSequence)purchaseCertificatedInfo.getPurchaseName()) && (enterpriseInfo = this.invokeEnterpriseRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            purchaseCertificatedInfo.setPurchaseName(enterpriseInfo.getName());
        }
        if (StrUtil.isBlank((CharSequence)purchaseCertificatedInfo.getSupplierName()) && (enterpriseInfo = this.invokeEnterpriseRpcService.getByElsAccount(purchaseCertificatedInfo.getToElsAccount())) != null) {
            purchaseCertificatedInfo.setSupplierName(enterpriseInfo.getName());
        }
        this.purchaseCertificatedInfoMapper.insert((Object)purchaseCertificatedInfo);
        this.insertData(purchaseCertificatedInfo, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.checkCertificationDate(purchaseCertificatedInfo);
        this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
        this.invokeBaseRpcService.deletePurchaseAttachment(purchaseCertificatedInfo.getId());
        this.insertData(purchaseCertificatedInfo, purchaseAttachmentList);
    }

    private void insertData(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseAttachmentList != null) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setId(null);
                entity.setHeadId(purchaseCertificatedInfo.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseCertificatedInfo);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    private void checkCertificationDate(PurchaseCertificatedInfo entity) {
        long effectiveDate = 0L;
        long expiryDate = 0L;
        long certificationDate = 0L;
        long currentTimeMillis = System.currentTimeMillis();
        if (entity.getEffectiveDate() != null) {
            effectiveDate = entity.getEffectiveDate().getTime();
        }
        if (entity.getExpiryDate() != null) {
            expiryDate = entity.getExpiryDate().getTime();
        }
        if (entity.getCertificationDate() != null) {
            certificationDate = entity.getCertificationDate().getTime();
        }
        if (effectiveDate > 0L && expiryDate == 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBASrWKXBAlSW_45dd225c", (String)"\u751f\u6548\u65e5\u671f\u586b\u4e86\uff0c\u5931\u6548\u65e5\u671f\u5fc5\u586b\uff01"));
        }
        if (effectiveDate == 0L && expiryDate > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBASrWbXBAlSW_5bb2dcf8", (String)"\u5931\u6548\u65e5\u671f\u586b\u4e86\uff0c\u751f\u6548\u65e5\u671f\u5fc5\u586b\uff01"));
        }
        if (effectiveDate > 0L && expiryDate > 0L && (effectiveDate > expiryDate || effectiveDate == expiryDate)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAWlTfUWbXBAW_21db452a", (String)"\u5931\u6548\u65e5\u671f \u5fc5\u987b\u5927\u4e8e \u751f\u6548\u65e5\u671f\uff01"));
        }
        if (certificationDate > 0L && certificationDate > effectiveDate) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LiBAWlTXUSEUWbXBAW_2012a69b", (String)"\u8ba4\u8bc1\u65e5\u671f \u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e \u751f\u6548\u65e5\u671f\uff01"));
        }
        if (currentTimeMillis > expiryDate && expiryDate > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAWlTfUWAPKIW_e61819d5", (String)"\u5931\u6548\u65e5\u671f \u5fc5\u987b\u5927\u4e8e \u5f53\u524d\u65f6\u95f4\uff01"));
        }
        if (currentTimeMillis < effectiveDate) {
            entity.setFail("1");
        }
        if (currentTimeMillis > effectiveDate && expiryDate > currentTimeMillis) {
            entity.setFail("0");
        }
        if (currentTimeMillis > expiryDate) {
            entity.setFail("1");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseCertificatedInfo certificatedInfo = (PurchaseCertificatedInfo)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)certificatedInfo.getShiftToId())) {
            SupplierAccessMgmtQuareview quareview;
            SupplierAccessMgmtQuareviewItem quareviewItem;
            PurchaseStandardHead standardHead = (PurchaseStandardHead)((Object)this.purchaseStandardHeadMapper.selectById((Serializable)((Object)certificatedInfo.getShiftToId())));
            if (standardHead != null) {
                standardHead.setShiftTo("0");
                this.purchaseStandardHeadMapper.updateById((Object)standardHead);
            }
            if ((quareviewItem = (SupplierAccessMgmtQuareviewItem)((Object)this.supplierAccessMgmtQuareviewItemMapper.selectById((Serializable)((Object)certificatedInfo.getShiftToId())))) != null) {
                quareviewItem.setShiftTo("0");
                this.supplierAccessMgmtQuareviewItemMapper.updateById((Object)quareviewItem);
            }
            if ((quareview = (SupplierAccessMgmtQuareview)((Object)this.supplierAccessMgmtQuareviewMapper.selectById((Serializable)((Object)certificatedInfo.getShiftToId())))) != null) {
                SupplierAccessMgmtQuareviewItem quareviewItemStu;
                quareview.setShiftTo("0");
                this.supplierAccessMgmtQuareviewMapper.updateById((Object)quareview);
                if (StrUtil.isNotBlank((CharSequence)quareview.getRelationId()) && (quareviewItemStu = (SupplierAccessMgmtQuareviewItem)((Object)this.supplierAccessMgmtQuareviewItemMapper.selectById((Serializable)((Object)quareview.getRelationId())))) != null) {
                    quareviewItemStu.setShiftTo("0");
                    this.supplierAccessMgmtQuareviewItemMapper.updateById((Object)quareviewItemStu);
                }
            }
        }
        this.invokeBaseRpcService.deletePurchaseAttachment(id);
        this.purchaseCertificatedInfoMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deletePurchaseAttachment(serializable.toString());
            this.purchaseCertificatedInfoMapper.deleteById(serializable);
        }
    }

    @Override
    public Result<?> certificatedInfo(String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        List<PurchaseCertificatedInfo> certificatedInfos = this.purchaseCertificatedInfoMapper.getByAccount(elsAccount, toElsAccount);
        Result result = new Result();
        result.setResult(certificatedInfos);
        result.setSuccess(true);
        return result;
    }

    @Override
    public void send(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.checkCertificationDate(purchaseCertificatedInfo);
        purchaseCertificatedInfo.setSendStatus("1");
        SaleCertificatedInfo certificatedInfo = new SaleCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfo), (Object)((Object)certificatedInfo));
        certificatedInfo.setElsAccount(purchaseCertificatedInfo.getToElsAccount());
        certificatedInfo.setToElsAccount(purchaseCertificatedInfo.getElsAccount());
        certificatedInfo.setRelationId(purchaseCertificatedInfo.getId());
        SaleCertificatedInfo info = (SaleCertificatedInfo)((Object)this.saleCertificatedInfoMapper.selectById((Serializable)((Object)purchaseCertificatedInfo.getId())));
        if (info == null) {
            this.saleCertificatedInfoMapper.insert((Object)certificatedInfo);
            purchaseCertificatedInfo.setRelationId(certificatedInfo.getId());
            this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
            if (CollUtil.isNotEmpty(purchaseAttachmentList)) {
                AttachmentSendDTO sendDTO = new AttachmentSendDTO();
                sendDTO.setHeadId(purchaseCertificatedInfo.getId());
                sendDTO.setElsAccount(purchaseCertificatedInfo.getElsAccount());
                HashMap<String, String> toSend = new HashMap<String, String>();
                toSend.put(certificatedInfo.getId(), certificatedInfo.getElsAccount());
                sendDTO.setToSend(toSend);
                this.invokeBaseRpcService.sendPurchaseFile(sendDTO, true);
            }
        } else {
            certificatedInfo.setId(info.getId());
            this.saleCertificatedInfoMapper.updateById((Object)certificatedInfo);
            this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
        }
    }

    @Override
    public void loseEfficacy(String id) {
        PurchaseCertificatedInfo certificatedInfo = (PurchaseCertificatedInfo)((Object)this.purchaseCertificatedInfoMapper.selectById((Serializable)((Object)id)));
        if (certificatedInfo != null) {
            certificatedInfo.setFail("1");
            this.purchaseCertificatedInfoMapper.updateById((Object)certificatedInfo);
            SaleCertificatedInfo saleCertificatedInfo = (SaleCertificatedInfo)((Object)this.saleCertificatedInfoMapper.selectById((Serializable)((Object)certificatedInfo.getRelationId())));
            saleCertificatedInfo.setFail(certificatedInfo.getFail());
            this.saleCertificatedInfoMapper.updateById((Object)saleCertificatedInfo);
        }
    }

    @Override
    public List<PurchaseCertificatedInfo> getPurchaseCertificatedListByToElsAccount(String elsAccount, String toElsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseCertificatedInfo::getToElsAccount, (Object)toElsAccount);
        List purchaseCertificatedInfos = this.purchaseCertificatedInfoMapper.selectList((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)purchaseCertificatedInfos)) {
            ArrayList<PurchaseCertificatedInfo> list = new ArrayList<PurchaseCertificatedInfo>();
            Optional<PurchaseCertificatedInfo> emptyData = purchaseCertificatedInfos.stream().filter(x -> StrUtil.isBlank((CharSequence)x.getCertificationNo())).sorted(Comparator.comparing(ParentEntity::getId, Comparator.reverseOrder())).findFirst();
            if (emptyData.isPresent()) {
                list.add(emptyData.get());
            }
            List notEmptyInfoList = purchaseCertificatedInfos.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getCertificationNo())).sorted(Comparator.comparing(ParentEntity::getId, Comparator.reverseOrder())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseCertificatedInfo>(Comparator.comparing(PurchaseCertificatedInfo::getCertificationNo))), ArrayList::new));
            list.addAll(notEmptyInfoList);
            return list;
        }
        return purchaseCertificatedInfos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getCertificated(PurchaseCertificatedInfo purchaseCertificatedInfo) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        JSONObject enterpriseResult = this.invokeBaseRpcService.callIPaasInterface(this.getIpaaSData(purchaseCertificatedInfo.getPurchaseName(), "enterpriseInfo"), "valueAddedApplication", this.coreInvokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
        if (!enterpriseResult.getBoolean("success").booleanValue()) throw new ELSBootException(enterpriseResult.getString("message"));
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = (ElsEnterpriseInfoDTO)JSON.parseObject((String)enterpriseResult.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class);
        JSONObject result = this.invokeBaseRpcService.callIPaasInterface(this.getIpaaSData(purchaseCertificatedInfo.getPurchaseName(), "certificated"), "valueAddedApplication", this.coreInvokeBaseRpcService.getIpaasInterfaceCode("certificated"));
        if (!("" + CommonConstant.SC_OK_200).equals(result.getString("code"))) throw new ELSBootException(result.getString("message"));
        JSONObject firstResult = result.getJSONObject("data");
        JSONObject twoResult = firstResult.getJSONObject("result");
        int error_code = firstResult.getInteger("error_code");
        String reason = firstResult.getString("reason");
        if (0 != error_code) throw new ELSBootException(reason);
        int certificatedCount = twoResult.getIntValue("total");
        if (certificatedCount <= 0) return;
        JSONArray certificatedItems = twoResult.getJSONArray("items");
        ArrayList<PurchaseCertificatedInfo> purchaseCertificatedInfoList = new ArrayList<PurchaseCertificatedInfo>();
        for (int i = 0; i < certificatedItems.size(); ++i) {
            JSONObject dataItem = certificatedItems.getJSONObject(i);
            JSONArray detail = dataItem.getJSONArray("detail");
            PurchaseCertificatedInfo certificatedInfo = new PurchaseCertificatedInfo();
            certificatedInfo.setTemplateAccount(purchaseCertificatedInfo.getTemplateAccount());
            certificatedInfo.setTemplateNumber(purchaseCertificatedInfo.getTemplateNumber());
            certificatedInfo.setTemplateVersion(purchaseCertificatedInfo.getTemplateVersion());
            certificatedInfo.setTemplateName(purchaseCertificatedInfo.getTemplateName());
            certificatedInfo.setId(dataItem.getString("id"));
            certificatedInfo.setCreateAccount(loginUser.getElsAccount());
            certificatedInfo.setToElsAccount(elsEnterpriseInfoDTO.getElsAccount());
            certificatedInfo.setSupplierName(elsEnterpriseInfoDTO.getName());
            certificatedInfo.setCertificationName(dataItem.getString("certificateName"));
            certificatedInfo.setCertificationNo(dataItem.getString("certNo"));
            certificatedInfo.setExpiryDate(dataItem.getDate("endDate"));
            certificatedInfo.setEffectiveDate(dataItem.getDate("startDate"));
            certificatedInfo.setDeleted(CommonConstant.DEL_FLAG_0);
            certificatedInfo.setCreateBy(loginUser.getElsAccount());
            certificatedInfo.setCreateTime(new Date());
            certificatedInfo.setUpdateTime(new Date());
            certificatedInfo.setUpdateBy(loginUser.getElsAccount());
            certificatedInfo.setSourceType(CertificatedSourceTypeEnum.THIRD_SYSTEM.getValue());
            if (detail != null && detail.size() > 0) {
                certificatedInfo.setExtendFields(detail.toJSONString());
            }
            purchaseCertificatedInfoList.add(certificatedInfo);
        }
        if (!CollectionUtil.isNotEmpty(purchaseCertificatedInfoList)) return;
        List ids = purchaseCertificatedInfoList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(ids)) {
            this.purchaseCertificatedInfoMapper.deleteByIds(ids);
        }
        this.saveBatch(purchaseCertificatedInfoList);
    }

    private JSONObject getIpaaSData(String companyName, String type) {
        JSONObject data = new JSONObject();
        JSONObject base = new JSONObject();
        JSONObject body = new JSONObject();
        if ("enterpriseInfo".equals(type)) {
            base.put("keyword", (Object)companyName);
            body.put("channel", (Object)"6");
            body.put("auth", (Object)"1");
            body.put("phone", (Object)"");
            body.put("failIsCreateAccount", (Object)"1");
        } else if ("certificated".equals(type)) {
            base.put("name", (Object)companyName);
        }
        data.put("base", (Object)base);
        data.put("body", (Object)body);
        data.put("currentAccount", (Object)TenantContext.getTenant());
        return data;
    }
}

