/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierBankInfoRelation;
import com.els.modules.supplier.mapper.SupplierBankInfoMapper;
import com.els.modules.supplier.mapper.SupplierBankInfoRelationMapper;
import com.els.modules.supplier.service.SupplierBankInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierBankInfoServiceImpl
extends ServiceImpl<SupplierBankInfoMapper, SupplierBankInfo>
implements SupplierBankInfoService {
    @Autowired
    private SupplierBankInfoMapper supplierBankInfoMapper;
    @Autowired
    private SupplierBankInfoRelationMapper supplierBankInfoRelationMapper;

    @Override
    public List<SupplierBankInfo> selectByMainId(String mainId) {
        return this.supplierBankInfoMapper.selectByMainId(mainId);
    }

    @Override
    public List<SupplierBankInfo> getByAccount(String elsAccount, String toElsAccount) {
        if (StrUtil.isBlank((CharSequence)toElsAccount)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
            queryWrapper.eq((Object)"is_deleted", (Object)0);
            return this.supplierBankInfoMapper.selectList((Wrapper)queryWrapper);
        }
        List<SupplierBankInfo> bankInfos = this.supplierBankInfoMapper.getByAccount(elsAccount, toElsAccount);
        List<SupplierBankInfoRelation> bankInfoRelationList = this.supplierBankInfoRelationMapper.getByAccount(elsAccount, toElsAccount);
        ArrayList relationList = SysUtil.copyProperties(bankInfoRelationList, SupplierBankInfo.class);
        if (CollUtil.isNotEmpty((Collection)relationList) && relationList.size() > 0) {
            relationList.forEach(o -> o.setToElsAccount(null));
        }
        bankInfos.addAll(relationList);
        if (CollUtil.isEmpty(bankInfoRelationList) || bankInfoRelationList.size() == 0) {
            bankInfos.addAll(this.supplierBankInfoMapper.getByAccount(elsAccount, null));
        }
        return bankInfos;
    }

    @Override
    public List<SupplierBankInfo> getByAccountAndRecordId(String elsAccount, String toElsAccount, String recordId, List<SupplierBankInfo> oldBankInfoList) {
        if (StrUtil.isBlank((CharSequence)toElsAccount)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
            queryWrapper.eq((Object)"is_deleted", (Object)0);
            return this.supplierBankInfoMapper.selectList((Wrapper)queryWrapper);
        }
        List<SupplierBankInfo> bankInfos = this.supplierBankInfoMapper.getByAccount(elsAccount, toElsAccount);
        if (StrUtil.isNotBlank((CharSequence)recordId)) {
            bankInfos.addAll(oldBankInfoList);
        } else {
            List<SupplierBankInfoRelation> bankInfoRelationList = this.supplierBankInfoRelationMapper.getByAccount(elsAccount, toElsAccount);
            ArrayList relationList = SysUtil.copyProperties(bankInfoRelationList, SupplierBankInfo.class);
            if (CollUtil.isNotEmpty((Collection)relationList) && relationList.size() > 0) {
                relationList.forEach(o -> o.setToElsAccount(null));
            }
            bankInfos.addAll(relationList);
        }
        return bankInfos;
    }

    @Override
    public List<SupplierBankInfo> getDataOnlyAccount(String elsAccount) {
        List<SupplierBankInfo> infoList = this.supplierBankInfoMapper.getByAccount(elsAccount, null);
        if (CollUtil.isNotEmpty(infoList) && infoList.size() > 0) {
            infoList.forEach(o -> {
                if (StrUtil.isNotBlank((CharSequence)o.getTagId())) {
                    o.setId(o.getTagId());
                }
            });
        }
        return infoList;
    }

    @Override
    public void deleteByElsAccount(String elsAccount) {
        this.supplierBankInfoMapper.deleteByElsAccount(elsAccount);
    }

    @Override
    public IPage<SupplierBankInfo> selectListPage(Page<SupplierBankInfo> page, QueryWrapper<SupplierBankInfo> queryWrapper) {
        return this.supplierBankInfoMapper.selectListPage(page, queryWrapper);
    }
}

