/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.context.TokenContext;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierAccessHead;
import com.els.modules.supplier.entity.SupplierAccessMgmt;
import com.els.modules.supplier.entity.SupplierDevDemandHead;
import com.els.modules.supplier.entity.SupplierDevDemandItemAccess;
import com.els.modules.supplier.entity.SupplierDevDemandItemDemand;
import com.els.modules.supplier.enumerate.DevDemandStatusEnum;
import com.els.modules.supplier.mapper.SupplierAccessHeadMapper;
import com.els.modules.supplier.mapper.SupplierAccessMgmtMapper;
import com.els.modules.supplier.mapper.SupplierDevDemandHeadMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierDevDemandHeadService;
import com.els.modules.supplier.service.SupplierDevDemandItemAccessService;
import com.els.modules.supplier.service.SupplierDevDemandItemDemandService;
import com.els.modules.supplier.vo.SupplierDevDemandHeadVO;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierDevDemandHeadServiceImpl
extends BaseServiceImpl<SupplierDevDemandHeadMapper, SupplierDevDemandHead>
implements SupplierDevDemandHeadService {
    @Autowired
    private SupplierDevDemandItemDemandService supplierDevDemandItemDemandService;
    @Autowired
    private SupplierDevDemandItemAccessService supplierDevDemandItemAccessService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService invokeEnterpriseRpcService;
    @Resource
    private SupplierAccessHeadMapper supplierAccessHeadMapper;
    @Resource
    private SupplierAccessMgmtMapper supplierAccessMgmtMapper;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierDevDemandHead demandHead, List<SupplierDevDemandItemDemand> supplierDevDemandItemDemandList, List<SupplierDevDemandItemAccess> supplierDevDemandItemAccessList) {
        if (demandHead.getHopeDevNum() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ATvhWRxOLVW_e33347a5", (String)"\u671f\u671b\u5f00\u53d1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (demandHead.getHopeDevNum() == 0 || demandHead.getHopeDevNum() < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ATvhWRlTfUWW_ed4cb7a", (String)"\u671f\u671b\u5f00\u53d1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01"));
        }
        if (StrUtil.isBlank((CharSequence)demandHead.getStatus())) {
            demandHead.setStatus(DevDemandStatusEnum.NEW.getValue());
        }
        if ("1".equals(demandHead.getNeedAudit())) {
            demandHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            demandHead.setNeedAudit("0");
            demandHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (StrUtil.isBlank((CharSequence)demandHead.getPurchaseName())) {
            ElsEnterpriseInfoDTO infoDTO = this.invokeEnterpriseRpcService.getByElsAccount(demandHead.getElsAccount());
            demandHead.setPurchaseName(infoDTO != null ? infoDTO.getName() : "");
        }
        demandHead.setDemandNo(this.invokeBaseRpcService.getNextCode("supplierdevDemandNo", (Object)demandHead));
        ((SupplierDevDemandHeadMapper)this.baseMapper).insert((Object)demandHead);
        super.setHeadDefaultValue((ParentEntity)demandHead);
        this.insertData(demandHead, supplierDevDemandItemDemandList, supplierDevDemandItemAccessList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierDevDemandHead demandHead, List<SupplierDevDemandItemDemand> supplierDevDemandItemDemandList, List<SupplierDevDemandItemAccess> supplierDevDemandItemAccessList) {
        if (demandHead.getHopeDevNum() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ATvhWRxOLVW_e33347a5", (String)"\u671f\u671b\u5f00\u53d1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (demandHead.getHopeDevNum() == 0 || demandHead.getHopeDevNum() < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ATvhWRlTfUWW_ed4cb7a", (String)"\u671f\u671b\u5f00\u53d1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01"));
        }
        if ("1".equals(demandHead.getNeedAudit())) {
            demandHead.setAuditStatus(StrUtil.isBlank((CharSequence)demandHead.getAuditStatus()) ? AuditStatusEnum.AUDIT_NEW.getValue() : demandHead.getAuditStatus());
        } else {
            demandHead.setNeedAudit("0");
            demandHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (StrUtil.isBlank((CharSequence)demandHead.getPurchaseName())) {
            ElsEnterpriseInfoDTO infoDTO = this.invokeEnterpriseRpcService.getByElsAccount(demandHead.getElsAccount());
            demandHead.setPurchaseName(infoDTO != null ? infoDTO.getName() : "");
        }
        ((SupplierDevDemandHeadMapper)this.baseMapper).updateById((Object)demandHead);
        if (CollUtil.isNotEmpty(supplierDevDemandItemDemandList) && supplierDevDemandItemDemandList.size() > 0) {
            this.supplierDevDemandItemDemandService.deleteByMainId(demandHead.getId());
        }
        if (CollUtil.isNotEmpty(supplierDevDemandItemAccessList) && supplierDevDemandItemAccessList.size() > 0) {
            this.supplierDevDemandItemAccessService.deleteByMainId(demandHead.getId());
        }
        this.insertData(demandHead, supplierDevDemandItemDemandList, supplierDevDemandItemAccessList);
    }

    @Override
    public void copyById(String id) {
        SupplierDevDemandHead devDemandHead = (SupplierDevDemandHead)((Object)this.getById((Serializable)((Object)id)));
        if (devDemandHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        devDemandHead.setId(null);
        devDemandHead.setStatus(DevDemandStatusEnum.NEW.getValue());
        devDemandHead.setDemandNo(this.invokeBaseRpcService.getNextCode("supplierdevDemandNo", (Object)devDemandHead));
        if ("1".equals(devDemandHead.getNeedAudit())) {
            devDemandHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            devDemandHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        devDemandHead.setFlowId(null);
        devDemandHead.setWorkFlowType(null);
        devDemandHead.setElsAccount(TenantContext.getTenant());
        devDemandHead.setCreateBy(null);
        devDemandHead.setCreateById(null);
        devDemandHead.setCreateTime(null);
        devDemandHead.setUpdateBy(null);
        devDemandHead.setUpdateById(null);
        devDemandHead.setUpdateTime(null);
        ((SupplierDevDemandHeadMapper)this.baseMapper).insert((Object)devDemandHead);
    }

    @Override
    public void closeById(String id) {
        SupplierDevDemandHead devDemandHead = (SupplierDevDemandHead)((Object)this.getById((Serializable)((Object)id)));
        if (devDemandHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        devDemandHead.setStatus(DevDemandStatusEnum.CLOSE.getValue());
        ((SupplierDevDemandHeadMapper)this.baseMapper).updateById((Object)devDemandHead);
    }

    @Override
    public void submitSave(SupplierDevDemandHead supplierDevDemandHead, List<SupplierDevDemandItemDemand> supplierDevDemandItemDemandList, List<SupplierDevDemandItemAccess> supplierDevDemandItemAccessList) {
        if (StrUtil.isBlank((CharSequence)supplierDevDemandHead.getId())) {
            this.saveMain(supplierDevDemandHead, supplierDevDemandItemDemandList, supplierDevDemandItemAccessList);
        } else {
            this.updateMain(supplierDevDemandHead, supplierDevDemandItemDemandList, supplierDevDemandItemAccessList);
        }
    }

    @Override
    public void publishMain(SupplierDevDemandHead supplierDevDemandHead) {
        SupplierDevDemandHead demandHead = (SupplierDevDemandHead)((Object)this.getById((Serializable)((Object)supplierDevDemandHead.getId())));
        demandHead.setStatus(DevDemandStatusEnum.DEVELOPING.getValue());
        this.updateById((Object)demandHead);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirm(SupplierDevDemandHead head, List<SupplierDevDemandItemDemand> itemDemandList, List<SupplierDevDemandItemAccess> itemAccessList) {
        if (CollUtil.isNotEmpty(itemAccessList) && itemAccessList.size() > 0) {
            long hopeDevNum;
            QueryWrapper queryWrapper;
            LinkedHashMap mapList = itemAccessList.stream().collect(Collectors.groupingBy(SupplierDevDemandItemAccess::getSourceType, LinkedHashMap::new, Collectors.toList()));
            List accessMgmt = (List)mapList.get("accessMgmt");
            List access = (List)mapList.get("access");
            ArrayList accessList = new ArrayList();
            if (CollUtil.isNotEmpty((Collection)accessMgmt)) {
                List accessMgmtStr = accessMgmt.stream().map(SupplierDevDemandItemAccess::getAccessNumber).distinct().collect(Collectors.toList());
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
                queryWrapper.in((Object)"access_number", accessMgmtStr);
                List list = this.supplierAccessMgmtMapper.selectList((Wrapper)queryWrapper);
                if (CollUtil.isNotEmpty((Collection)list)) {
                    ArrayList arrayList = SysUtil.copyProperties((List)list, SupplierDevDemandItemAccess.class);
                    arrayList.forEach(x -> {
                        x.setSourceType("accessMgmt");
                        x.setRelationId(x.getId());
                    });
                    accessList.addAll(arrayList);
                }
            }
            if (CollUtil.isNotEmpty((Collection)access)) {
                List accessStr = access.stream().map(SupplierDevDemandItemAccess::getAccessNumber).distinct().collect(Collectors.toList());
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
                queryWrapper.in((Object)"access_number", accessStr);
                Page page = new Page(1L, 10000000L);
                Iterator pageList = this.supplierAccessHeadMapper.selectCustomPage((Page<SupplierAccessHead>)page, (QueryWrapper<SupplierAccessHead>)queryWrapper);
                List list = pageList.getRecords();
                if (CollUtil.isNotEmpty((Collection)list)) {
                    ArrayList arrayList = SysUtil.copyProperties((List)list, SupplierDevDemandItemAccess.class);
                    arrayList.forEach(x -> {
                        x.setSourceType("access");
                        x.setRelationId(x.getId());
                    });
                    accessList.addAll(arrayList);
                }
            }
            for (SupplierDevDemandItemAccess item : itemAccessList) {
                item.setId(null);
                item.setHeadId(head.getId());
                for (SupplierDevDemandItemAccess sub : accessList) {
                    if (!item.getAccessNumber().equals(sub.getAccessNumber())) continue;
                    item.setAccessStatus(sub.getAccessStatus());
                    item.setRelationId(sub.getRelationId());
                    if (item.getAccessType().equals(sub.getAccessType())) continue;
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JOKmWrNtyWWWWWWWWrNAcuWVaRdXW_fcab678d", (String)"\u6821\u9a8c\u5931\u8d25\uff0c\u51c6\u5165\u5355\u53f7\uff1a[${0}]\uff0c\u51c6\u5165\u7c7b\u578b\u975e\u201c\u65b0\u589e\u4f9b\u5e94\u5546\u201d"), new String[]{item.getAccessNumber()});
                }
            }
            long count = itemAccessList.stream().filter(o -> "1".equals(o.getAccessStatus())).count();
            long l = hopeDevNum = head.getHopeDevNum() == null ? 0L : head.getHopeDevNum().longValue();
            if (count >= hopeDevNum) {
                head.setStatus(DevDemandStatusEnum.ALL_DONE.getValue());
            } else if (count == 0L) {
                head.setStatus(DevDemandStatusEnum.DEVELOPING.getValue());
            } else {
                head.setStatus(DevDemandStatusEnum.PARTIALLY.getValue());
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RKrNtEPcWFxOLVW_4e34aa45", (String)"\u5173\u8054\u51c6\u5165\u5355\u9875\u7b7e\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        this.updateById((Object)head);
        this.supplierDevDemandItemAccessService.deleteByMainId(head.getId());
        this.supplierDevDemandItemAccessService.saveBatch(itemAccessList, 2000);
    }

    @Override
    public void updDevDemandItemAccess(SupplierAccessHead accessHead, SupplierAccessMgmt accessMgmt) {
        String token = TokenContext.getToken();
        String tenant = TenantContext.getTenant();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        String accessNumber = "";
        if (accessHead != null) {
            accessNumber = accessHead.getAccessNumber();
        }
        if (accessMgmt != null) {
            accessNumber = accessMgmt.getAccessNumber();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"access_number", (Object)accessNumber);
        List list = this.supplierDevDemandItemAccessService.list((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)list) && list.size() > 0) {
            List headIdList = list.stream().map(SupplierDevDemandItemAccess::getHeadId).distinct().collect(Collectors.toList());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            wrapper.in((Object)"id", headIdList);
            wrapper.in((Object)"status", DevDemandStatusEnum.getLoping());
            List headList = this.list((Wrapper)wrapper);
            for (SupplierDevDemandHead head : headList) {
                List<SupplierDevDemandItemAccess> itemAccessList = this.supplierDevDemandItemAccessService.selectByMainId(head.getId());
                String finalAccessNumber = accessNumber;
                this.srmPoolExecutor.execute(() -> {
                    try {
                        if (null != token) {
                            TokenContext.setToken((String)token);
                        }
                        LoginUserContext.setUser((LoginUserDTO)loginUser);
                        TenantContext.setTenant((String)tenant);
                        this.checkDevDemandItemAccess(head, itemAccessList, finalAccessNumber);
                    }
                    finally {
                        LoginUserContext.clear();
                        TenantContext.clear();
                        TokenContext.clear();
                    }
                });
            }
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void checkDevDemandItemAccess(SupplierDevDemandHead head, List<SupplierDevDemandItemAccess> itemAccessList, String accessNumber) {
        if (CollUtil.isNotEmpty(itemAccessList) && itemAccessList.size() > 0) {
            long hopeDevNum;
            QueryWrapper queryWrapper;
            LinkedHashMap mapList = itemAccessList.stream().collect(Collectors.groupingBy(SupplierDevDemandItemAccess::getSourceType, LinkedHashMap::new, Collectors.toList()));
            List accessMgmt = (List)mapList.get("accessMgmt");
            List access = (List)mapList.get("access");
            ArrayList accessList = new ArrayList();
            if (CollUtil.isNotEmpty((Collection)accessMgmt)) {
                List accessMgmtStr = accessMgmt.stream().map(SupplierDevDemandItemAccess::getAccessNumber).distinct().collect(Collectors.toList());
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
                queryWrapper.in((Object)"access_number", accessMgmtStr);
                List list = this.supplierAccessMgmtMapper.selectList((Wrapper)queryWrapper);
                if (CollUtil.isNotEmpty((Collection)list)) {
                    ArrayList arrayList = SysUtil.copyProperties((List)list, SupplierDevDemandItemAccess.class);
                    arrayList.forEach(x -> {
                        x.setSourceType("accessMgmt");
                        x.setRelationId(x.getId());
                    });
                    accessList.addAll(arrayList);
                }
            }
            if (CollUtil.isNotEmpty((Collection)access)) {
                List accessStr = access.stream().map(SupplierDevDemandItemAccess::getAccessNumber).distinct().collect(Collectors.toList());
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
                queryWrapper.in((Object)"access_number", accessStr);
                Page page = new Page(1L, 10000000L);
                Iterator pageList = this.supplierAccessHeadMapper.selectCustomPage((Page<SupplierAccessHead>)page, (QueryWrapper<SupplierAccessHead>)queryWrapper);
                List list = pageList.getRecords();
                if (CollUtil.isNotEmpty((Collection)list)) {
                    ArrayList arrayList = SysUtil.copyProperties((List)list, SupplierDevDemandItemAccess.class);
                    arrayList.forEach(x -> {
                        x.setSourceType("access");
                        x.setRelationId(x.getId());
                    });
                    accessList.addAll(arrayList);
                }
            }
            for (SupplierDevDemandItemAccess item : itemAccessList) {
                item.setId(null);
                item.setHeadId(head.getId());
                for (SupplierDevDemandItemAccess sub : accessList) {
                    if (item.getAccessNumber().equals(sub.getAccessNumber())) {
                        item.setAccessStatus(sub.getAccessStatus());
                        item.setRelationId(sub.getRelationId());
                    }
                    if (!item.getAccessNumber().equals(accessNumber)) continue;
                    item.setAccessStatus("1");
                }
            }
            long count = itemAccessList.stream().filter(o -> "1".equals(o.getAccessStatus())).count();
            long l = hopeDevNum = head.getHopeDevNum() == null ? 0L : head.getHopeDevNum().longValue();
            if (count >= hopeDevNum) {
                head.setStatus(DevDemandStatusEnum.ALL_DONE.getValue());
            } else if (count == 0L) {
                head.setStatus(DevDemandStatusEnum.DEVELOPING.getValue());
            } else {
                head.setStatus(DevDemandStatusEnum.PARTIALLY.getValue());
            }
            this.updateById((Object)head);
            this.supplierDevDemandItemAccessService.deleteByMainId(head.getId());
            this.supplierDevDemandItemAccessService.saveBatch(itemAccessList, 2000);
        }
    }

    @Override
    public SupplierDevDemandHeadVO queryById(String id) {
        SupplierDevDemandHead supplierDevDemandHead = (SupplierDevDemandHead)((Object)this.getById((Serializable)((Object)id)));
        SupplierDevDemandHeadVO supplierDevDemandHeadVO = new SupplierDevDemandHeadVO();
        BeanUtils.copyProperties((Object)((Object)supplierDevDemandHead), (Object)((Object)supplierDevDemandHeadVO));
        List<SupplierDevDemandItemDemand> supplierDevDemandItemDemandList = this.supplierDevDemandItemDemandService.selectByMainId(id);
        supplierDevDemandHeadVO.setSupplierDevDemandItemDemandList(supplierDevDemandItemDemandList);
        List<SupplierDevDemandItemAccess> supplierDevDemandItemAccessList = this.supplierDevDemandItemAccessService.selectByMainId(id);
        supplierDevDemandHeadVO.setSupplierDevDemandItemAccessList(supplierDevDemandItemAccessList);
        List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(id);
        supplierDevDemandHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return supplierDevDemandHeadVO;
    }

    private void insertData(SupplierDevDemandHead supplierDevDemandHead, List<SupplierDevDemandItemDemand> supplierDevDemandItemDemandList, List<SupplierDevDemandItemAccess> supplierDevDemandItemAccessList) {
        if (!CollectionUtils.isEmpty(supplierDevDemandItemDemandList)) {
            for (SupplierDevDemandItemDemand supplierDevDemandItemDemand : supplierDevDemandItemDemandList) {
                supplierDevDemandItemDemand.setHeadId(supplierDevDemandHead.getId());
                SysUtil.setSysParam((BaseEntity)supplierDevDemandItemDemand, (BaseEntity)supplierDevDemandHead);
            }
            this.supplierDevDemandItemDemandService.saveBatch(supplierDevDemandItemDemandList, 2000);
        }
        if (!CollectionUtils.isEmpty(supplierDevDemandItemAccessList)) {
            for (SupplierDevDemandItemAccess supplierDevDemandItemAccess : supplierDevDemandItemAccessList) {
                supplierDevDemandItemAccess.setHeadId(supplierDevDemandHead.getId());
                SysUtil.setSysParam((BaseEntity)supplierDevDemandItemAccess, (BaseEntity)supplierDevDemandHead);
            }
            this.supplierDevDemandItemAccessService.saveBatch(supplierDevDemandItemAccessList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.supplierDevDemandItemDemandService.deleteByMainId(id);
        this.supplierDevDemandItemAccessService.deleteByMainId(id);
        ((SupplierDevDemandHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierDevDemandItemDemandService.deleteByMainId(serializable.toString());
            this.supplierDevDemandItemAccessService.deleteByMainId(serializable.toString());
            ((SupplierDevDemandHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

