/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.mapper.SupplierOrgInfoMapper;
import com.els.modules.supplier.service.SupplierOrgInfoService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierOrgInfoServiceImpl
extends ServiceImpl<SupplierOrgInfoMapper, SupplierOrgInfo>
implements SupplierOrgInfoService {
    @Autowired
    private SupplierOrgInfoMapper supplierOrgInfoMapper;

    @Override
    public List<SupplierOrgInfo> selectByMainId(String mainId) {
        return this.supplierOrgInfoMapper.selectByMainId(mainId);
    }

    @Override
    public List<SupplierOrgInfo> getByAccount(String elsAccount, String toElsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        if (!StrUtil.isBlank((CharSequence)toElsAccount)) {
            queryWrapper.eq((Object)"to_els_account", (Object)toElsAccount);
        }
        return this.supplierOrgInfoMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getMasterDateIdListFromOrgInfo(String elsAccount, String purchaseOrganization, List<String> accessCategoryList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        accessCategoryList.forEach(item -> queryWrapper.or(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SupplierOrgInfo::getToElsAccount, (Object)elsAccount)).eq(SupplierOrgInfo::getOrgCode, (Object)purchaseOrganization)).likeRight(SupplierOrgInfo::getAccessCategory, (Object)(item + "\\_"))));
        List supplierOrgInfos = this.supplierOrgInfoMapper.selectList((Wrapper)queryWrapper);
        return supplierOrgInfos.stream().map(SupplierOrgInfo::getHeadId).distinct().collect(Collectors.toList());
    }
}

