/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.supplier.entity.SupplierStandardRegulation;
import com.els.modules.supplier.entity.SupplierStandardRegulationSelection;
import com.els.modules.supplier.enumerate.QuestionTypesEnum;
import com.els.modules.supplier.mapper.SupplierStandardRegulationMapper;
import com.els.modules.supplier.mapper.SupplierStandardRegulationSelectionMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.SupplierStandardRegulationSelectionService;
import com.els.modules.supplier.service.SupplierStandardRegulationService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierStandardRegulationServiceImpl
extends ServiceImpl<SupplierStandardRegulationMapper, SupplierStandardRegulation>
implements SupplierStandardRegulationService {
    @Autowired
    private SupplierStandardRegulationMapper supplierStandardRegulationMapper;
    @Autowired
    private SupplierStandardRegulationSelectionMapper supplierStandardRegulationSelectionMapper;
    @Autowired
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierStandardRegulation supplierStandardRegulation, List<SupplierStandardRegulationSelection> supplierStandardRegulationSelectionList, List<PurchaseAttachmentDTO> attachments) {
        supplierStandardRegulation.setRegulationNumber(this.supplierInvokeBaseRpcService.getNextCode("standardRagulation", (Object)supplierStandardRegulation));
        if (supplierStandardRegulationSelectionList != null && supplierStandardRegulationSelectionList.size() > 0 && StrUtil.isNotBlank((CharSequence)supplierStandardRegulation.getInputType()) && !supplierStandardRegulation.getInputType().equals(QuestionTypesEnum.SHORT_ANSWER.getValue())) {
            BigDecimal fullMark = BigDecimal.ZERO;
            if (QuestionTypesEnum.CHOOSE_ONE.getValue().equals(supplierStandardRegulation.getInputType())) {
                for (SupplierStandardRegulationSelection selection : supplierStandardRegulationSelectionList) {
                    if (selection.getScore() == null || fullMark.compareTo(selection.getScore()) >= 0) continue;
                    fullMark = selection.getScore();
                }
            }
            if (QuestionTypesEnum.CHOOSE_MORE.getValue().equals(supplierStandardRegulation.getInputType())) {
                for (SupplierStandardRegulationSelection selection : supplierStandardRegulationSelectionList) {
                    if (selection.getScore() == null) continue;
                    fullMark = selection.getScore().add(fullMark);
                }
            }
            supplierStandardRegulation.setFullMark(fullMark);
        }
        if (supplierStandardRegulation.getFullMark() != null && BigDecimal.ZERO.compareTo(supplierStandardRegulation.getFullMark()) >= 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CzRTfUW_14be5685", (String)"\u6ee1\u5206\u503c\u987b\u5927\u4e8e0"));
        }
        this.supplierStandardRegulationMapper.insert((Object)supplierStandardRegulation);
        this.supplierInvokeBaseRpcService.deletePurchaseAttachment(supplierStandardRegulation.getId());
        this.insertData(supplierStandardRegulation, supplierStandardRegulationSelectionList, attachments);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierStandardRegulation supplierStandardRegulation, List<SupplierStandardRegulationSelection> supplierStandardRegulationSelectionList, List<PurchaseAttachmentDTO> attachments) {
        if (supplierStandardRegulationSelectionList != null && supplierStandardRegulationSelectionList.size() > 0 && StrUtil.isNotBlank((CharSequence)supplierStandardRegulation.getInputType()) && !supplierStandardRegulation.getInputType().equals(QuestionTypesEnum.SHORT_ANSWER.getValue())) {
            BigDecimal fullMark = BigDecimal.ZERO;
            if (QuestionTypesEnum.CHOOSE_ONE.getValue().equals(supplierStandardRegulation.getInputType())) {
                for (SupplierStandardRegulationSelection selection : supplierStandardRegulationSelectionList) {
                    if (selection.getScore() == null || fullMark.compareTo(selection.getScore()) >= 0) continue;
                    fullMark = selection.getScore();
                }
            }
            if (QuestionTypesEnum.CHOOSE_MORE.getValue().equals(supplierStandardRegulation.getInputType())) {
                for (SupplierStandardRegulationSelection selection : supplierStandardRegulationSelectionList) {
                    if (selection.getScore() == null) continue;
                    fullMark = selection.getScore().add(fullMark);
                }
            }
            supplierStandardRegulation.setFullMark(fullMark);
        }
        if (supplierStandardRegulation.getFullMark() != null && BigDecimal.ZERO.compareTo(supplierStandardRegulation.getFullMark()) >= 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CzRTfUW_14be5685", (String)"\u6ee1\u5206\u503c\u987b\u5927\u4e8e0"));
        }
        this.supplierStandardRegulationMapper.updateById((Object)supplierStandardRegulation);
        this.supplierStandardRegulationSelectionMapper.deleteByMainId(supplierStandardRegulation.getId());
        this.supplierInvokeBaseRpcService.deletePurchaseAttachment(supplierStandardRegulation.getId());
        this.insertData(supplierStandardRegulation, supplierStandardRegulationSelectionList, attachments);
    }

    private void insertData(SupplierStandardRegulation supplierStandardRegulation, List<SupplierStandardRegulationSelection> supplierStandardRegulationSelectionList, List<PurchaseAttachmentDTO> attachments) {
        if (supplierStandardRegulationSelectionList != null) {
            for (SupplierStandardRegulationSelection entity : supplierStandardRegulationSelectionList) {
                entity.setHeadId(supplierStandardRegulation.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)supplierStandardRegulation);
            }
            if (!supplierStandardRegulationSelectionList.isEmpty()) {
                ((SupplierStandardRegulationSelectionService)SpringContextUtils.getBean(SupplierStandardRegulationSelectionService.class)).saveBatch(supplierStandardRegulationSelectionList);
            }
        }
        if (attachments != null && CollectionUtil.isNotEmpty(attachments)) {
            for (PurchaseAttachmentDTO attachment : attachments) {
                attachment.setHeadId(supplierStandardRegulation.getId());
                attachment.setUploadElsAccount(supplierStandardRegulation.getElsAccount());
                attachment.setBusinessType("purchase_standard_regulation");
                attachment.setSourceNumber(supplierStandardRegulation.getRegulationNumber());
                attachment.setSendStatus("0");
                attachment.setActionRoutePath("/srm/supplier/SupplierStandardRegurationList");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)supplierStandardRegulation);
                attachment.setId(null);
            }
            this.supplierInvokeBaseRpcService.insertPurchaseBatchSomeColumn(attachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.supplierStandardRegulationSelectionMapper.deleteByMainId(id);
        this.supplierStandardRegulationMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierStandardRegulationSelectionMapper.deleteByMainId(serializable.toString());
            this.supplierStandardRegulationMapper.deleteById(serializable);
        }
    }
}

