/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.supplier.vo.RelationShipVO;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadJsonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadJsonUtils.class);
    static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    public static void main(String[] args) {
        String url = "https://file.open.tianyancha.com/hidden/json/d05456b1-af35-3df5-a0a5-8cdd063eb9c7.json";
        String json = LoadJsonUtils.loadJsonHttps(url);
        System.out.println("json = " + json);
        JSONObject jsonObject = JSON.parseObject((String)json);
        List<Object> resultList = new ArrayList();
        for (Map.Entry entry : jsonObject.entrySet()) {
            Object o;
            List<RelationShipVO> relationShipVOList;
            if (!((String)entry.getKey()).contains("p_") || ((String)entry.getKey()).equals("p_0") || (relationShipVOList = LoadJsonUtils.parseJson(o = entry.getValue())) == null || relationShipVOList.size() <= 0) continue;
            resultList.addAll(relationShipVOList);
        }
        resultList = resultList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<RelationShipVO>(Comparator.comparing(item -> item.getStartNodeName() + ":" + item.getEndNodeName() + ":" + item.getType() + ":" + item.getProperties()))), ArrayList::new));
        Comparator<RelationShipVO> receiptsVoComparator = Comparator.comparing(RelationShipVO::getType).thenComparing(RelationShipVO::getStartNodeName).thenComparing(RelationShipVO::getEndNodeName);
        resultList = resultList.stream().sorted(receiptsVoComparator).collect(Collectors.toList());
        System.out.println("relationShipVOList = " + JSONObject.toJSONString(resultList));
    }

    public static List<RelationShipVO> parseJson(Object object) {
        JSONObject nodeObject = (JSONObject)object;
        ArrayList<RelationShipVO> relationShipVOList = new ArrayList<RelationShipVO>();
        if (nodeObject.get((Object)"relationships") != null && nodeObject.get((Object)"nodes") != null) {
            JSONArray relationships = (JSONArray)nodeObject.get((Object)"relationships");
            for (int i = 0; i < relationships.size(); ++i) {
                List<String> typeList;
                JSONObject relationshipObject = (JSONObject)relationships.get(i);
                if (relationshipObject == null || !StrUtil.isNotBlank((CharSequence)relationshipObject.getString("type")) || !(typeList = Arrays.asList("OWN", "SERVE_ALL", "INVEST", "BRANCH")).contains(relationshipObject.getString("type"))) continue;
                RelationShipVO relationShipVO = new RelationShipVO();
                relationShipVO.setId(relationshipObject.getString("id"));
                relationShipVO.setStartNodeId(relationshipObject.getString("startNode"));
                relationShipVO.setEndNodeId(relationshipObject.getString("endNode"));
                relationShipVO.setType(relationshipObject.getString("type"));
                String labels = LoadJsonUtils.processProperties(relationshipObject);
                relationShipVO.setProperties(labels);
                relationShipVOList.add(relationShipVO);
            }
            for (RelationShipVO relationShipVO : relationShipVOList) {
                JSONArray nodes = (JSONArray)nodeObject.get((Object)"nodes");
                for (int i = 0; i < nodes.size(); ++i) {
                    JSONObject node = (JSONObject)nodes.get(i);
                    String id = node.getString("id");
                    JSONObject properties = (JSONObject)node.get((Object)"properties");
                    String names = properties.getString("name");
                    String labels = LoadJsonUtils.processLabels(node);
                    if (id.equals(relationShipVO.getStartNodeId())) {
                        relationShipVO.setStartNodeName(names);
                        relationShipVO.setStartNodeLabels(labels);
                    }
                    if (!id.equals(relationShipVO.getEndNodeId())) continue;
                    relationShipVO.setEndNodeName(names);
                    relationShipVO.setEndNodeLabels(labels);
                }
            }
        }
        return relationShipVOList;
    }

    private static String processLabels(JSONObject node) {
        JSONArray labelArray = (JSONArray)node.get((Object)"labels");
        Object[] strings = new String[labelArray.size()];
        String[] strings1 = (String[])labelArray.toArray(strings);
        return Arrays.stream(strings1).collect(Collectors.joining(","));
    }

    private static String processProperties(JSONObject relationshipObject) {
        JSONObject propertiesObject = (JSONObject)relationshipObject.get((Object)"properties");
        JSONArray labelArray = (JSONArray)propertiesObject.get((Object)"labels");
        Object[] strings = new String[labelArray.size()];
        String[] strings1 = (String[])labelArray.toArray(strings);
        return Arrays.stream(strings1).collect(Collectors.joining(","));
    }

    public static String loadJsonHttp(String url) {
        StringBuilder json = new StringBuilder();
        try {
            URL urlObject = new URL(url);
            URLConnection uc = urlObject.openConnection();
            uc.setRequestProperty("User-Agent", "Mozilla/4.76");
            BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream(), "utf-8"));
            String inputLine = null;
            while ((inputLine = in.readLine()) != null) {
                json.append(inputLine);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    public static String loadJsonHttps(String url) {
        StringBuilder json = new StringBuilder();
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new LoadJsonUtils().new NullHostNameVerifier());
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            URL urlObject = new URL(url);
            HttpURLConnection uc = (HttpURLConnection)urlObject.openConnection();
            uc.setRequestProperty("User-Agent", "Mozilla/4.76");
            BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream(), "utf-8"));
            String inputLine = null;
            while ((inputLine = in.readLine()) != null) {
                json.append(inputLine);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    public class NullHostNameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

