/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.vmi.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.vmi.entity.VmiInventory;
import com.els.modules.vmi.service.VmiInventoryService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="VMI\u5e93\u5b58")
@RestController
@RequestMapping(value={"/vmi/vmiInventory"})
public class VmiInventoryController
extends BaseController<VmiInventory, VmiInventoryService> {
    @Autowired
    private VmiInventoryService vmiInventoryService;

    @AutoLog(value="VMI\u5e93\u5b58-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"vmiInventory#vmiInventory:list"})
    @PermissionDataView(businessType="vmiBoard")
    public Result<?> queryPageList(VmiInventory vmiInventory, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)vmiInventory), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.vmiInventoryService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="VMI\u5e93\u5b58-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"vmiInventory#vmiInventory:delete"})
    @PermissionDataOpt(businessType="vmiBoard", beanClass=VmiInventoryService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.vmiInventoryService.delVmiInventory(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="VMI\u5e93\u5b58-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @RequiresPermissions(value={"vmiInventory#vmiInventory:delete"})
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.vmiInventoryService.delBatchVmiInventory(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u83b7\u53d6ERP\u6570\u636e", description="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"vmiInventory#vmiInventory:getDataByErp"})
    public Result<?> getDataByErp() {
        this.vmiInventoryService.getDataByErp();
        return Result.ok();
    }

    @Operation(summary="SRM\u63a8\u9001\u5230ERP", description="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"vmiInventory#vmiInventory:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.vmiInventoryService.pushDataToErp(ids);
        return Result.ok();
    }
}

