/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.supplier.entity.SupplierDevDemandHead;
import com.els.modules.supplier.enumerate.DevDemandStatusEnum;
import com.els.modules.supplier.service.SupplierDevDemandHeadService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="supplierDevDemandRpcAdapter")
public class SupplierDevDemandAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupplierDevDemandAuditOptCallBackServiceImpl.class);
    @Autowired
    private SupplierDevDemandHeadService supplierDevDemandHeadService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        SupplierDevDemandHead devDemandHead = new SupplierDevDemandHead();
        devDemandHead.setId(flowCallbackDTO.getBusinessId());
        devDemandHead.setStatus(DevDemandStatusEnum.DEVELOPING.getValue());
        devDemandHead.setNeedAudit("1");
        devDemandHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        devDemandHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.supplierDevDemandHeadService.updateById((Object)devDemandHead);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        SupplierDevDemandHead devDemandHead = new SupplierDevDemandHead();
        devDemandHead.setId(flowCallbackDTO.getBusinessId());
        devDemandHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.supplierDevDemandHeadService.updateById((Object)devDemandHead);
    }

    public Map<String, Object> getById(String id) {
        SupplierDevDemandHead head = (SupplierDevDemandHead)((Object)this.supplierDevDemandHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        SupplierDevDemandHead devDemandHead = new SupplierDevDemandHead();
        devDemandHead.setId(flowCallbackDTO.getBusinessId());
        devDemandHead.setNeedAudit("1");
        devDemandHead.setAuditStatus(auditStatus);
        devDemandHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.supplierDevDemandHeadService.updateById((Object)devDemandHead);
    }
}

