/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.util.DateUtils;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterFrozen;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.service.SupplierInfoChangeHeadService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.service.SupplierMasterFrozenService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;

@RpcService(value="supplierMasterDataTermJobServiceImpl")
public class SupplierMasterDataTermJobDubboServiceImpl
implements JobRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataTermJobDubboServiceImpl.class);
    private final String LOCK_PREFIX = "supplierMasterData_schedule_supplierMasterDataTermJob";
    private final long EXPIRE_TIME = 50000L;
    @Lazy
    @Resource
    private SupplierMasterDataService supplierMasterDataService;
    @Lazy
    @Resource
    private SupplierMasterFrozenService supplierMasterFrozenService;
    @Lazy
    @Resource
    private SupplierInfoChangeHeadService supplierInfoChangeHeadService;
    @Lazy
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;
    @Resource
    private RedisUtil redisUtil;

    @Transactional
    public void execute(String parameter) {
        String elsAccount = "";
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        if (StrUtil.isNotBlank((CharSequence)paramObj.getString("tenantId"))) {
            elsAccount = paramObj.getString("tenantId");
        }
        if (StrUtil.isNotBlank((CharSequence)paramObj.getString("elsAccount"))) {
            elsAccount = paramObj.getString("elsAccount");
        }
        if (StrUtil.isBlank((CharSequence)elsAccount)) {
            log.error("parameter must contain elsAccount.");
            return;
        }
        TenantContext.setTenant((String)elsAccount);
        String requestId = TenantContext.getTenant();
        try {
            log.info(":::\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5b9a\u65f6\u53bb\u67e5\u8be2\u4e34\u65f6\u4f9b\u5e94\u5546\u662f\u5426\u5df2\u5230\u671fsupplierMasterDataTermJob start");
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"els_account", (Object)elsAccount);
            wrapper.eq((Object)"account_group", (Object)"C005");
            wrapper.ne((Object)"supplier_status", (Object)SupplierStatusEnum.POTENTIAL_SUPPLIER.getValue());
            wrapper.lt((Object)"supplier_term_date", (Object)DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
            List list = this.supplierMasterDataService.list((Wrapper)wrapper);
            if (CollUtil.isNotEmpty((Collection)list) && list.size() > 0) {
                list.stream().forEach(o -> {
                    try {
                        String tenant = TenantContext.getTenant();
                        LoginUserDTO loginUser = SysUtil.getLoginUser();
                        if (loginUser == null) {
                            loginUser = new LoginUserDTO();
                            loginUser.setElsAccount(tenant);
                            loginUser.setSubAccount("1001");
                            LoginUserContext.setUser((LoginUserDTO)loginUser);
                        }
                        LoginUserDTO finalLoginUser = loginUser;
                        this.srmPoolExecutor.execute(() -> {
                            try {
                                if (this.redisUtil.tryGetDistributedLock("supplierMasterData_schedule_supplierMasterDataTermJob", o.getId(), 50000L)) {
                                    LoginUserContext.setUser((LoginUserDTO)finalLoginUser);
                                    TenantContext.setTenant((String)tenant);
                                    SupplierMasterDataVO dataVO = this.supplierMasterDataService.getDataById(o.getId());
                                    dataVO.setSupplierStatus(SupplierStatusEnum.POTENTIAL_SUPPLIER.getValue());
                                    this.supplierInfoChangeHeadService.saveMainToChangInfo(dataVO, Boolean.TRUE);
                                    this.saveFrozenData((SupplierMasterData)((Object)o));
                                }
                            }
                            finally {
                                LoginUserContext.clear();
                                TenantContext.clear();
                                this.redisUtil.releaseDistributedLock("supplierMasterData_schedule_supplierMasterDataTermJob", o.getId());
                            }
                        });
                    }
                    catch (Exception e) {
                        log.error(":::\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5b9a\u65f6\u53bb\u67e5\u8be2\u4e34\u65f6\u4f9b\u5e94\u5546\u662f\u5426\u5df2\u5230\u671f-\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u63a8\u9001ERP\u66f4\u65b0\u5f02\u5e38:{}", (Object)e.getMessage());
                    }
                });
            }
            log.info(":::\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5b9a\u65f6\u53bb\u67e5\u8be2\u4e34\u65f6\u4f9b\u5e94\u5546\u662f\u5426\u5df2\u5230\u671fsupplierMasterDataTermJob end");
        }
        catch (Exception e) {
            log.info(Thread.currentThread().getName() + "\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5b9a\u65f6\u53bb\u67e5\u8be2\u4e34\u65f6\u4f9b\u5e94\u5546\u662f\u5426\u5df2\u5230\u671f\u5b9a\u65f6\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
    }

    public void saveFrozenData(SupplierMasterData data) {
        List srmFreezeFunction = this.invokeBaseRpcService.queryDictItemsByCode("srmFreezeFunction", TenantContext.getTenant());
        if (CollUtil.isNotEmpty((Collection)srmFreezeFunction)) {
            SupplierMasterDataVO dataVO = this.supplierMasterDataService.getDataById(data.getId());
            ArrayList<SupplierMasterFrozen> frozenList = new ArrayList<SupplierMasterFrozen>();
            for (DictDTO dictDTO : srmFreezeFunction) {
                SupplierMasterFrozen frozen = new SupplierMasterFrozen();
                frozen.setFrozenFunction(dictDTO.getValue());
                frozen.setFrozenStatus("1");
                frozen.setIsSelectAll("1");
                frozen.setRemark("\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa");
                frozenList.add(frozen);
            }
            String frozenFunction = JSON.toJSONString(frozenList);
            dataVO.setFrozenFunction(frozenFunction);
            SupplierMasterData supplierMasterData = new SupplierMasterData();
            BeanUtils.copyProperties((Object)((Object)dataVO), (Object)((Object)supplierMasterData));
            List<SupplierMasterFrozen> supplierMasterFrozens = this.supplierMasterFrozenService.saveMainByMasterId(supplierMasterData, dataVO);
            if (!supplierMasterFrozens.isEmpty() && supplierMasterFrozens.size() > 0) {
                SupplierMasterData supplierMaster = new SupplierMasterData();
                supplierMaster.setId(supplierMasterData.getId());
                supplierMaster.setFrozenFunction(JSONObject.toJSONString(supplierMasterFrozens));
                supplierMaster.setDataVersion(supplierMasterData.getDataVersion());
                this.supplierMasterDataService.updateById((Object)supplierMaster);
            }
        }
    }
}

