/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.api.dto.SupplierDTO;
import com.els.modules.supplier.api.service.SupplierContactsInfoRpcService;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.modules.supplier.api.service.SupplierRpcService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RpcService
public class SupplierRpcServiceImpl
implements SupplierRpcService {
    @Resource
    private SupplierMasterDataService supplierMasterDataService;

    public List<String> getUserIdByJobFunction(String jobFunction, String pruchaseAccount, String supllierAccount) {
        return ((SupplierContactsInfoRpcService)SpringContextUtils.getBean(SupplierContactsInfoRpcService.class)).getUserIdByJobFunction(jobFunction, pruchaseAccount, supllierAccount);
    }

    public List<String> listSupplierMasterData(String elsAccount) {
        return this.supplierMasterDataService.selectWithoutElsAccountToListSupplierMasterData(elsAccount);
    }

    public Map<String, Set<String>> loadAllPurchaseBySale(List<String> toElsAccountList) {
        return this.supplierMasterDataService.selectWithoutElsAccountToLoadAllPurchaseBySale(toElsAccountList);
    }

    public List<String> getSupplierMasterDataBigB(String elsAccount) {
        return this.supplierMasterDataService.getSupplierMasterDataBigB(elsAccount);
    }

    public List<SupplierDTO> findSupplierList(String elsAccount, String supplierName) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        if (StrUtil.isNotBlank((CharSequence)supplierName)) {
            wrapper.like((Object)"supplier_name", (Object)supplierName);
        }
        List datas = this.supplierMasterDataService.list((Wrapper)wrapper);
        return SysUtil.copyProperties((List)datas, SupplierDTO.class);
    }

    public List<String> getSupplierToElsAccount(String name) {
        return ((SupplierMasterDataRpcService)SpringContextUtils.getBean(SupplierMasterDataRpcService.class)).getSupplierToElsAccount(name);
    }

    public List<String> getSupplierElsAccount(String name) {
        return this.supplierMasterDataService.selectWithoutElsAccountToGetELsAccount(name, TenantContext.getTenant());
    }
}

