/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.PurchaseStandardItem;
import com.els.modules.supplier.entity.SupplierAccessPolicy;
import com.els.modules.supplier.service.PurchaseStandardHeadService;
import com.els.modules.supplier.service.PurchaseStandardItemService;
import com.els.modules.supplier.service.SupplierAccessPolicyService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/purchaseStandardItem"})
@Tag(name="\u91c7\u8d2d\u51c6\u5165\u884c")
@BusinessModule(module="purchase_standard")
public class PurchaseStandardItemController
extends BaseController<PurchaseStandardItem, PurchaseStandardItemService> {
    @Autowired
    private PurchaseStandardHeadService purchaseStandardHeadService;
    @Autowired
    private PurchaseStandardItemService purchaseStandardItemService;
    @Autowired
    private SupplierAccessPolicyService supplierAccessPolicyService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:list"})
    @PermissionDataView(businessType="purchase_standard")
    public Result<?> queryPageList(PurchaseStandardItem purchaseStandardItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="myToDo", defaultValue="0") Boolean myToDo, HttpServletRequest req) {
        SupplierAccessPolicy accessPolicy;
        String accessCateCode = req.getParameter("accessCateCode");
        String accessPurchaseOrg = req.getParameter("accessPurchaseOrg");
        String accessLowestMark = req.getParameter("accessLowestMark");
        String accessToElsAccount = req.getParameter("accessToElsAccount");
        Map parameters = req.getParameterMap();
        Set keys = parameters.keySet();
        String policyId = null;
        for (String string : keys) {
            if (!"policyId".equals(string) || parameters.get(string) == null) continue;
            policyId = ((String[])parameters.get(string))[0];
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseStandardItem), (Map)parameters);
        if (policyId != null && (accessPolicy = (SupplierAccessPolicy)((Object)this.supplierAccessPolicyService.getById((Serializable)((Object)policyId)))) != null && accessPolicy.getLowestMark() != null) {
            queryWrapper.ge((Object)"total_score", (Object)accessPolicy.getLowestMark());
        }
        queryWrapper.orderByDesc((Object)"update_time");
        QueryWrapper queryWrapperHead = QueryGenerator.initQueryWrapper((Object)((Object)new PurchaseStandardHead()), (Map)parameters);
        if (StrUtil.isNotBlank((CharSequence)accessCateCode)) {
            queryWrapperHead.lambda().and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(PurchaseStandardHead::getCateCode)).or()).eq(PurchaseStandardHead::getCateCode, (Object)accessCateCode)).or()).eq(PurchaseStandardHead::getCateCode, (Object)""));
        }
        if (StrUtil.isNotBlank((CharSequence)accessPurchaseOrg)) {
            queryWrapperHead.lambda().and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(PurchaseStandardHead::getPurchaseOrg)).or()).eq(PurchaseStandardHead::getPurchaseOrg, (Object)accessPurchaseOrg)).or()).eq(PurchaseStandardHead::getPurchaseOrg, (Object)""));
        }
        if (StrUtil.isNotBlank((CharSequence)accessLowestMark)) {
            queryWrapperHead.lambda().gt(PurchaseStandardHead::getTotalScore, (Object)accessLowestMark);
        }
        if (StrUtil.isNotBlank((CharSequence)accessToElsAccount)) {
            queryWrapperHead.lambda().eq(PurchaseStandardHead::getToElsAccount, (Object)accessToElsAccount);
        }
        Page pageHead = new Page((long)pageNo.intValue(), Integer.MAX_VALUE);
        Page pageHeadRes = (Page)this.purchaseStandardHeadService.page((IPage)pageHead, (Wrapper)queryWrapperHead);
        List collect = pageHeadRes.getRecords().stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)pageHeadRes.getRecords())) {
            queryWrapper.lambda().in(PurchaseStandardItem::getHeadId, collect);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseStandardItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:list"})
    @PermissionDataView(businessType="purchase_standard")
    public Result<?> queryTabsCount(PurchaseStandardItem standardHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"item_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"item_status");
        List list = ((PurchaseStandardItemService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseStandardItem::getItemStatus, PurchaseStandardItem::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "srmStandardStatus", null, (long)all.intValue()));
        List srmContractStatus = ((BaseRpcService)SrmRpcUtil.getExecuteServiceImpl(BaseRpcService.class)).queryDictItemsByCode("srmStandardStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "itemStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }
}

