/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.BusMessageUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.util.SupplierPasswordUtils;
import jakarta.annotation.Resource;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;

@RpcService(value="supplierContactsExcelRpcHandler")
public class SupplierContactsExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupplierContactsExcelHandler.class);
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private static final Pattern CHINA_PATTERN = Pattern.compile("^((13[0-9])|(14[0,1,4-9])|(15[0-3,5-9])|(16[2,5,6,7])|(17[0-8])|(18[0-9])|(19[0-3,5-9]))\\d{8}$");
    @Lazy
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Resource
    private SupplierInvokeEnterpriseRpcService elsEnterpriseInfoService;
    @Lazy
    @Resource
    private AccountRpcService accountRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<SupplierContactsInfo> contactsInfos = new ArrayList<SupplierContactsInfo>();
        HashMap<CallSite, SupplierContactsInfo> map = new HashMap<CallSite, SupplierContactsInfo>();
        HashMap<String, Map<String, String>> roleMaps = new HashMap<String, Map<String, String>>();
        ArrayList eslSubAccount = Lists.newArrayList();
        ArrayList eslSubAccount2 = Lists.newArrayList();
        for (Map data : dataList) {
            Object entity = (SupplierContactsInfo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), SupplierContactsInfo.class));
            String a = entity.getElsAccount() + "_" + entity.getSubAccount();
            if (!CharSequenceUtil.isNotEmpty((CharSequence)a) || eslSubAccount.contains(a)) continue;
            eslSubAccount.add(a);
        }
        List<Object> subAccountList = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)eslSubAccount)) {
            subAccountList = this.supplierInvokeAccountRpcService.getAccountListByElsSubAccountWithoutUser(eslSubAccount);
        }
        Map accountDTOMap = subAccountList.stream().collect(Collectors.toMap(x -> x.getElsAccount() + "_" + x.getSubAccount(), Function.identity(), (v1, v2) -> v1));
        for (Map data : dataList) {
            String msg;
            SupplierContactsInfo entity = (SupplierContactsInfo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), SupplierContactsInfo.class));
            if (!CharSequenceUtil.isNotEmpty((CharSequence)entity.getSubAccount())) {
                String msg2 = I18nUtil.translate((String)"i18n_alert_JeyIMK_be24e5c1", (String)"\u5b50\u8d26\u53f7\u5df2\u5b58\u5728");
                this.errorAdd(excelImportDTO, msg2, data);
                continue;
            }
            eslSubAccount2.add(entity.getSubAccount());
            String a = entity.getElsAccount() + "_" + entity.getSubAccount();
            if (accountDTOMap.containsKey(a)) {
                msg = I18nUtil.translate((String)"i18n_alert_JeyIMK_be24e5c1", (String)"\u5b50\u8d26\u53f7\u5df2\u5b58\u5728");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (StrUtil.isNotBlank((CharSequence)entity.getTelphone()) && !CHINA_PATTERN.matcher(entity.getTelphone()).matches()) {
                msg = I18nUtil.translate((String)"i18n_alert_cWFltyomKNS_cbdebcc", (String)"\u884c\u6570\u636e\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (StrUtil.isBlank((CharSequence)entity.getSubAccount())) {
                msg = I18nUtil.translate((String)"i18n_title_theSubaccountCannotBeEmpty", (String)"\u5b50\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (entity.getSubAccount().contains("_")) {
                msg = I18nUtil.translate((String)"i18n_alert_JeyxOsx_b34e7aa", (String)"\u5b50\u8d26\u53f7\u4e0d\u80fd\u5305\u542b _ ");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (StrUtil.isBlank((CharSequence)entity.getEmail())) {
                msg = I18nUtil.translate((String)"i18n_title_emailCannotBeEmpty", (String)"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (!SupplierContactsExcelHandler.checkEmaile(entity.getEmail())) {
                msg = I18nUtil.translate((String)"i18n_alert_jdmKNS_e2a736cc", (String)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            contactsInfos.add(entity);
        }
        List<String> elsAccountList = contactsInfos.stream().map(ParentEntity::getElsAccount).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        List<ElsEnterpriseInfoDTO> accountList = this.elsEnterpriseInfoService.selectWithoutElsAccountByElsAccountList(elsAccountList);
        Map accountMap = accountList.stream().collect(Collectors.toMap(ParentEntityDTO::getElsAccount, Function.identity(), (v1, v2) -> v1));
        List<RoleDTO> allRoleList = this.supplierInvokeAccountRpcService.selectWithoutElsAccountOfAllRole(elsAccountList);
        Map<String, List<RoleDTO>> roleMap = allRoleList.stream().collect(Collectors.groupingBy(RoleDTO::getElsAccount));
        int size = contactsInfos.size();
        int i = 1;
        for (int j = size - 1; j >= 0; --j) {
            Object roleList;
            ElsSubAccountDTO subAccount;
            ((SupplierContactsInfo)((Object)contactsInfos.get(i - 1))).setToElsAccount(SysUtil.getLoginUser().getElsAccount());
            SupplierContactsInfo entity = (SupplierContactsInfo)((Object)contactsInfos.get(j));
            if (StrUtil.isBlank((CharSequence)entity.getElsAccount()) || StrUtil.isBlank((CharSequence)entity.getName()) || null == accountMap.get(entity.getElsAccount())) {
                contactsInfos.remove(j);
                continue;
            }
            entity.setDeleted(CommonConstant.DEL_FLAG_0);
            String accountKey = entity.getElsAccount() + "_" + entity.getSubAccount();
            if (!map.containsKey(accountKey) && (subAccount = (ElsSubAccountDTO)accountDTOMap.get(accountKey)) == null) {
                map.put((CallSite)((Object)accountKey), entity);
            }
            if (!roleMaps.containsKey(entity.getElsAccount()) && null != (roleList = roleMap.get(entity.getElsAccount()))) {
                Map<String, String> temRoleMap = roleList.stream().collect(Collectors.toMap(RoleDTO::getRoleCode, RoleDTO::getId));
                roleMaps.put(entity.getElsAccount(), temRoleMap);
            }
            ++i;
        }
        ArrayList<ElsSubAccountDTO> elsSubAccounts = new ArrayList<ElsSubAccountDTO>();
        ArrayList<ElsSubAccountDTO> smsSubAccounts = new ArrayList<ElsSubAccountDTO>();
        String deployWay = SysUtil.getDeployWay();
        for (String sub : map.keySet()) {
            String elsAccount = sub.split("_")[0];
            SupplierContactsInfo entity = (SupplierContactsInfo)((Object)map.get(sub));
            ElsSubAccountDTO account = new ElsSubAccountDTO();
            account.setId(IdWorker.getIdStr());
            account.setElsAccount(entity.getElsAccount());
            account.setSubAccount(entity.getSubAccount());
            account.setRealname(entity.getName());
            account.setPhone(entity.getTelphone());
            account.setEmail(entity.getEmail());
            account.setStatus(Integer.valueOf(1));
            String password = entity.getPersonPassword();
            if ("cloud".equals(deployWay)) {
                password = SupplierPasswordUtils.generatePwd(SysUtil.getLoginUser().getElsAccount());
            }
            String salt = ConvertUtils.randomGen((int)8);
            account.setSalt(salt);
            password = StrUtil.isNotBlank((CharSequence)password) ? password : SupplierPasswordUtils.getDefaultPassword(account.getElsAccount() + account.getSubAccount());
            String passwordEncode = PasswordUtil.encrypt((String)(entity.getElsAccount() + "_" + account.getSubAccount()), (String)password, (String)salt);
            account.setPassword(passwordEncode);
            account.setDeleted(CommonConstant.DEL_FLAG_0);
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)((CharSequence)((Map)roleMaps.get(elsAccount)).get(entity.getRoleCode()))), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWRdXjWWWWWWjKyAoxiR_1d59192b", (String)"[${0}]\u4f9b\u5e94\u5546\u7684[${1}]\u7684\u89d2\u8272\u7f16\u7801\u4e0d\u6b63\u786e", (String[])new String[]{entity.getElsAccount(), entity.getSubAccount()}));
            account = this.supplierInvokeAccountRpcService.addUserWithRole(account, (String)((Map)roleMaps.get(elsAccount)).get(entity.getRoleCode()));
            List personalSettingDTOS = this.accountRpcService.buildPersonalSetting(account.getElsAccount(), account.getSubAccount());
            this.accountRpcService.savePersonalSetting(personalSettingDTOS);
            elsSubAccounts.add(account);
            ElsSubAccountDTO smsAccount = new ElsSubAccountDTO();
            BeanUtils.copyProperties((Object)account, (Object)smsAccount);
            smsAccount.setPassword(password);
            smsSubAccounts.add(smsAccount);
        }
        if (CollUtil.isNotEmpty(contactsInfos)) {
            List<SupplierMasterData> supplierMasterData = this.supplierMasterDataService.listByToElsAccount(elsAccountList);
            Map dataMap = supplierMasterData.stream().collect(Collectors.toMap(SupplierMasterData::getToElsAccount, Function.identity(), (v1, v2) -> v2));
            contactsInfos.forEach(ct -> {
                SupplierMasterData masterData = (SupplierMasterData)((Object)((Object)dataMap.get(ct.getElsAccount())));
                if (masterData != null) {
                    ct.setHeadId(masterData.getId());
                }
            });
        }
        this.supplierContactsInfoService.saveBatch(contactsInfos);
        ElsEnterpriseInfoDTO purInfo = this.elsEnterpriseInfoService.getByElsAccount(SysUtil.getLoginUser().getElsAccount());
        for (ElsSubAccountDTO dto : smsSubAccounts) {
            HashMap<String, Object> sendMsgInfo = new HashMap<String, Object>();
            sendMsgInfo.put("purchaseName", purInfo == null ? "" : purInfo.getName());
            sendMsgInfo.put("purchaseElsAccount", purInfo == null ? "" : purInfo.getElsAccount());
            String name = dto.getElsAccount() == null ? "" : ((ElsEnterpriseInfoDTO)accountMap.get(dto.getElsAccount())).getName();
            sendMsgInfo.put("supplierName", name);
            sendMsgInfo.put("supplierElsAccount", dto.getElsAccount());
            sendMsgInfo.put("subAccount", dto.getSubAccount());
            sendMsgInfo.put("password", dto.getPassword());
            sendMsgInfo.put("loginUrl", this.address + "/user/login");
            String idStr = IdWorker.getIdStr();
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(sendMsgInfo));
            this.redisUtil.set("sys:message:" + idStr, (Object)jsonObject, 172800L);
            this.sendMessage(SysUtil.getLoginUser().getElsAccount(), "supplierMasterData", "batchImportContacts", idStr, "registerBusDataServiceImpl", Arrays.asList(dto.getElsAccount() + "_" + dto.getSubAccount()), "1");
        }
        List userIdList = elsSubAccounts.stream().map(ParentEntityDTO::getId).collect(Collectors.toList());
        String tenant = TenantContext.getTenant();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        this.srmPoolExecutor.execute(() -> {
            LoginUserContext.setUser((LoginUserDTO)loginUser);
            TenantContext.setTenant((String)tenant);
            LoginUserContext.clear();
            TenantContext.clear();
        });
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }

    public static boolean checkEmaile(String emaile) {
        String RULE_EMAIL = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
        Pattern p = Pattern.compile(RULE_EMAIL);
        Matcher m = p.matcher(emaile);
        return m.matches();
    }

    public void sendMessage(String busAccount, String businessType, String operateType, String businessId, String businessBean, List<String> toElsAccountList, String isHasSubAccount) {
        try {
            if (StrUtil.isBlank((CharSequence)busAccount) || toElsAccountList == null || toElsAccountList.isEmpty() || StrUtil.isBlank((CharSequence)businessId) || StrUtil.isBlank((CharSequence)businessBean) || StrUtil.isBlank((CharSequence)businessType) || StrUtil.isBlank((CharSequence)operateType)) {
                log.error("sendMessage_failed:\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01");
                return;
            }
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgId", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)busAccount);
            msgObj.put("elsAccount", (Object)TenantContext.getTenant());
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessId", (Object)businessId);
            msgObj.put("businessBean", (Object)businessBean);
            msgObj.put("sendObj", (Object)SysUtil.getLoginUser());
            msgObj.put("toElsAccountList", (Object)JSONArray.parseArray((String)JSON.toJSONString(toElsAccountList)));
            msgObj.put("isHasSubAccount", (Object)isHasSubAccount);
            BusMessageUtil.sendBusMsg((String)msgObj.toJSONString(), (String)businessId);
        }
        catch (Exception e) {
            log.error("sendMessage_failed:", (Throwable)e);
        }
    }
}

