/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.ElsBusinessTransferHisDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.myschedule.entity.MySchedule;
import com.els.modules.myschedule.mapper.MyScheduleMapper;
import com.els.modules.myschedule.service.MyScheduleService;
import com.els.modules.supplier.entity.PurchaseVisitHead;
import com.els.modules.supplier.entity.PurchaseVisitItem;
import com.els.modules.supplier.entity.SaleVisitHead;
import com.els.modules.supplier.entity.SaleVisitItem;
import com.els.modules.supplier.enumerate.VisitStatusEnum;
import com.els.modules.supplier.mapper.PurchaseVisitHeadMapper;
import com.els.modules.supplier.mapper.PurchaseVisitItemMapper;
import com.els.modules.supplier.mapper.SaleVisitHeadMapper;
import com.els.modules.supplier.service.PurchaseVisitHeadService;
import com.els.modules.supplier.service.PurchaseVisitItemService;
import com.els.modules.supplier.service.SaleVisitHeadService;
import com.els.modules.supplier.service.SaleVisitItemService;
import com.els.modules.supplier.vo.PurchaseVisitHeadTransferVO;
import com.els.modules.supplier.vo.PurchaseVisitHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseVisitHeadServiceImpl
extends BaseServiceImpl<PurchaseVisitHeadMapper, PurchaseVisitHead>
implements PurchaseVisitHeadService {
    private final SimpleDateFormat DATA_FORMART = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    @Autowired
    private PurchaseVisitItemService purchaseVisitItemService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private PurchaseVisitItemMapper purchaseVisitItemMapper;
    @Resource
    private SaleVisitHeadMapper saleVisitHeadMapper;
    @Resource
    private SaleVisitItemService saleVisitItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private MyScheduleService myScheduleService;
    @Resource
    private MyScheduleMapper myScheduleMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseVisitHead purchaseVisitHead, List<PurchaseVisitItem> purchaseVisitItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        purchaseVisitHead.setVisitStatus(VisitStatusEnum.NEW.getValue());
        purchaseVisitHead.setVisitAccount(loginUser.getElsAccount());
        purchaseVisitHead.setVisitSupplierName(loginUser.getCompanyName());
        if ("0".equals(purchaseVisitHead.getAudited())) {
            purchaseVisitHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseVisitHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        if (StrUtil.isBlank((CharSequence)purchaseVisitHead.getVisitNumber())) {
            purchaseVisitHead.setVisitNumber(this.baseRpcService.getNextCode("purchaseBookVisitNumber", (Object)purchaseVisitHead, TenantContext.getTenant()));
        }
        this.save((Object)purchaseVisitHead);
        super.setHeadDefaultValue((ParentEntity)purchaseVisitHead);
        this.insertData(purchaseVisitHead, purchaseVisitItemList, purchaseAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseVisitHead purchaseVisitHead, List<PurchaseVisitItem> purchaseVisitItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if ("0".equals(purchaseVisitHead.getAudited())) {
            purchaseVisitHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else if (VisitStatusEnum.NEW.getValue().equals(purchaseVisitHead.getVisitStatus())) {
            purchaseVisitHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        ((PurchaseVisitHeadMapper)this.baseMapper).updateById((Object)purchaseVisitHead);
        this.purchaseVisitItemService.deleteByMainId(purchaseVisitHead.getId());
        this.baseRpcService.deletePurchaseAttachmentByMainId(purchaseVisitHead.getId());
        this.insertData(purchaseVisitHead, purchaseVisitItemList, purchaseAttachmentList);
    }

    private void insertData(PurchaseVisitHead purchaseVisitHead, List<PurchaseVisitItem> purchaseVisitItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseVisitItemList)) {
            for (PurchaseVisitItem purchaseVisitItem : purchaseVisitItemList) {
                purchaseVisitItem.setId(null);
                purchaseVisitItem.setHeadId(purchaseVisitHead.getId());
                purchaseVisitItem.setVisitNumber(purchaseVisitHead.getVisitNumber());
                SysUtil.setSysParam((BaseEntity)purchaseVisitItem, (BaseEntity)purchaseVisitHead);
            }
            this.purchaseVisitItemService.saveBatch(purchaseVisitItemList, 2000);
        }
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setId(null);
                purchaseAttachmentDTO.setHeadId(purchaseVisitHead.getId());
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchaseVisitHead);
                purchaseAttachmentDTO.setBusinessType("bookVisit");
                purchaseAttachmentDTO.setSendStatus("0");
            }
            this.baseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    public PurchaseVisitHeadVO queryById(String id) {
        PurchaseVisitHead purchaseVisitHead = (PurchaseVisitHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseVisitHeadVO purchaseVisitHeadVO = new PurchaseVisitHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHead), (Object)((Object)purchaseVisitHeadVO));
        List<PurchaseVisitItem> purchaseVisitItemList = this.purchaseVisitItemService.selectByMainId(id);
        purchaseVisitHeadVO.setPurchaseVisitItemList(purchaseVisitItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseVisitHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return purchaseVisitHeadVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseVisitItemService.deleteByMainId(id);
        ((PurchaseVisitHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseVisitItemService.deleteByMainId(serializable.toString());
            ((PurchaseVisitHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseVisitHeadVO headVO) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseVisitHead));
        int count = this.myScheduleMapper.selectWithoutElsAccountConflict(headVO.getToElsAccount(), headVO.getIntervieweePrincipal(), headVO.getVisitStartTime(), headVO.getVisitEndTime());
        Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APUZmCKIIjBLpAVVVHVUZmCKI_dad8d2b2", (String)"\u5f53\u524d\u9884\u7ea6\u62dc\u8bbf\u65f6\u95f4\u5df2\u6709\u65e5\u7a0b\u5b89\u6392\uff0c\u8bf7\u91cd\u65b0\u66f4\u65b0\u9884\u7ea6\u62dc\u8bbf\u65f6\u95f4\u3002"));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.eq(MySchedule::getSubAccount, (Object)headVO.getVisitPrincipal());
        queryWrapper.lt(MySchedule::getBeginTime, (Object)headVO.getVisitEndTime());
        queryWrapper.gt(MySchedule::getEndTime, (Object)headVO.getVisitStartTime());
        Assert.isTrue((this.myScheduleService.count((Wrapper)queryWrapper) == 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APIIjBLjVPsMKm_5dbd60fd", (String)"\u5f53\u524d\u5b9a\u4e49\u7684\u65e5\u7a0b\u6709\u51b2\u7a81\uff0c\u4fdd\u5b58\u5931\u8d25\uff01"));
        if (StrUtil.isBlank((CharSequence)headVO.getId())) {
            this.saveMain(purchaseVisitHead, headVO.getPurchaseVisitItemList(), headVO.getPurchaseAttachmentList());
        } else {
            this.updateMain(purchaseVisitHead, headVO.getPurchaseVisitItemList(), headVO.getPurchaseAttachmentList());
        }
        purchaseVisitHead.setSendTime(new Date());
        if ("1".equals(purchaseVisitHead.getTeamwork())) {
            purchaseVisitHead.setVisitStatus(VisitStatusEnum.WAIT_CONFIRM.getValue());
        } else {
            purchaseVisitHead.setVisitStatus(VisitStatusEnum.WAIT_VISIT.getValue());
        }
        List<PurchaseVisitItem> purchaseVisitItemList = this.purchaseVisitItemMapper.selectByMainId(purchaseVisitHead.getId());
        List purchaseAttachmentList = this.baseRpcService.selectPurchaseAttachmentByMainId(purchaseVisitHead.getId());
        SaleVisitHead saleVisitHead = (SaleVisitHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseVisitHead), SaleVisitHead.class));
        saleVisitHead.setId(null);
        saleVisitHead.setRelationId(purchaseVisitHead.getId());
        saleVisitHead.setVisitNumber(purchaseVisitHead.getVisitNumber());
        saleVisitHead.setElsAccount(purchaseVisitHead.getToElsAccount());
        if (StrUtil.isNotBlank((CharSequence)purchaseVisitHead.getRelationId())) {
            SaleVisitHead oldSaleVisitHead = (SaleVisitHead)((Object)this.saleVisitHeadMapper.selectById((Serializable)((Object)purchaseVisitHead.getRelationId())));
            if (oldSaleVisitHead != null) {
                saleVisitHead.setId(oldSaleVisitHead.getId());
                saleVisitHead.setDataVersion(oldSaleVisitHead.getDataVersion());
                saleVisitHead.setBusAccount(purchaseVisitHead.getElsAccount());
                this.saleVisitHeadMapper.updateById((Object)saleVisitHead);
                this.saleVisitItemService.deleteByMainId(saleVisitHead.getId());
                this.inserSaleVistItem(saleVisitHead, purchaseVisitItemList);
                this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleVisitHead.getId());
                this.inserSaleAttachement(saleVisitHead, purchaseAttachmentList);
            } else {
                saleVisitHead.setBusAccount(purchaseVisitHead.getElsAccount());
                this.saleVisitHeadMapper.insert((Object)saleVisitHead);
                this.inserSaleVistItem(saleVisitHead, purchaseVisitItemList);
                this.inserSaleAttachement(saleVisitHead, purchaseAttachmentList);
            }
        } else {
            saleVisitHead.setBusAccount(purchaseVisitHead.getElsAccount());
            this.saleVisitHeadMapper.insert((Object)saleVisitHead);
            this.inserSaleVistItem(saleVisitHead, purchaseVisitItemList);
            this.inserSaleAttachement(saleVisitHead, purchaseAttachmentList);
        }
        purchaseVisitHead.setRelationId(saleVisitHead.getId());
        this.updateById((Object)purchaseVisitHead);
        this.sendMsg(purchaseVisitHead, purchaseVisitItemList, "publish");
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publishAudit(PurchaseVisitHeadVO headVO) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseVisitHead));
        purchaseVisitHead.setSendTime(new Date());
        if ("1".equals(purchaseVisitHead.getTeamwork())) {
            purchaseVisitHead.setVisitStatus(VisitStatusEnum.WAIT_CONFIRM.getValue());
        } else {
            purchaseVisitHead.setVisitStatus(VisitStatusEnum.WAIT_VISIT.getValue());
        }
        List<PurchaseVisitItem> purchaseVisitItemList = this.purchaseVisitItemMapper.selectByMainId(purchaseVisitHead.getId());
        List purchaseAttachmentList = this.baseRpcService.selectPurchaseAttachmentByMainId(purchaseVisitHead.getId());
        SaleVisitHead saleVisitHead = (SaleVisitHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseVisitHead), SaleVisitHead.class));
        saleVisitHead.setId(null);
        saleVisitHead.setRelationId(purchaseVisitHead.getId());
        saleVisitHead.setVisitNumber(purchaseVisitHead.getVisitNumber());
        saleVisitHead.setElsAccount(purchaseVisitHead.getToElsAccount());
        if (StrUtil.isNotBlank((CharSequence)purchaseVisitHead.getRelationId())) {
            SaleVisitHead oldSaleVisitHead = (SaleVisitHead)((Object)this.saleVisitHeadMapper.selectById((Serializable)((Object)purchaseVisitHead.getRelationId())));
            if (oldSaleVisitHead != null) {
                saleVisitHead.setId(oldSaleVisitHead.getId());
                saleVisitHead.setDataVersion(oldSaleVisitHead.getDataVersion());
                saleVisitHead.setBusAccount(purchaseVisitHead.getElsAccount());
                this.saleVisitHeadMapper.updateById((Object)saleVisitHead);
                this.saleVisitItemService.deleteByMainId(saleVisitHead.getId());
                this.inserSaleVistItem(saleVisitHead, purchaseVisitItemList);
                this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleVisitHead.getId());
                this.inserSaleAttachement(saleVisitHead, purchaseAttachmentList);
            } else {
                saleVisitHead.setBusAccount(purchaseVisitHead.getElsAccount());
                this.saleVisitHeadMapper.insert((Object)saleVisitHead);
                this.inserSaleVistItem(saleVisitHead, purchaseVisitItemList);
                this.inserSaleAttachement(saleVisitHead, purchaseAttachmentList);
            }
        } else {
            saleVisitHead.setBusAccount(purchaseVisitHead.getElsAccount());
            this.saleVisitHeadMapper.insert((Object)saleVisitHead);
            this.inserSaleVistItem(saleVisitHead, purchaseVisitItemList);
            this.inserSaleAttachement(saleVisitHead, purchaseAttachmentList);
        }
        purchaseVisitHead.setRelationId(saleVisitHead.getId());
        this.updateById((Object)purchaseVisitHead);
        this.sendMsg(purchaseVisitHead, purchaseVisitItemList, "publish");
    }

    public void inserSaleVistItem(SaleVisitHead visitHead, List<PurchaseVisitItem> purchaseVisitItemList) {
        ArrayList<SaleVisitItem> saleVisitItemList = new ArrayList<SaleVisitItem>();
        for (PurchaseVisitItem purchaseVisitItem : purchaseVisitItemList) {
            SaleVisitItem saleVisitItem = (SaleVisitItem)((Object)SysUtil.copyProperties((Object)((Object)purchaseVisitItem), SaleVisitItem.class));
            saleVisitItem.setId(null);
            saleVisitItem.setHeadId(visitHead.getId());
            saleVisitItem.setVisitNumber(visitHead.getVisitNumber());
            saleVisitItem.setItemNumber(purchaseVisitItem.getItemNumber());
            saleVisitItem.setElsAccount(purchaseVisitItem.getToElsAccount());
            saleVisitItem.setToElsAccount(purchaseVisitItem.getElsAccount());
            saleVisitItemList.add(saleVisitItem);
        }
        if (!saleVisitItemList.isEmpty()) {
            this.saleVisitItemService.saveOrUpdateBatch(saleVisitItemList);
        }
    }

    public void inserSaleAttachement(SaleVisitHead saleVisitHead, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            ArrayList saleAttachmentList = SysUtil.copyProperties(purchaseAttachmentList, SaleAttachmentDTO.class);
            for (SaleAttachmentDTO entity : saleAttachmentList) {
                entity.setId(null);
                entity.setHeadId(saleVisitHead.getId());
                entity.setElsAccount(saleVisitHead.getElsAccount());
                entity.setBusinessType("saleBookVisit");
                entity.setSendStatus("0");
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn((List)saleAttachmentList);
        }
    }

    @Override
    public void cancel(String id) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        purchaseVisitHead.setId(id);
        purchaseVisitHead.setVisitStatus(VisitStatusEnum.INVALID.getValue());
        int count = ((PurchaseVisitHeadMapper)this.baseMapper).updateById((Object)purchaseVisitHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        SaleVisitHeadService saleVisitHeadService = (SaleVisitHeadService)SpringContextUtils.getBean(SaleVisitHeadService.class);
        saleVisitHeadService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleVisitHead::getRelationId, (Object)id)).set(SaleVisitHead::getVisitStatus, (Object)VisitStatusEnum.INVALID.getValue()));
    }

    @Override
    public void copy(PurchaseVisitHeadVO headVO) {
        List<PurchaseAttachmentDTO> purchaseAttachmentList;
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseVisitHead));
        purchaseVisitHead.setId(null);
        purchaseVisitHead.setUpdateTime(null);
        purchaseVisitHead.setUpdateBy(null);
        purchaseVisitHead.setUpdateById(null);
        purchaseVisitHead.setCreateBy(null);
        purchaseVisitHead.setCreateTime(null);
        purchaseVisitHead.setCreateById(null);
        purchaseVisitHead.setVisitNumber(null);
        purchaseVisitHead.setVisitStatus(VisitStatusEnum.NEW.getValue());
        purchaseVisitHead.setDataVersion(CommonConstant.STATUS_NO);
        purchaseVisitHead.setFlowId(null);
        purchaseVisitHead.setSendTime(null);
        purchaseVisitHead.setAuditStatus(null);
        purchaseVisitHead.setRelationId(null);
        purchaseVisitHead.setRejectReason(null);
        purchaseVisitHead.setVisitSummary(null);
        purchaseVisitHead.setVisitEvaluation(null);
        purchaseVisitHead.setVisitDate(null);
        purchaseVisitHead.setStartHour(null);
        purchaseVisitHead.setTimeLong(null);
        purchaseVisitHead.setVisitStartTime(null);
        purchaseVisitHead.setVisitEndTime(null);
        List<PurchaseVisitItem> purchaseVisitItemList = headVO.getPurchaseVisitItemList();
        if (CollectionUtil.isNotEmpty(purchaseVisitItemList)) {
            for (PurchaseVisitItem entity : purchaseVisitItemList) {
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseVisitHead);
                entity.setId(null);
                entity.setUpdateTime(null);
                entity.setUpdateBy(null);
                entity.setUpdateById(null);
                entity.setCreateBy(null);
                entity.setCreateTime(null);
                entity.setCreateById(null);
                entity.setRelationId(null);
                entity.setHeadId(null);
                entity.setVisitNumber(null);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList = headVO.getPurchaseAttachmentList())) {
            for (PurchaseAttachmentDTO attachment : purchaseAttachmentList) {
                attachment.setId(null);
                attachment.setUpdateTime(null);
                attachment.setUpdateBy(null);
                attachment.setCreateBy(null);
                attachment.setCreateTime(null);
                attachment.setCreateById(null);
                attachment.setHeadId(null);
                attachment.setRelationId(null);
                attachment.setSendStatus("0");
            }
        }
        this.saveMain(purchaseVisitHead, purchaseVisitItemList, purchaseAttachmentList);
    }

    @Override
    public void tacticsTransfer(PurchaseVisitHeadTransferVO purchaseVisitHeadTransferVO) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHeadTransferVO), (Object)((Object)purchaseVisitHead));
        ((PurchaseVisitHeadMapper)this.baseMapper).updateById((Object)purchaseVisitHead);
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        saleVisitHead.setId(purchaseVisitHead.getRelationId());
        saleVisitHead.setIntervieweePrincipal(purchaseVisitHead.getIntervieweePrincipal());
        saleVisitHead.setIntervieweePrincipalName(purchaseVisitHead.getIntervieweePrincipalName());
        saleVisitHead.setIntervieweePhone(purchaseVisitHead.getIntervieweePhone());
        this.saleVisitHeadMapper.updateById((Object)saleVisitHead);
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        ElsBusinessTransferHisDTO elsBusinessTransferHis = purchaseVisitHeadTransferVO.getElsBusinessTransferHis();
        elsBusinessTransferHis.setTransferBy(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        elsBusinessTransferHis.setTransferTime(new Date());
        this.baseRpcService.add(purchaseVisitHeadTransferVO.getElsBusinessTransferHis());
        TenantContext.setTenant((String)purchaseVisitHead.getToElsAccount());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_number", (Object)purchaseVisitHead.getVisitNumber());
        queryWrapper.eq((Object)"els_account", (Object)purchaseVisitHead.getToElsAccount());
        MySchedule oldSchedule = (MySchedule)((Object)this.myScheduleService.getOne((Wrapper)queryWrapper));
        if (oldSchedule != null) {
            this.myScheduleService.delete(oldSchedule.getId());
        }
        TenantContext.setTenant((String)purchaseVisitHead.getElsAccount());
        this.saveMyScheduleInfo(purchaseVisitHead, "interviewee");
        this.sendAppointMsg(purchaseVisitHead, purchaseVisitHead.getToElsAccount(), purchaseVisitHead.getIntervieweePrincipal(), "transfer");
    }

    @Override
    public void confirm(PurchaseVisitHead purchaseVisitHead) {
        purchaseVisitHead.setVisitStatus(VisitStatusEnum.WAIT_VISIT.getValue());
        ((PurchaseVisitHeadMapper)this.baseMapper).updateById((Object)purchaseVisitHead);
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        saleVisitHead.setId(purchaseVisitHead.getRelationId());
        saleVisitHead.setVisitStatus(VisitStatusEnum.WAIT_VISIT.getValue());
        this.saleVisitHeadMapper.updateById((Object)saleVisitHead);
        this.saveMyScheduleInfo(purchaseVisitHead, "visit");
        this.saveMyScheduleInfo(purchaseVisitHead, "interviewee");
        this.sendAppointMsg(purchaseVisitHead, purchaseVisitHead.getVisitAccount(), purchaseVisitHead.getVisitPrincipal(), "confirm");
    }

    @Override
    public void refuse(PurchaseVisitHead purchaseVisitHead) {
        purchaseVisitHead.setVisitStatus(VisitStatusEnum.REJECTED.getValue());
        ((PurchaseVisitHeadMapper)this.baseMapper).updateById((Object)purchaseVisitHead);
        SaleVisitHead saleVisitHead = new SaleVisitHead();
        saleVisitHead.setId(purchaseVisitHead.getRelationId());
        saleVisitHead.setVisitStatus(VisitStatusEnum.REJECTED.getValue());
        saleVisitHead.setRejectReason(purchaseVisitHead.getRejectReason());
        this.saleVisitHeadMapper.updateById((Object)saleVisitHead);
        this.sendAppointMsg(purchaseVisitHead, purchaseVisitHead.getVisitAccount(), purchaseVisitHead.getVisitPrincipal(), "refund");
    }

    @Override
    public void saveMyScheduleInfo(PurchaseVisitHead purchaseVisitHead, String visitType) {
        MySchedule mySchedule = new MySchedule();
        if ("visit".equals(visitType)) {
            mySchedule.setElsAccount(purchaseVisitHead.getVisitAccount());
            mySchedule.setSubAccount(purchaseVisitHead.getVisitPrincipal());
            mySchedule.setSourceId(purchaseVisitHead.getId());
            mySchedule.setSourceNumber(purchaseVisitHead.getVisitNumber());
            mySchedule.setContent("\u9884\u7ea6\u62dc\u8bbf:" + purchaseVisitHead.getVisitNumber() + "\uff0c\u9884\u7ea6\u65f6\u95f4:" + this.DATA_FORMART.format(purchaseVisitHead.getVisitStartTime()) + "-" + this.DATA_FORMART.format(purchaseVisitHead.getVisitEndTime()) + "\uff0c\u88ab\u8bbf\u8005:" + purchaseVisitHead.getSupplierName() + "-" + purchaseVisitHead.getIntervieweePrincipalName() + "\uff0c\u88ab\u8bbf\u8005\u7535\u8bdd:" + purchaseVisitHead.getIntervieweePhone());
            mySchedule.setBeginTime(purchaseVisitHead.getVisitStartTime());
            mySchedule.setEndTime(purchaseVisitHead.getVisitEndTime());
        } else {
            mySchedule.setElsAccount(purchaseVisitHead.getToElsAccount());
            mySchedule.setSubAccount(purchaseVisitHead.getIntervieweePrincipal());
            mySchedule.setSourceId(purchaseVisitHead.getId());
            mySchedule.setSourceNumber(purchaseVisitHead.getVisitNumber());
            mySchedule.setContent("\u9884\u7ea6\u62dc\u8bbf:" + purchaseVisitHead.getVisitNumber() + "\uff0c\u9884\u7ea6\u65f6\u95f4:" + this.DATA_FORMART.format(purchaseVisitHead.getVisitStartTime()) + "-" + this.DATA_FORMART.format(purchaseVisitHead.getVisitEndTime()) + "\uff0c\u6765\u8bbf\u8005:" + purchaseVisitHead.getVisitSupplierName() + "-" + purchaseVisitHead.getVisitPrincipalName() + "\uff0c\u6765\u8bbf\u8005\u7535\u8bdd:" + purchaseVisitHead.getVisitPhone());
            mySchedule.setBeginTime(purchaseVisitHead.getVisitStartTime());
            mySchedule.setEndTime(purchaseVisitHead.getVisitEndTime());
        }
        this.myScheduleService.add(mySchedule);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void summary(PurchaseVisitHead head, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if ("1".equals(head.getTeamwork())) {
            head.setVisitStatus(VisitStatusEnum.WAIT_EVALUATION.getValue());
        } else {
            head.setVisitStatus(VisitStatusEnum.COMPLETED.getValue());
        }
        this.updateById((Object)head);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(head.getId());
        this.insertAttachmentData(head, purchaseAttachmentList);
        SaleVisitHeadService saleVisitHeadService = (SaleVisitHeadService)SpringContextUtils.getBean(SaleVisitHeadService.class);
        SaleVisitHead saleVisitHead = (SaleVisitHead)((Object)saleVisitHeadService.getById((Serializable)((Object)head.getRelationId())));
        saleVisitHead.setVisitStatus(head.getVisitStatus());
        saleVisitHead.setVisitSummary(head.getVisitSummary());
        ArrayList saleAttachmentDTOList = SysUtil.copyProperties(purchaseAttachmentList, SaleAttachmentDTO.class);
        saleVisitHeadService.updateMain(saleVisitHead, this.saleVisitItemService.selectByMainId(head.getRelationId()), saleAttachmentDTOList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void evaluation(PurchaseVisitHead head, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        head.setVisitStatus(VisitStatusEnum.COMPLETED.getValue());
        this.updateById((Object)head);
        this.baseRpcService.deletePurchaseAttachmentByMainId(head.getId());
        this.insertAttachmentData(head, purchaseAttachmentList);
        SaleVisitHeadService saleVisitHeadService = (SaleVisitHeadService)SpringContextUtils.getBean(SaleVisitHeadService.class);
        SaleVisitHead saleVisitHead = (SaleVisitHead)((Object)saleVisitHeadService.getById((Serializable)((Object)head.getRelationId())));
        saleVisitHead.setVisitStatus(head.getVisitStatus());
        saleVisitHead.setVisitEvaluation(head.getVisitEvaluation());
        ArrayList saleAttachmentDTOList = SysUtil.copyProperties(purchaseAttachmentList, SaleAttachmentDTO.class);
        saleVisitHeadService.updateMain(saleVisitHead, this.saleVisitItemService.selectByMainId(head.getRelationId()), saleAttachmentDTOList);
    }

    public void insertAttachmentData(PurchaseVisitHead purchaseVisitHead, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setId(null);
                entity.setHeadId(purchaseVisitHead.getId());
                entity.setBusinessType("bookVisit");
                entity.setElsAccount(purchaseVisitHead.getElsAccount());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    private void sendMsg(PurchaseVisitHead purchaseVisitHead, List<PurchaseVisitItem> purchaseVisitItemList, String opt) {
        super.sendMessage(TenantContext.getTenant(), "bookVisit", opt, purchaseVisitHead.getId(), "visitBusDataServiceImpl", Arrays.asList(purchaseVisitHead.getToElsAccount()));
    }

    public void sendAppointMsg(PurchaseVisitHead head, String elsAccount, String account, String msgType) {
        String str = JSON.toJSONString((Object)((Object)head));
        JSONObject jsonObject = JSONObject.parseObject((String)str);
        MsgParamsVO msgParamsVO = this.parameterAssemble(elsAccount, account, jsonObject);
    }

    private MsgParamsVO parameterAssemble(String toElsAccount, String account, JSONObject jsonObject) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(toElsAccount, account);
        accountList.add(subAccount);
        receiverMap.put(toElsAccount, accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        msgParamsVO.setParams((Object)paramMap);
        HashMap receiveParamMap = new HashMap();
        JSONObject paramObj = new JSONObject();
        return msgParamsVO;
    }
}

