/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.SupplierAccessMgmt;
import com.els.modules.supplier.entity.SupplierAccessMgmtAttachment;
import com.els.modules.supplier.entity.SupplierAccessMgmtInspection;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareview;
import com.els.modules.supplier.entity.SupplierAccessMgmtQuareviewItem;
import com.els.modules.supplier.entity.SupplierAccessMgmtSamplecheck;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SupplierAccessMgmtStatusEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.mapper.SupplierAccessMgmtMapper;
import com.els.modules.supplier.mapper.SupplierOrgInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeOrgRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.modules.supplier.service.SupplierAccessMgmtAttachmentService;
import com.els.modules.supplier.service.SupplierAccessMgmtInspectionService;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewItemService;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewService;
import com.els.modules.supplier.service.SupplierAccessMgmtSamplecheckService;
import com.els.modules.supplier.service.SupplierAccessMgmtService;
import com.els.modules.supplier.service.SupplierDevDemandHeadService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.ShiftCertificationVO;
import com.els.modules.supplier.vo.SupplierAccessMgmtVO;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierAccessMgmtServiceImpl
extends BaseServiceImpl<SupplierAccessMgmtMapper, SupplierAccessMgmt>
implements SupplierAccessMgmtService {
    @Autowired
    private SupplierAccessMgmtQuareviewService supplierAccessMgmtQuareviewService;
    @Autowired
    private SupplierAccessMgmtInspectionService supplierAccessMgmtInspectionService;
    @Autowired
    private SupplierAccessMgmtSamplecheckService supplierAccessMgmtSamplecheckService;
    @Autowired
    private SupplierAccessMgmtAttachmentService supplierAccessMgmtAttachmentService;
    @Autowired
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;
    @Autowired
    private SupplierAccessMgmtQuareviewItemService supplierAccessMgmtQuareviewItemService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService invokeEnterpriseRpcService;
    @Resource
    @Lazy
    private SupplierInvokeEnterpriseRpcService supplierInvokeEnterpriseRpcService;
    @Autowired
    @Lazy
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;
    @Resource
    @Lazy
    private SupplierInvokeOrgRpcService supplierInvokeOrgRpcService;
    @Autowired
    private SupplierOrgInfoMapper supplierOrgInfoMapper;
    @Autowired
    private SupplierDevDemandHeadService supplierDevDemandHeadService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierAccessMgmt supplierAccessMgmt, List<SupplierAccessMgmtQuareview> supplierAccessMgmtQuareviewList, List<SupplierAccessMgmtInspection> supplierAccessMgmtInspectionList, List<SupplierAccessMgmtSamplecheck> supplierAccessMgmtSamplecheckList, List<SupplierAccessMgmtAttachment> supplierAccessMgmtAttachmentList) {
        if (StrUtil.isBlank((CharSequence)supplierAccessMgmt.getAccessStatus())) {
            supplierAccessMgmt.setAccessStatus(SupplierAccessMgmtStatusEnum.NEW.getValue());
        }
        supplierAccessMgmt.setAccessNumber(this.invokeBaseRpcService.getNextCode("accessMgmtNumber", (Object)supplierAccessMgmt));
        if (StrUtil.isNotBlank((CharSequence)supplierAccessMgmt.getPubishAudit())) {
            if ("0".equals(supplierAccessMgmt.getPubishAudit())) {
                supplierAccessMgmt.setPubishAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            if ("1".equals(supplierAccessMgmt.getPubishAudit())) {
                supplierAccessMgmt.setPubishAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
        }
        this.save((Object)supplierAccessMgmt);
        super.setHeadDefaultValue((ParentEntity)supplierAccessMgmt);
        this.insertData(supplierAccessMgmt, supplierAccessMgmtQuareviewList, supplierAccessMgmtInspectionList, supplierAccessMgmtSamplecheckList, supplierAccessMgmtAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void copyById(String id) {
        SupplierAccessMgmtVO supplierAccessMgmtVO = this.queryById(id);
        SupplierAccessMgmt supplierAccessMgmt = new SupplierAccessMgmt();
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmtVO), (Object)((Object)supplierAccessMgmt));
        supplierAccessMgmt.setId(null);
        supplierAccessMgmt.setAccessStatus(SupplierAccessMgmtStatusEnum.NEW.getValue());
        supplierAccessMgmt.setAccessNumber(this.invokeBaseRpcService.getNextCode("accessMgmtNumber", (Object)supplierAccessMgmt));
        supplierAccessMgmt.setPubishAuditStatus(null);
        supplierAccessMgmt.setFlowId(null);
        supplierAccessMgmt.setWorkFlowType(null);
        supplierAccessMgmt.setElsAccount(TenantContext.getTenant());
        supplierAccessMgmt.setCreateBy(null);
        supplierAccessMgmt.setCreateById(null);
        supplierAccessMgmt.setCreateTime(null);
        supplierAccessMgmt.setUpdateBy(null);
        supplierAccessMgmt.setUpdateById(null);
        supplierAccessMgmt.setUpdateTime(null);
        this.save((Object)supplierAccessMgmt);
        this.insertData(supplierAccessMgmt, supplierAccessMgmtVO.getSupplierAccessMgmtQuareviewList(), supplierAccessMgmtVO.getSupplierAccessMgmtInspectionList(), supplierAccessMgmtVO.getSupplierAccessMgmtSamplecheckList(), supplierAccessMgmtVO.getSupplierAccessMgmtAttachmentList());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierAccessMgmt supplierAccessMgmt, List<SupplierAccessMgmtQuareview> supplierAccessMgmtQuareviewList, List<SupplierAccessMgmtInspection> supplierAccessMgmtInspectionList, List<SupplierAccessMgmtSamplecheck> supplierAccessMgmtSamplecheckList, List<SupplierAccessMgmtAttachment> supplierAccessMgmtAttachmentList) {
        int count;
        if (StrUtil.isNotBlank((CharSequence)supplierAccessMgmt.getPubishAudit())) {
            if ("0".equals(supplierAccessMgmt.getPubishAudit())) {
                supplierAccessMgmt.setPubishAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            if ("1".equals(supplierAccessMgmt.getPubishAudit())) {
                supplierAccessMgmt.setPubishAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
        }
        Assert.isTrue(((count = ((SupplierAccessMgmtMapper)this.baseMapper).updateById((Object)supplierAccessMgmt)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.supplierAccessMgmtQuareviewService.deleteByMainId(supplierAccessMgmt.getId());
        this.supplierAccessMgmtInspectionService.deleteByMainId(supplierAccessMgmt.getId());
        this.supplierAccessMgmtSamplecheckService.deleteByMainId(supplierAccessMgmt.getId());
        this.supplierAccessMgmtAttachmentService.deleteByMainId(supplierAccessMgmt.getId());
        this.insertData(supplierAccessMgmt, supplierAccessMgmtQuareviewList, supplierAccessMgmtInspectionList, supplierAccessMgmtSamplecheckList, supplierAccessMgmtAttachmentList);
    }

    @Override
    public void submitSave(SupplierAccessMgmt supplierAccessMgmt, List<SupplierAccessMgmtQuareview> supplierAccessMgmtQuareviewList, List<SupplierAccessMgmtInspection> supplierAccessMgmtInspectionList, List<SupplierAccessMgmtSamplecheck> supplierAccessMgmtSamplecheckList, List<SupplierAccessMgmtAttachment> supplierAccessMgmtAttachmentList) {
        String elsAccount = supplierAccessMgmt.getElsAccount();
        String toElsAccount = supplierAccessMgmt.getToElsAccount();
        if (StrUtil.isBlank((CharSequence)toElsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_notElsAccount", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(elsAccount, toElsAccount);
        if (masterData != null && SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue().equals(masterData.getSupplierStatus()) && "0".equals(supplierAccessMgmt.getAccessType())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rRdXIKnmRdXW_3f22f68d", (String)"\u8be5\u4f9b\u5e94\u5546\u5df2\u662f\u5408\u683c\u4f9b\u5e94\u5546\uff01"));
        }
        this.checkCertificationDate(supplierAccessMgmtQuareviewList);
        if (StrUtil.isBlank((CharSequence)supplierAccessMgmt.getId())) {
            this.saveMain(supplierAccessMgmt, supplierAccessMgmtQuareviewList, supplierAccessMgmtInspectionList, supplierAccessMgmtSamplecheckList, supplierAccessMgmtAttachmentList);
        } else {
            this.updateMain(supplierAccessMgmt, supplierAccessMgmtQuareviewList, supplierAccessMgmtInspectionList, supplierAccessMgmtSamplecheckList, supplierAccessMgmtAttachmentList);
        }
        supplierAccessMgmt.setExistOrgAndCateCode(this.isExistOrgAndCateCode(supplierAccessMgmt));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publishMain(SupplierAccessMgmt supplierAccessMgmt) {
        supplierAccessMgmt = (SupplierAccessMgmt)((Object)this.getById((Serializable)((Object)supplierAccessMgmt.getId())));
        supplierAccessMgmt.setAccessStatus(SupplierAccessMgmtStatusEnum.PUBLISH.getValue());
        supplierAccessMgmt.setPubishAudit("0");
        supplierAccessMgmt.setPubishAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        this.updateById((Object)supplierAccessMgmt);
        this.updateSupplierMasterData(supplierAccessMgmt);
        if ("0".equals(supplierAccessMgmt.getAccessType())) {
            supplierAccessMgmt.setAccessType(I18nUtil.translate((String)"i18n_dict_VaRdX_c275265f", (String)"\u65b0\u589e\u4f9b\u5e94\u5546"));
        } else {
            supplierAccessMgmt.setAccessType(I18nUtil.translate((String)"i18n_dict_VaSLzA_9c1c5973", (String)"\u65b0\u589e\u7269\u6599\u5206\u7c7b"));
        }
        this.sendMessage(supplierAccessMgmt.getElsAccount(), "accessMgmt", "purchasePublish", supplierAccessMgmt.getId(), "supplierAccessMgmtBusDataServiceImpl", Lists.newArrayList((Object[])new String[]{supplierAccessMgmt.getElsAccount()}));
        this.supplierDevDemandHeadService.updDevDemandItemAccess(null, supplierAccessMgmt);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateSupplierMasterData(SupplierAccessMgmt supplierAccessMgmt) {
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(supplierAccessMgmt.getElsAccount(), supplierAccessMgmt.getToElsAccount());
        if (masterData != null) {
            masterData.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
            String accessCategory = masterData.getAccessCategory();
            String cateName = supplierAccessMgmt.getCateName();
            if (StrUtil.isNotBlank((CharSequence)cateName)) {
                cateName = cateName.replace(",", ";");
                String cateCode = StrUtil.isBlank((CharSequence)accessCategory) ? cateName : accessCategory + ";" + cateName;
                masterData.setAccessCategory(cateCode);
            }
            if (supplierAccessMgmt.getSupplierTermDate() != null) {
                masterData.setSupplierTermDate(supplierAccessMgmt.getSupplierTermDate());
            }
            this.supplierMasterDataService.updateById((Object)masterData);
            Boolean existOrgAndCateCode = this.isExistOrgAndCateCode(supplierAccessMgmt);
            if (!existOrgAndCateCode.booleanValue()) {
                SupplierOrgInfo supplierOrgInfo = new SupplierOrgInfo();
                supplierOrgInfo.setHeadId(masterData.getId());
                supplierOrgInfo.setElsAccount(masterData.getToElsAccount());
                supplierOrgInfo.setToElsAccount(masterData.getElsAccount());
                supplierOrgInfo.setOrgCode(supplierAccessMgmt.getPurchaseOrg());
                PurchaseOrganizationInfoDTO organizationInfo = this.supplierInvokeOrgRpcService.selectByElsAccountAndCode(masterData.getElsAccount(), "purchaseOrganization", supplierAccessMgmt.getPurchaseOrg());
                if (organizationInfo != null) {
                    supplierOrgInfo.setOrgDesc(organizationInfo.getOrgDesc());
                    supplierOrgInfo.setOrgId(organizationInfo.getId());
                    supplierOrgInfo.setOrgCategoryId(organizationInfo.getOrgCategoryCode());
                    supplierOrgInfo.setOrgCategoryDesc(organizationInfo.getOrgCategoryDesc());
                    supplierOrgInfo.setOrgFullDesc(organizationInfo.getOrgDesc());
                }
                supplierOrgInfo.setFrozenFlag("0");
                supplierOrgInfo.setPrincipal(supplierAccessMgmt.getPurchasePrincipal());
                supplierOrgInfo.setDataSource(supplierAccessMgmt.getAccessNumber());
                supplierOrgInfo.setRegulationType(supplierAccessMgmt.getAccessLink());
                supplierOrgInfo.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierOrgInfo.setAccessed("1");
                supplierOrgInfo.setAccessCategory(cateName);
                this.supplierOrgInfoMapper.insert((Object)supplierOrgInfo);
            }
        }
    }

    @Override
    public SupplierAccessMgmtVO queryById(String id) {
        SupplierAccessMgmtVO supplierAccessMgmtVO = new SupplierAccessMgmtVO();
        SupplierAccessMgmt supplierAccessMgmt = (SupplierAccessMgmt)((Object)this.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)supplierAccessMgmt), (Object)((Object)supplierAccessMgmtVO));
        List<SupplierAccessMgmtQuareview> supplierAccessMgmtQuareviewList = this.supplierAccessMgmtQuareviewService.selectByMainId(id);
        supplierAccessMgmtVO.setSupplierAccessMgmtQuareviewList(supplierAccessMgmtQuareviewList);
        List<SupplierAccessMgmtInspection> supplierAccessMgmtInspectionList = this.supplierAccessMgmtInspectionService.selectByMainId(id);
        supplierAccessMgmtVO.setSupplierAccessMgmtInspectionList(supplierAccessMgmtInspectionList);
        List<SupplierAccessMgmtSamplecheck> supplierAccessMgmtSamplecheckList = this.supplierAccessMgmtSamplecheckService.selectByMainId(id);
        supplierAccessMgmtVO.setSupplierAccessMgmtSamplecheckList(supplierAccessMgmtSamplecheckList);
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getByElsAccount(supplierAccessMgmt.getToElsAccount());
        supplierAccessMgmtVO.setElsEnterpriseInfo(elsEnterpriseInfo);
        List<SupplierAccessMgmtAttachment> supplierAccessMgmtAttachmentList = this.supplierAccessMgmtAttachmentService.selectByMainId(id);
        supplierAccessMgmtVO.setSupplierAccessMgmtAttachmentList(supplierAccessMgmtAttachmentList);
        return supplierAccessMgmtVO;
    }

    @Override
    public void shiftTo(ShiftCertificationVO shiftCertificationVO) {
        List<SupplierAccessMgmtQuareview> supplierAccessMgmtQuareviewList = shiftCertificationVO.getSupplierAccessMgmtQuareviewList();
        SupplierAccessMgmt accessMgmt = (SupplierAccessMgmt)((Object)this.getById((Serializable)((Object)shiftCertificationVO.getId())));
        ElsEnterpriseInfoDTO info = this.invokeEnterpriseRpcService.getByElsAccount(accessMgmt.getElsAccount());
        for (SupplierAccessMgmtQuareview item : supplierAccessMgmtQuareviewList) {
            item.setShiftTo("1");
            PurchaseCertificatedInfo certificatedInfo = new PurchaseCertificatedInfo();
            certificatedInfo.setElsAccount(accessMgmt.getElsAccount());
            certificatedInfo.setPurchaseName(info.getName());
            certificatedInfo.setToElsAccount(accessMgmt.getToElsAccount());
            certificatedInfo.setSupplierName(accessMgmt.getSupplierName());
            certificatedInfo.setCreateAccount(TenantContext.getTenant());
            certificatedInfo.setTemplateAccount(shiftCertificationVO.getTemplateAccount());
            certificatedInfo.setTemplateName(shiftCertificationVO.getTemplateName());
            certificatedInfo.setTemplateNumber(shiftCertificationVO.getTemplateNumber());
            certificatedInfo.setTemplateVersion(shiftCertificationVO.getTemplateVersion());
            certificatedInfo.setShiftToId(item.getId());
            certificatedInfo.setCertificationOrg(item.getCertificationOrg());
            certificatedInfo.setCertificationSta(item.getCertificationSta());
            certificatedInfo.setCertificationNo(item.getCertificationNo());
            certificatedInfo.setCertificationName(item.getCertificationName());
            certificatedInfo.setCertificationDate(item.getCertificationDate());
            certificatedInfo.setCertificationContent(item.getCertificationContent());
            certificatedInfo.setEffectiveDate(item.getEffectiveDate());
            certificatedInfo.setExpiryDate(item.getExpiryDate());
            if (StrUtil.isNotBlank((CharSequence)item.getCertificationStatus())) {
                if ("0".equals(item.getCertificationStatus())) {
                    certificatedInfo.setFail("1");
                }
                if ("1".equals(item.getCertificationStatus())) {
                    certificatedInfo.setFail("0");
                }
                if ("2".equals(item.getCertificationStatus())) {
                    certificatedInfo.setFail("1");
                }
            } else {
                certificatedInfo.setFail("1");
            }
            certificatedInfo.setSendStatus("0");
            certificatedInfo.setRemark(item.getRemark());
            ArrayList<PurchaseAttachmentDTO> attachments = new ArrayList<PurchaseAttachmentDTO>();
            if (StrUtil.isNotBlank((CharSequence)item.getAttachmentId())) {
                PurchaseAttachmentDTO attachmentDTO = new PurchaseAttachmentDTO();
                attachmentDTO.setId(item.getAttachmentId());
                attachmentDTO.setBusinessType("supplierCertificatedInfo");
                attachmentDTO.setFileName(item.getAttachmentName());
                attachmentDTO.setFilePath(item.getAttachmentPath());
                attachmentDTO.setSaveType(item.getAttachmentSaveType());
                attachmentDTO.setUploadTime(item.getCreateTime());
                attachmentDTO.setUploadElsAccount(item.getElsAccount());
                attachmentDTO.setUploadSubAccount(item.getCreateBy());
                attachments.add(attachmentDTO);
            }
            this.purchaseCertificatedInfoService.saveMain(certificatedInfo, attachments);
        }
        List<String> ids = supplierAccessMgmtQuareviewList.parallelStream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getRelationId())).map(SupplierAccessMgmtQuareview::getRelationId).collect(Collectors.toList());
        List<SupplierAccessMgmtQuareviewItem> quareviewItemList = this.supplierAccessMgmtQuareviewItemService.selectByIds(ids);
        for (SupplierAccessMgmtQuareviewItem quareviewItem : quareviewItemList) {
            quareviewItem.setShiftTo("1");
        }
        if (!quareviewItemList.isEmpty() && quareviewItemList.size() > 0) {
            this.supplierAccessMgmtQuareviewItemService.updateBatchById(quareviewItemList);
        }
        if (!supplierAccessMgmtQuareviewList.isEmpty() && supplierAccessMgmtQuareviewList.size() > 0) {
            this.supplierAccessMgmtQuareviewService.updateBatchById(supplierAccessMgmtQuareviewList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.supplierAccessMgmtQuareviewService.deleteByMainId(id);
        this.supplierAccessMgmtInspectionService.deleteByMainId(id);
        this.supplierAccessMgmtSamplecheckService.deleteByMainId(id);
        this.supplierAccessMgmtAttachmentService.deleteByMainId(id);
        ((SupplierAccessMgmtMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierAccessMgmtQuareviewService.deleteByMainId(serializable.toString());
            this.supplierAccessMgmtInspectionService.deleteByMainId(serializable.toString());
            this.supplierAccessMgmtSamplecheckService.deleteByMainId(serializable.toString());
            this.supplierAccessMgmtAttachmentService.deleteByMainId(serializable.toString());
            ((SupplierAccessMgmtMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public JSONObject getAccessMgmtDataById(String id) {
        SupplierAccessMgmt supplierAccessMgmt = (SupplierAccessMgmt)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)supplierAccessMgmt));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)supplierAccessMgmt, new DictTranslateAspectParam());
        return jsonObject;
    }

    private void insertData(SupplierAccessMgmt supplierAccessMgmt, List<SupplierAccessMgmtQuareview> supplierAccessMgmtQuareviewList, List<SupplierAccessMgmtInspection> supplierAccessMgmtInspectionList, List<SupplierAccessMgmtSamplecheck> supplierAccessMgmtSamplecheckList, List<SupplierAccessMgmtAttachment> supplierAccessMgmtAttachmentList) {
        if (!CollectionUtils.isEmpty(supplierAccessMgmtQuareviewList)) {
            long currentTimeMillis;
            long effectiveDate = currentTimeMillis = System.currentTimeMillis();
            long expiryDate = currentTimeMillis;
            for (SupplierAccessMgmtQuareview entity : supplierAccessMgmtQuareviewList) {
                entity.setId(null);
                entity.setHeadId(supplierAccessMgmt.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)supplierAccessMgmt);
                if (entity.getEffectiveDate() != null) {
                    effectiveDate = entity.getEffectiveDate().getTime();
                }
                if (entity.getExpiryDate() != null) {
                    expiryDate = entity.getExpiryDate().getTime();
                }
                if (!"1".equals(entity.getLimited())) continue;
                if (currentTimeMillis < effectiveDate) {
                    entity.setCertificationStatus("0");
                }
                if (currentTimeMillis > effectiveDate && expiryDate > currentTimeMillis) {
                    entity.setCertificationStatus("1");
                }
                if (currentTimeMillis > expiryDate) {
                    entity.setCertificationStatus("2");
                    continue;
                }
                entity.setCertificationStatus("1");
                if (entity.getEffectiveDate() == null) {
                    entity.setEffectiveDate(this.strToDate("yyyy-MM-dd", 0));
                }
                if (entity.getExpiryDate() != null) continue;
                entity.setExpiryDate(this.strToDate("yyyy-MM-dd", 100));
            }
            this.supplierAccessMgmtQuareviewService.saveBatch(supplierAccessMgmtQuareviewList, 2000);
        }
        if (!CollectionUtils.isEmpty(supplierAccessMgmtInspectionList)) {
            for (SupplierAccessMgmtInspection supplierAccessMgmtInspection : supplierAccessMgmtInspectionList) {
                supplierAccessMgmtInspection.setId(null);
                supplierAccessMgmtInspection.setHeadId(supplierAccessMgmt.getId());
                SysUtil.setSysParam((BaseEntity)supplierAccessMgmtInspection, (BaseEntity)supplierAccessMgmt);
            }
            this.supplierAccessMgmtInspectionService.saveBatch(supplierAccessMgmtInspectionList, 2000);
        }
        if (!CollectionUtils.isEmpty(supplierAccessMgmtSamplecheckList)) {
            for (SupplierAccessMgmtSamplecheck supplierAccessMgmtSamplecheck : supplierAccessMgmtSamplecheckList) {
                supplierAccessMgmtSamplecheck.setId(null);
                supplierAccessMgmtSamplecheck.setHeadId(supplierAccessMgmt.getId());
                SysUtil.setSysParam((BaseEntity)supplierAccessMgmtSamplecheck, (BaseEntity)supplierAccessMgmt);
            }
            this.supplierAccessMgmtSamplecheckService.saveBatch(supplierAccessMgmtSamplecheckList, 2000);
        }
        if (!CollectionUtils.isEmpty(supplierAccessMgmtAttachmentList)) {
            for (SupplierAccessMgmtAttachment supplierAccessMgmtAttachment : supplierAccessMgmtAttachmentList) {
                supplierAccessMgmtAttachment.setId(null);
                supplierAccessMgmtAttachment.setHeadId(supplierAccessMgmt.getId());
                SysUtil.setSysParam((BaseEntity)supplierAccessMgmtAttachment, (BaseEntity)supplierAccessMgmt);
            }
            this.supplierAccessMgmtAttachmentService.saveBatch(supplierAccessMgmtAttachmentList, 2000);
        }
    }

    private Date strToDate(String pattern, int num) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, num);
        Date y = c.getTime();
        return y;
    }

    private void checkCertificationDate(List<SupplierAccessMgmtQuareview> supplierAccessMgmtQuareviewList) {
        if (!CollectionUtils.isEmpty(supplierAccessMgmtQuareviewList)) {
            long effectiveDate = 0L;
            long expiryDate = 0L;
            long certificationDate = 0L;
            for (SupplierAccessMgmtQuareview entity : supplierAccessMgmtQuareviewList) {
                if (!"1".equals(entity.getLimited())) continue;
                if (entity.getEffectiveDate() == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOLVW_f027d72e", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                effectiveDate = entity.getEffectiveDate().getTime();
                if (entity.getExpiryDate() == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAxOLVW_e0d38940", (String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                expiryDate = entity.getExpiryDate().getTime();
                if (entity.getCertificationDate() != null) {
                    certificationDate = entity.getCertificationDate().getTime();
                }
                if (effectiveDate > 0L && expiryDate == 0L) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBASrWKXBAlSW_45dd225c", (String)"\u751f\u6548\u65e5\u671f\u586b\u4e86\uff0c\u5931\u6548\u65e5\u671f\u5fc5\u586b\uff01"));
                }
                if (effectiveDate == 0L && expiryDate > 0L) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBASrWbXBAlSW_5bb2dcf8", (String)"\u5931\u6548\u65e5\u671f\u586b\u4e86\uff0c\u751f\u6548\u65e5\u671f\u5fc5\u586b\uff01"));
                }
                if (effectiveDate > 0L && expiryDate > 0L && (effectiveDate > expiryDate || effectiveDate == expiryDate)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAWlTfUWbXBAW_21db452a", (String)"\u5931\u6548\u65e5\u671f \u5fc5\u987b\u5927\u4e8e \u751f\u6548\u65e5\u671f\uff01"));
                }
                if (certificationDate <= 0L || certificationDate <= effectiveDate) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LiBAWlTXUSEUWbXBAW_2012a69b", (String)"\u8ba4\u8bc1\u65e5\u671f \u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e \u751f\u6548\u65e5\u671f\uff01"));
            }
        }
    }

    public Boolean isExistOrgAndCateCode(SupplierAccessMgmt supplierAccessMgmt) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"els_account", (Object)supplierAccessMgmt.getToElsAccount());
        List orgInfoList = this.supplierOrgInfoMapper.selectList((Wrapper)queryWrapper);
        String[] cateName = supplierAccessMgmt.getCateName().split(",");
        String purchaseOrg = supplierAccessMgmt.getPurchaseOrg();
        for (SupplierOrgInfo info : orgInfoList) {
            if (!purchaseOrg.equals(info.getOrgCode()) || !SupplierAccessMgmtServiceImpl.compareArray(cateName, info.getAccessCategory().replace(";", ",").split(","))) continue;
            return true;
        }
        return false;
    }

    public static boolean compareArray(String[] a, String[] b) {
        String[] news = a;
        int num = 0;
        int n = a.length;
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!b[i].equals(news[j])) continue;
                news[j] = news[n - 1];
                ++num;
                --n;
                break;
            }
            if (num == i + 1) continue;
            return false;
        }
        return num == a.length;
    }
}

