/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.config.mybatis.TenantContext;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.supplier.entity.SupplierAccessPolicy;
import com.els.modules.supplier.mapper.SupplierAccessPolicyMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeOrgRpcService;
import com.els.modules.supplier.service.SupplierAccessPolicyService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierAccessPolicyServiceImpl
extends ServiceImpl<SupplierAccessPolicyMapper, SupplierAccessPolicy>
implements SupplierAccessPolicyService {
    @Autowired
    private SupplierInvokeOrgRpcService supplierInvokeOrgRpcService;

    @Override
    public void saveSupplierAccessPolicy(SupplierAccessPolicy supplierAccessPolicy) {
        supplierAccessPolicy.setDeleted(CommonConstant.DEL_FLAG_0);
        if (StrUtil.isNotBlank((CharSequence)supplierAccessPolicy.getPurchaseOrg())) {
            supplierAccessPolicy.setPurchaseOrgName(this.getTextByCode(supplierAccessPolicy.getPurchaseOrg(), "purchaseOrganization"));
        }
        this.save((Object)supplierAccessPolicy);
    }

    public String getTextByCode(String purchaseOrg, String type) {
        PurchaseOrganizationInfoDTO info = this.supplierInvokeOrgRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), type, purchaseOrg);
        if (info != null) {
            return info.getOrgName();
        }
        return null;
    }

    @Override
    public void updateSupplierAccessPolicy(SupplierAccessPolicy supplierAccessPolicy) {
        if (StrUtil.isNotBlank((CharSequence)supplierAccessPolicy.getPurchaseOrg())) {
            supplierAccessPolicy.setPurchaseOrgName(this.getTextByCode(supplierAccessPolicy.getPurchaseOrg(), "purchaseOrganization"));
        }
        ((SupplierAccessPolicyMapper)this.baseMapper).updateById((Object)supplierAccessPolicy);
    }

    @Override
    public void delSupplierAccessPolicy(String id) {
        ((SupplierAccessPolicyMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSupplierAccessPolicy(List<String> idList) {
        ((SupplierAccessPolicyMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

