/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.order.api.dto.PurchaseOrderPermissionConfigDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterFrozen;
import com.els.modules.supplier.mapper.SupplierMasterFrozenMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.SupplierMasterFrozenService;
import com.els.modules.supplier.vo.PurchaseOrgItemVO;
import com.els.modules.supplier.vo.SupplierItemVO;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.supplier.vo.SupplierMasterFrozenVO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SupplierMasterFrozenServiceImpl
extends BaseServiceImpl<SupplierMasterFrozenMapper, SupplierMasterFrozen>
implements SupplierMasterFrozenService {
    @Lazy
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Lazy
    @Resource
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;

    @Override
    public SupplierMasterFrozen isExistFrozenStateData(List<String> toElsAccountList, String frozenFunction, String orgType, String orgCode) {
        if (CollUtil.isEmpty(toElsAccountList)) {
            return null;
        }
        List<String> operatetTimeList = ((SupplierMasterFrozenMapper)this.baseMapper).getNewestOperatetTimeList(frozenFunction, orgType, orgCode);
        List dictDTOList = new ArrayList();
        if (!operatetTimeList.isEmpty() && operatetTimeList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            queryWrapper.in((Object)"to_els_account", toElsAccountList);
            queryWrapper.eq((Object)"frozen_status", (Object)"1");
            queryWrapper.eq((Object)"is_invalid", (Object)"0");
            queryWrapper.in((Object)"operate_time", operatetTimeList);
            List list = ((SupplierMasterFrozenMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            if (!list.isEmpty() && list.size() > 0) {
                SupplierMasterFrozen frozen = (SupplierMasterFrozen)((Object)list.get(0));
                frozen.setCurrentOrgCode(orgCode);
                if ("0".equals(orgType)) {
                    dictDTOList = ((PurchaseOrganizationInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(PurchaseOrganizationInfoRpcService.class)).listByCategoryCode(TenantContext.getTenant(), "purchaseOrganization");
                    Optional<PurchaseOrganizationInfoDTO> first = dictDTOList.parallelStream().filter(o -> orgCode.equals(o.getOrgCode())).findFirst();
                    if (first.isPresent()) {
                        frozen.setCurrentOrgCodeText(first.get().getOrgName());
                    }
                } else {
                    dictDTOList = ((PurchaseOrganizationInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(PurchaseOrganizationInfoRpcService.class)).listByCategoryCode(TenantContext.getTenant(), "companyCode");
                    Optional<PurchaseOrganizationInfoDTO> first = dictDTOList.parallelStream().filter(o -> orgCode.equals(o.getOrgCode())).findFirst();
                    if (first.isPresent()) {
                        frozen.setCurrentOrgCodeText(first.get().getOrgName());
                    }
                }
                frozen.setFrozenFunctionText(this.getFrozenFunctionText(frozen.getFrozenFunction()));
                return frozen;
            }
        }
        return null;
    }

    @Override
    public SupplierMasterFrozen isExistFrozenSource(SupplierMasterFrozenVO frozenVO) {
        List<PurchaseOrgItemVO> purchaseOrgItemList = frozenVO.getPurchaseOrgItemList();
        List<SupplierItemVO> supplierItemList = frozenVO.getSupplierItemList();
        List<String> toElsAccountList = supplierItemList.parallelStream().map(SupplierItemVO::getToElsAccount).collect(Collectors.toList());
        String cateCode = "";
        String factory = "";
        PurchaseOrderPermissionConfigDTO orderPermissionConfig = null;
        SupplierMasterFrozen frozen = null;
        for (PurchaseOrgItemVO itemVO : purchaseOrgItemList) {
            cateCode = itemVO.getCateCode();
            factory = itemVO.getFactory();
            if (!StrUtil.isNotBlank((CharSequence)cateCode) || !StrUtil.isNotBlank((CharSequence)factory) || (orderPermissionConfig = this.supplierInvokeBaseRpcService.getOrderPermissionConfig(cateCode, factory)) == null || !StrUtil.isNotBlank((CharSequence)orderPermissionConfig.getPurchaseOrg()) || (frozen = this.isExistFrozenStateData(toElsAccountList, "2", "0", orderPermissionConfig.getPurchaseOrg())) == null || !StrUtil.isNotBlank((CharSequence)frozen.getId())) continue;
            break;
        }
        return frozen;
    }

    @Override
    public List<SupplierMasterFrozen> getDataListByHeadidAndIsInvalid(String supplierMasterDataId, String isInvalid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"head_id", (Object)supplierMasterDataId);
        queryWrapper.eq((Object)"is_invalid", (Object)isInvalid);
        queryWrapper.orderByDesc((Object)"create_time");
        List list = ((SupplierMasterFrozenMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public List<String> getFrozenMasterDadaIdList(String frozenFunction, String orgType, String orgCode) {
        List<String> operatetTimeList = ((SupplierMasterFrozenMapper)this.baseMapper).getNewestOperatetTimeList(frozenFunction, orgType, orgCode);
        if (!operatetTimeList.isEmpty() && operatetTimeList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((QueryWrapper)queryWrapper.select((Object[])new String[]{"head_id"})).lambda().eq(SupplierMasterFrozen::getFrozenStatus, (Object)"1")).eq(SupplierMasterFrozen::getIsInvalid, (Object)"0")).in(SupplierMasterFrozen::getOperateTime, operatetTimeList);
            queryWrapper.groupBy((Object)"head_id");
            List list = ((SupplierMasterFrozenMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            List<String> headIdList = list.parallelStream().map(SupplierMasterFrozen::getHeadId).collect(Collectors.toList());
            return headIdList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getFrozenMasterDadaIdListToSource(String purchaseOrgItemList) {
        String[] factoryCateCodeList;
        ArrayList<String> list = new ArrayList<String>();
        for (String str : factoryCateCodeList = purchaseOrgItemList.split(",")) {
            PurchaseOrderPermissionConfigDTO orderPermissionConfig;
            String[] split = str.split(":");
            if (split.length != 2) continue;
            String factory = split[0];
            String cateCode = split[1];
            if (!StrUtil.isNotBlank((CharSequence)factory) || !StrUtil.isNotBlank((CharSequence)cateCode) || (orderPermissionConfig = this.supplierInvokeBaseRpcService.getOrderPermissionConfig(cateCode, factory)) == null || !StrUtil.isNotBlank((CharSequence)orderPermissionConfig.getPurchaseOrg())) continue;
            list.addAll(this.getFrozenMasterDadaIdList("2", "0", orderPermissionConfig.getPurchaseOrg()));
        }
        if (!list.isEmpty() && list.size() > 0) {
            List<String> stringList = list.parallelStream().distinct().collect(Collectors.toList());
            return stringList;
        }
        return list;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<SupplierMasterFrozen> saveMainByMasterId(SupplierMasterData supplierMasterData, SupplierMasterDataVO supplierMasterDataVO) {
        List<SupplierMasterFrozen> oldList = this.getDataListByHeadidAndIsInvalid(supplierMasterData.getId(), "0");
        String frozenFunction = supplierMasterDataVO.getFrozenFunction();
        List supplierMasterFrozenList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)frozenFunction) && frozenFunction.contains("[")) {
            frozenFunction = frozenFunction.replace("\\", "");
            supplierMasterFrozenList = JSONArray.parseArray((String)frozenFunction, SupplierMasterFrozen.class);
        }
        Map<Boolean, List<SupplierMasterFrozen>> mapList = supplierMasterFrozenList.parallelStream().collect(Collectors.partitioningBy(o -> o.getId() == null));
        List<SupplierMasterFrozen> addList = mapList.get(true);
        List<SupplierMasterFrozen> otherList = mapList.get(false);
        List isInvalidList = oldList.parallelStream().filter(vo -> !otherList.parallelStream().map(other -> other.getId()).collect(Collectors.toList()).contains(vo.getId())).collect(Collectors.toList());
        List orgList = ((PurchaseOrganizationInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(PurchaseOrganizationInfoRpcService.class)).listByCategoryCode(TenantContext.getTenant(), "purchaseOrganization");
        List companyList = ((PurchaseOrganizationInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(PurchaseOrganizationInfoRpcService.class)).listByCategoryCode(TenantContext.getTenant(), "companyCode");
        for (SupplierMasterFrozen frozen : addList) {
            StringBuilder textValue;
            String[] split;
            String orgCode;
            List textList;
            List valueList;
            frozen.setHeadId(supplierMasterData.getId());
            frozen.setElsAccount(supplierMasterData.getElsAccount());
            frozen.setToElsAccount(supplierMasterData.getToElsAccount());
            frozen.setSupplierName(supplierMasterData.getSupplierName());
            frozen.setPurchaseName(supplierMasterData.getPurchaseName());
            frozen.setOperateTime(System.currentTimeMillis());
            frozen.setDeleted(0);
            if (StrUtil.isBlank((CharSequence)frozen.getIsInvalid())) {
                frozen.setIsInvalid("0");
            }
            if ("0".equals(frozen.getFrozenFunction()) || "2".equals(frozen.getFrozenFunction()) || "3".equals(frozen.getFrozenFunction())) {
                frozen.setOrgType("0");
                if (StrUtil.isNotBlank((CharSequence)frozen.getIsSelectAll()) && "1".equals(frozen.getIsSelectAll())) {
                    valueList = orgList.parallelStream().map(PurchaseOrganizationInfoDTO::getOrgCode).collect(Collectors.toList());
                    textList = orgList.parallelStream().map(PurchaseOrganizationInfoDTO::getOrgName).collect(Collectors.toList());
                    if (!valueList.isEmpty() && valueList.size() > 0) {
                        frozen.setOrgCode(StrUtil.strip((CharSequence)valueList.toString(), (CharSequence)"[]").replace(" ", ""));
                    }
                    if (!textList.isEmpty() && textList.size() > 0) {
                        frozen.setOrgCodeText(StrUtil.strip((CharSequence)textList.toString(), (CharSequence)"[]"));
                    }
                } else {
                    orgCode = frozen.getOrgCode();
                    split = orgCode.split(",");
                    textValue = new StringBuilder();
                    for (String k : split) {
                        if (textValue != null && !"".equals(textValue.toString())) {
                            textValue.append(",");
                        }
                        textValue.append(orgList.parallelStream().filter(o -> o.getOrgCode().equals(k)).map(PurchaseOrganizationInfoDTO::getOrgName).collect(Collectors.joining()));
                    }
                    frozen.setOrgCodeText(textValue.toString());
                }
            }
            if (!"1".equals(frozen.getFrozenFunction()) && !"4".equals(frozen.getFrozenFunction())) continue;
            frozen.setOrgType("1");
            if (StrUtil.isNotBlank((CharSequence)frozen.getIsSelectAll()) && "1".equals(frozen.getIsSelectAll())) {
                valueList = companyList.parallelStream().map(PurchaseOrganizationInfoDTO::getOrgCode).collect(Collectors.toList());
                textList = companyList.parallelStream().map(PurchaseOrganizationInfoDTO::getOrgName).collect(Collectors.toList());
                if (!valueList.isEmpty() && valueList.size() > 0) {
                    frozen.setOrgCode(StrUtil.strip((CharSequence)valueList.toString(), (CharSequence)"[]").replace(" ", ""));
                }
                if (textList.isEmpty() || textList.size() <= 0) continue;
                frozen.setOrgCodeText(StrUtil.strip((CharSequence)textList.toString(), (CharSequence)"[]"));
                continue;
            }
            orgCode = frozen.getOrgCode();
            split = orgCode.split(",");
            textValue = new StringBuilder();
            for (String k : split) {
                if (textValue != null && !"".equals(textValue.toString())) {
                    textValue.append(",");
                }
                textValue.append(companyList.parallelStream().filter(o -> o.getOrgCode().equals(k)).map(PurchaseOrganizationInfoDTO::getOrgName).collect(Collectors.joining()));
            }
            frozen.setOrgCodeText(textValue.toString());
        }
        if (!addList.isEmpty() && addList.size() > 0) {
            this.saveBatch(addList);
        }
        for (SupplierMasterFrozen frozen : isInvalidList) {
            frozen.setIsInvalid("1");
        }
        if (!isInvalidList.isEmpty() && isInvalidList.size() > 0) {
            this.updateBatchById(isInvalidList);
        }
        List<SupplierMasterFrozen> newList = this.getDataListByHeadidAndIsInvalid(supplierMasterData.getId(), "0");
        return newList;
    }

    @Override
    public void saveSupplierMasterFrozen(SupplierMasterFrozen supplierMasterFrozen) {
        this.save((Object)supplierMasterFrozen);
    }

    @Override
    public void updateSupplierMasterFrozen(SupplierMasterFrozen supplierMasterFrozen) {
        ((SupplierMasterFrozenMapper)this.baseMapper).updateById((Object)supplierMasterFrozen);
    }

    @Override
    public void delSupplierMasterFrozen(String id) {
        ((SupplierMasterFrozenMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSupplierMasterFrozen(List<String> idList) {
        ((SupplierMasterFrozenMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private String getFrozenFunctionText(String frozenFunction) {
        String text = "";
        switch (frozenFunction) {
            case "0": {
                text = "\u8ba2\u5355";
                break;
            }
            case "1": {
                text = "\u5bf9\u8d26";
                break;
            }
            case "2": {
                text = "\u5bfb\u6e90";
                break;
            }
            case "3": {
                text = "\u5408\u540c";
                break;
            }
            case "4": {
                text = "\u4ed8\u6b3e";
                break;
            }
        }
        return text;
    }
}

