/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.vmi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.vmi.entity.VmiBoard;
import com.els.modules.vmi.entity.VmiBoardHis;
import com.els.modules.vmi.entity.VmiInventory;
import com.els.modules.vmi.entity.VmiWaterLine;
import com.els.modules.vmi.mapper.VmiInventoryMapper;
import com.els.modules.vmi.service.VmiBoardHisService;
import com.els.modules.vmi.service.VmiBoardService;
import com.els.modules.vmi.service.VmiInventoryService;
import com.els.modules.vmi.service.VmiWaterLineService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class VmiInventoryServiceImpl
extends BaseOpenServiceImpl<VmiInventoryMapper, VmiInventory, VmiInventory>
implements VmiInventoryService {
    private static String ORGTABLE = "purchase_organization_info";
    private static String TEXT = "org_desc";
    private static String VALUE = "org_code";
    @Autowired
    private VmiWaterLineService vmiWaterLineService;
    @Autowired
    private VmiBoardService vmiBoardService;
    @Autowired
    private VmiBoardHisService vmiBoardHisService;
    @Lazy
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InterfaceUtil interfaceUtil;

    @Override
    public void saveVmiInventory(VmiInventory vmiInventory) {
        this.save((Object)vmiInventory);
    }

    @Override
    public void updateVmiInventory(VmiInventory vmiInventory) {
        ((VmiInventoryMapper)this.baseMapper).updateById((Object)vmiInventory);
    }

    @Override
    public void delVmiInventory(String id) {
        ((VmiInventoryMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchVmiInventory(List<String> idList) {
        ((VmiInventoryMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generateBoard(String elsAccount) {
        List vmiWaterLineList = this.vmiWaterLineService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0));
        List vmiInventorList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0));
        Map<String, List<VmiInventory>> inventoryMap = vmiInventorList.stream().collect(Collectors.groupingBy(o -> {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isNotBlank((CharSequence)o.getFactory())) {
                sb.append(o.getFactory());
            }
            if (StrUtil.isNotBlank((CharSequence)o.getStorageLocation())) {
                sb.append(o.getStorageLocation());
            }
            if (StrUtil.isNotBlank((CharSequence)o.getStorageBin())) {
                sb.append(o.getStorageBin());
            }
            if (StrUtil.isNotBlank((CharSequence)o.getMaterialNumber())) {
                sb.append(o.getMaterialNumber());
            }
            return sb.toString();
        }));
        ArrayList<VmiBoard> boardList = new ArrayList<VmiBoard>();
        Date currentTime = new Date();
        for (VmiWaterLine line : vmiWaterLineList) {
            VmiBoard board = new VmiBoard();
            BeanUtil.copyProperties((Object)((Object)line), (Object)((Object)board), (String[])new String[0]);
            board.setId(null);
            board.setCreateBy("sys");
            board.setCreateTime(currentTime);
            board.setUpdateBy("sys");
            board.setUpdateTime(currentTime);
            board.setElsAccount(elsAccount);
            board.setDeleted(CommonConstant.DEL_FLAG_0);
            board.setMaterialType(null);
            board.setCateCode(null);
            board.setBrand(null);
            board.setLeadTime(null);
            board.setReceivingTime(null);
            board.setWarningPoint(line.getReplenishmentPoints());
            StringBuilder sbKey = new StringBuilder();
            if (StrUtil.isNotBlank((CharSequence)line.getFactory())) {
                sbKey.append(line.getFactory());
            }
            if (StrUtil.isNotBlank((CharSequence)line.getStorageLocation())) {
                sbKey.append(line.getStorageLocation());
            }
            if (StrUtil.isNotBlank((CharSequence)line.getStorageBin())) {
                sbKey.append(line.getStorageBin());
            }
            if (StrUtil.isNotBlank((CharSequence)line.getMaterialNumber())) {
                sbKey.append(line.getMaterialNumber());
            }
            BigDecimal onWayStock = BigDecimal.ZERO;
            BigDecimal urestrictedStock = BigDecimal.ZERO;
            if (inventoryMap.containsKey(sbKey.toString())) {
                for (VmiInventory v : inventoryMap.get(sbKey.toString())) {
                    if (v.getOnWayStock() != null) {
                        onWayStock = onWayStock.add(v.getOnWayStock());
                    }
                    if (v.getUrestrictedStock() == null) continue;
                    urestrictedStock = urestrictedStock.add(v.getUrestrictedStock());
                }
            }
            BigDecimal standingStock = urestrictedStock;
            board.setOnWayQuantity(onWayStock);
            board.setStandingStock(standingStock);
            BigDecimal onWayQuantity = board.getOnWayQuantity() != null ? board.getOnWayQuantity() : BigDecimal.ZERO;
            String supplySource = line.getSupplySource();
            if ("1".equals(supplySource)) {
                board.setSupplyStock(standingStock);
            } else {
                board.setSupplyStock(standingStock.add(onWayQuantity));
            }
            BigDecimal storageUpper = line.getStorageUpper() != null ? line.getStorageUpper() : BigDecimal.ZERO;
            BigDecimal storageDownline = line.getStorageDownline() != null ? line.getStorageDownline() : BigDecimal.ZERO;
            BigDecimal replenishmentPoints = line.getReplenishmentPoints() != null ? line.getReplenishmentPoints() : BigDecimal.ZERO;
            board.setMaxReplenishmentQuantity(storageUpper.subtract(board.getSupplyStock()));
            board.setMinReplenishmentQuantity(replenishmentPoints.subtract(standingStock).subtract(onWayQuantity));
            String warningStandard = line.getWarningStandard();
            if (board.getSupplyStock().compareTo(board.getStorageUpper()) > 0) {
                board.setWarning("\u8d85\u91cf");
            }
            if ("1".equals(warningStandard)) {
                if (board.getSupplyStock().compareTo(board.getStorageDownline()) < 0) {
                    board.setWarning("\u7f3a\u6599");
                }
                if (!(board.getStorageUpper().compareTo(board.getSupplyStock()) <= 0 && board.getStorageUpper().compareTo(board.getSupplyStock()) != 0 || board.getSupplyStock().compareTo(board.getStorageDownline()) <= 0 && board.getSupplyStock().compareTo(board.getStorageDownline()) != 0)) {
                    board.setWarning("\u6b63\u5e38");
                    board.setMinReplenishmentQuantity(null);
                }
            } else {
                if (board.getSupplyStock().compareTo(replenishmentPoints) < 0) {
                    board.setWarning("\u7f3a\u6599");
                }
                if (!(board.getStorageUpper().compareTo(board.getSupplyStock()) <= 0 && board.getStorageUpper().compareTo(board.getSupplyStock()) != 0 || board.getSupplyStock().compareTo(replenishmentPoints) <= 0 && board.getSupplyStock().compareTo(replenishmentPoints) != 0)) {
                    board.setWarning("\u6b63\u5e38");
                    board.setMinReplenishmentQuantity(null);
                }
            }
            this.setFactoryNameAndStorageLocationName(board, line);
            boardList.add(board);
        }
        this.saveHis(elsAccount);
        this.vmiBoardService.deleteByAccount(elsAccount);
        this.vmiBoardService.saveBatch(boardList, 200);
    }

    private void setFactoryNameAndStorageLocationName(VmiBoard vmiBoard, VmiWaterLine vmiWaterLine) {
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getVmiInventory", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List vmiInventoryList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (VmiInventory vmiInventory : vmiInventoryList) {
            String elsAccount = TenantContext.getTenant();
            this.interfaceUtil.callInterface(elsAccount, "pushVmiInventory", (Object)vmiInventory);
        }
    }

    private void saveHis(String elsAccount) {
        List boardList = this.vmiBoardService.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount));
        String versionNumber = DateUtil.formatDateTime((Date)new Date());
        ArrayList<VmiBoardHis> boardHisList = new ArrayList<VmiBoardHis>();
        for (VmiBoard board : boardList) {
            VmiBoardHis his = new VmiBoardHis();
            BeanUtil.copyProperties((Object)((Object)board), (Object)((Object)his), (String[])new String[0]);
            his.setId(null);
            his.setVersionNumber(versionNumber);
            boardHisList.add(his);
        }
        if (!boardHisList.isEmpty()) {
            this.vmiBoardHisService.saveBatch(boardHisList, 200);
        }
    }
}

