/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.platform.system.cache;

import com.els.tso.platform.system.entity.Dept;
import com.els.tso.platform.system.entity.Menu;
import com.els.tso.platform.system.entity.Role;
import com.els.tso.platform.system.entity.Tenant;
import com.els.tso.platform.system.feign.ISysClient;
import com.els.tso.raindrops.core.cache.utils.CacheUtil;
import com.els.tso.raindrops.core.tool.api.R;
import com.els.tso.raindrops.core.tool.utils.SpringUtil;
import java.util.List;

public class SysCache {
    private static final String MENU_ID = "menu:id:";
    private static final String DEPT_ID = "dept:id:";
    private static final String DEPT_NAME_ID = "deptName:id:";
    private static final String DEPT_NAMES_ID = "deptNames:id:";
    private static final String ROLE_ID = "role:id:";
    private static final String ROLE_NAME_ID = "roleName:id:";
    private static final String ROLE_NAMES_ID = "roleNames:id:";
    private static final String ROLE_ALIAS_ID = "roleAlias:id:";
    private static final String ROLE_ALIASES_ID = "roleAliases:id:";
    private static final String TENANT_ID = "tenant:id:";
    private static ISysClient sysClient;

    private static ISysClient getSysClient() {
        if (sysClient == null) {
            sysClient = (ISysClient)SpringUtil.getBean(ISysClient.class);
        }
        return sysClient;
    }

    public static Menu getMenu(Long id) {
        return (Menu)CacheUtil.get((String)"raindrops:sys", (String)MENU_ID, (Object)id, () -> {
            R<Menu> result = SysCache.getSysClient().getMenu(id);
            return (Menu)result.getData();
        });
    }

    public static Dept getDept(Long id) {
        return (Dept)CacheUtil.get((String)"raindrops:sys", (String)DEPT_ID, (Object)id, () -> {
            R<Dept> result = SysCache.getSysClient().getDept(id);
            return (Dept)result.getData();
        });
    }

    public static String getDeptName(Long id) {
        return (String)CacheUtil.get((String)"raindrops:sys", (String)DEPT_NAME_ID, (Object)id, () -> {
            R<String> result = SysCache.getSysClient().getDeptName(id);
            return (String)result.getData();
        });
    }

    public static Role getRole(Long id) {
        return (Role)CacheUtil.get((String)"raindrops:sys", (String)ROLE_ID, (Object)id, () -> {
            R<Role> result = SysCache.getSysClient().getRole(id);
            return (Role)result.getData();
        });
    }

    public static String getRoleName(Long id) {
        return (String)CacheUtil.get((String)"raindrops:sys", (String)ROLE_NAME_ID, (Object)id, () -> {
            R<String> result = SysCache.getSysClient().getRoleName(id);
            return (String)result.getData();
        });
    }

    public static String getRoleAlias(Long id) {
        return (String)CacheUtil.get((String)"raindrops:sys", (String)ROLE_ALIAS_ID, (Object)id, () -> {
            R<String> result = SysCache.getSysClient().getRoleAlias(id);
            return (String)result.getData();
        });
    }

    public static List<String> getDeptNames(String deptIds) {
        return (List)CacheUtil.get((String)"raindrops:sys", (String)DEPT_NAMES_ID, (Object)deptIds, () -> {
            R<List<String>> result = SysCache.getSysClient().getDeptNames(deptIds);
            return (List)result.getData();
        });
    }

    public static List<String> getRoleNames(String roleIds) {
        return (List)CacheUtil.get((String)"raindrops:sys", (String)ROLE_NAMES_ID, (Object)roleIds, () -> {
            R<List<String>> result = SysCache.getSysClient().getRoleNames(roleIds);
            return (List)result.getData();
        });
    }

    public static List<String> getRoleAliases(String roleIds) {
        return (List)CacheUtil.get((String)"raindrops:sys", (String)ROLE_ALIASES_ID, (Object)roleIds, () -> {
            R<List<String>> result = SysCache.getSysClient().getRoleAliases(roleIds);
            return (List)result.getData();
        });
    }

    public static Tenant getTenant(Long id) {
        return (Tenant)((Object)CacheUtil.get((String)"raindrops:sys", (String)TENANT_ID, (Object)id, () -> {
            R<Tenant> result = SysCache.getSysClient().getTenant(id);
            return (Tenant)((Object)((Object)result.getData()));
        }));
    }
}

