/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.raindrops.core.http.cache;

import com.els.tso.raindrops.core.http.cache.HttpCacheAble;
import com.els.tso.raindrops.core.http.cache.HttpCacheService;
import com.els.tso.raindrops.core.tool.utils.ClassUtil;
import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class HttpCacheInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheInterceptor.class);
    private final HttpCacheService httpCacheService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        String method = request.getMethod();
        HttpMethod httpMethod = HttpMethod.resolve((String)method);
        if (httpMethod == null) {
            return true;
        }
        List<HttpMethod> allowList = Arrays.asList(HttpMethod.HEAD, HttpMethod.GET);
        if (allowList.indexOf(httpMethod) == -1) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        HttpCacheAble cacheAble = (HttpCacheAble)ClassUtil.getAnnotation((HandlerMethod)handlerMethod, HttpCacheAble.class);
        if (cacheAble == null) {
            return true;
        }
        long ims = request.getDateHeader("If-Modified-Since");
        long now = Clock.systemUTC().millis();
        long maxAge = cacheAble.maxAge();
        long maxAgeMicros = TimeUnit.SECONDS.toMillis(maxAge);
        String cacheKey = request.getRequestURI() + "?" + request.getQueryString();
        boolean hasCache = this.httpCacheService.get(cacheKey);
        if (hasCache && ims + maxAgeMicros > now) {
            response.setStatus(304);
            response.setHeader("Cache-Control", "max-age=" + maxAge);
            response.addDateHeader("Expires", ims + maxAgeMicros);
            response.addDateHeader("Last-Modified", ims);
            log.info("{} 304 {}", (Object)method, (Object)request.getRequestURI());
            return false;
        }
        response.setHeader("Cache-Control", "max-age=" + maxAge);
        response.addDateHeader("Expires", now + maxAgeMicros);
        response.addDateHeader("Last-Modified", now);
        this.httpCacheService.set(cacheKey);
        return super.preHandle(request, response, handler);
    }

    public HttpCacheInterceptor(HttpCacheService httpCacheService) {
        this.httpCacheService = httpCacheService;
    }
}

